/**
 *
 */
package com.paypalocc.controllers;


import com.paypal.hybris.data.PayPalCheckoutData;
import com.paypal.hybris.data.ws.ApplePayButtonStyleWsDTO;
import com.paypal.hybris.data.ws.PayPalCheckoutWsDTO;
import com.paypal.hybris.data.ws.ApplePaySessionDetailsWsDTO;
import com.paypal.hybris.data.ApplePaySessionDetailsData;
import com.paypal.hybris.facade.facades.StylesConfigurationFacade;
import com.paypal.hybris.facade.facades.impl.DefaultPayPalAcceleratorCheckoutFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoDatas;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commerceservices.request.mapping.annotation.RequestMappingOverride;
import de.hybris.platform.commercewebservicescommons.dto.order.PaymentDetailsListWsDTO;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.servicelayer.session.SessionService;
import de.hybris.platform.paypalhac.data.PayPalHostedFieldsStylesWsDTO;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdAndUserIdParam;
import de.hybris.platform.webservicescommons.swagger.ApiFieldsParam;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.paypal.hybris.data.ws.PayPalButtonStyleWsDTO;
import com.paypal.hybris.facade.facades.PayPalCreditCardFacade;
import com.paypalocc.validators.PayPalPageTypeValidator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.Locale;

@Controller
@RequestMapping(value = "/{baseSiteId}")
@Api(tags = "PayPal Payment")
public class PayPalPaymentController extends PayPalBaseController {

    private static final String LOCALE = "locale";

    @Resource(name = "payPalPageTypeValidator")
    private PayPalPageTypeValidator pageTypeValidator;

    @Resource(name = "defaultStylesConfigurationFacade")
    private StylesConfigurationFacade stylesConfigurationFacade;

    @Resource(name = "defaultPayPalAcceleratorCheckoutFacade")
    private DefaultPayPalAcceleratorCheckoutFacade acceleratorCheckoutFacade;

    @Resource(name = "payPalCreditCardFacade")
    private PayPalCreditCardFacade payPalCreditCardFacade;

    @Resource
    private CartFacade cartFacade;

    @Resource
    private SessionService sessionService;

    @Resource
    private CommonI18NService commonI18NService;

    @GetMapping("/users/{userId}/paypal/payment")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdAndUserIdParam
    @ApiOperation(value = " Get the Paypal data for client-side payment initialization",
            notes = "Get a data for all payment methods")
    public PayPalCheckoutWsDTO getCheckoutData(
            @ApiParam(value = "Button type identifier.", allowableValues = "minicart, cart, mark, account",
                    required = true) @RequestParam final String pageType) {
        final PayPalCheckoutData payPalCheckoutData = acceleratorCheckoutFacade.getPayPalCheckoutData(pageType.toUpperCase(Locale.US));
        return getDataMapper().map(payPalCheckoutData, PayPalCheckoutWsDTO.class);
    }

    @GetMapping("/users/{userId}/paypal/payment/button")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdAndUserIdParam
    @ApiOperation(value = " Get the PayPal Smart Button style data.")
    public PayPalButtonStyleWsDTO getButtonStyle(
            @ApiParam(value = "Button type identifier.", allowableValues = "minicart, cart, mark",
                    required = true) @RequestParam final String pageType) {
        return getDataMapper().map(stylesConfigurationFacade.getPayPalStylesConfiguration(pageType), PayPalButtonStyleWsDTO.class);
    }
    
    @GetMapping("/users/{userId}/paypal/payment/apple-pay/button")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdAndUserIdParam
    @ApiOperation(value = " Get the ApplePay Button style data.")
    public ApplePayButtonStyleWsDTO getApplePayButtonStyle(
            @ApiParam(value = "Button type identifier.", allowableValues = "minicart, cart, mark",
                    required = true) @RequestParam final String pageType) {
        return getDataMapper().map(stylesConfigurationFacade.getApplePayStylesConfiguration(pageType), ApplePayButtonStyleWsDTO.class);
    }

    @GetMapping("/users/{userId}/paypal/payment/hosted-fields")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdAndUserIdParam
    @ApiOperation(value = "Get the Hosted Fields style data.")
    public PayPalHostedFieldsStylesWsDTO getHostedFieldsStyle() {
        return getDataMapper().map(stylesConfigurationFacade.getHostedFieldsStylesConfiguration(),
                PayPalHostedFieldsStylesWsDTO.class);
    }

    @GetMapping("/users/{userId}/carts/{cartId}/payment/applepay")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiOperation(nickname = "getApplePaySessionDetails", value = "Get data for Apple Pay session", notes = "Return data for Apple Pay session.")
    @ApiBaseSiteIdAndUserIdParam
    public ApplePaySessionDetailsWsDTO getApplePaySessionDetails(@ApiParam(value = "Checkout flow identifier.") @RequestParam final String flow) {
        return getDataMapper().map(acceleratorCheckoutFacade.createApplePaySessionDetails(flow), ApplePaySessionDetailsWsDTO.class);
    }

    @Secured({"ROLE_CUSTOMERGROUP", "ROLE_TRUSTED_CLIENT", "ROLE_CUSTOMERMANAGERGROUP"})
    @RequestMapping(value = "/users/{userId}/paymentdetails", method = RequestMethod.GET)
    @ResponseBody
    @ApiOperation(nickname = "getPaymentDetailsList", value = "Get customer's credit card payment details list.", notes = "Return customer's credit card payment details list.")
    @ApiBaseSiteIdAndUserIdParam
    @RequestMappingOverride
    public PaymentDetailsListWsDTO getPaymentDetailsList(
            @ApiParam(value = "Type of payment details.") @RequestParam(defaultValue = "false") final boolean saved,
            @ApiFieldsParam @RequestParam(defaultValue = DEFAULT_FIELD_SET) final String fields) {
        final CCPaymentInfoDatas paymentInfoDataList = new CCPaymentInfoDatas();
        paymentInfoDataList.setPaymentInfos(getUserFacade().getCCPaymentInfos(true));

        return getDataMapper().map(paymentInfoDataList, PaymentDetailsListWsDTO.class, fields);
    }

    @Secured({"ROLE_CUSTOMERGROUP", "ROLE_TRUSTED_CLIENT", "ROLE_CUSTOMERMANAGERGROUP"})
    @RequestMapping(value = "/users/{userId}/paymentdetails/{paymentDetailsId}", method = RequestMethod.DELETE)
    @ApiOperation(nickname = "removePaymentDetails", value = "Deletes customer's credit card payment details.", notes = "Deletes a customer's credit card payment details based on a specified paymentDetailsId.")
    @ApiBaseSiteIdAndUserIdParam
    @ResponseStatus(HttpStatus.OK)
    @RequestMappingOverride
    public void deletePaymentDetails(
            @ApiParam(value = "Payment details identifier.", required = true) @PathVariable final String paymentDetailsId) {
        payPalCreditCardFacade.deleteCreditCardFromPayPal(paymentDetailsId);
    }
}
