/*

 */
package com.paypalocc.controllers;

import com.paypalocc.helpers.OrdersHelper;
import de.hybris.platform.commerceservices.request.mapping.annotation.RequestMappingOverride;
import de.hybris.platform.commercewebservicescommons.dto.order.OrderHistoryListWsDTO;
import de.hybris.platform.webservicescommons.cache.CacheControl;
import de.hybris.platform.webservicescommons.cache.CacheControlDirective;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdAndUserIdParam;
import de.hybris.platform.webservicescommons.swagger.ApiFieldsParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value = "/{baseSiteId}")
@Api(tags = "PayPal Orders")
public class PayPalOrderHistoryController extends PayPalBaseController {

    @Resource(name = "paypalOrdersHelper")
    private OrdersHelper ordersHelper;

    @Secured({"ROLE_CUSTOMERGROUP", "ROLE_TRUSTED_CLIENT", "ROLE_CUSTOMERMANAGERGROUP"})
    @CacheControl(directive = CacheControlDirective.NO_CACHE)
    @RequestMapping(value = "/users/{userId}/orders", method = RequestMethod.GET)
    @RequestMappingOverride
    @ResponseBody
    @ApiOperation(nickname = "getUserOrderHistory", value = "Get order history for user.", notes = "Returns order history data for all orders placed by a specified user for a specified base store. The response can display the results across multiple pages, if required.")
    @ApiBaseSiteIdAndUserIdParam
    public OrderHistoryListWsDTO getUserOrderHistory(
            @ApiParam(value = "Filters only certain order statuses. For example, statuses=CANCELLED,CHECKED_VALID would only return orders with status CANCELLED or CHECKED_VALID.") @RequestParam(required = false) final String statuses,
            @ApiParam(value = "The current result page requested.") @RequestParam(defaultValue = DEFAULT_CURRENT_PAGE) final int currentPage,
            @ApiParam(value = "The number of results returned per page.") @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) final int pageSize,
            @ApiParam(value = "Sorting method applied to the return results.") @RequestParam(required = false) final String sort,
            @ApiFieldsParam @RequestParam(defaultValue = DEFAULT_FIELD_SET) final String fields,
            final HttpServletResponse response) {
        validateStatusesEnumValue(statuses);

        final OrderHistoryListWsDTO orderHistoryList = ordersHelper
                .searchOrderHistory(statuses, currentPage, pageSize, sort, addPaginationField(fields));

        setTotalCountHeader(response, orderHistoryList.getPagination());

        return orderHistoryList;
    }

}
