package com.paypalocc.controllers;

import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.commercewebservicescommons.dto.search.pagedata.PaginationWsDTO;
import de.hybris.platform.webservicescommons.errors.exceptions.WebserviceValidationException;
import de.hybris.platform.webservicescommons.mapping.DataMapper;
import de.hybris.platform.webservicescommons.mapping.FieldSetLevelHelper;
import de.hybris.platform.webservicescommons.util.YSanitizer;
import de.hybris.platform.webservicescommons.validators.EnumValueValidator;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import static com.paypalocc.constants.PaypaloccWebConstants.ENUM_VALUES_SEPARATOR;

@Controller
public class PayPalBaseController  {
    protected static final String DEFAULT_PAGE_SIZE = "20";
    protected static final String DEFAULT_CURRENT_PAGE = "0";
    protected static final String DEFAULT_FIELD_SET = FieldSetLevelHelper.DEFAULT_LEVEL;
    protected static final String HEADER_TOTAL_COUNT = "X-Total-Count";

    @Resource(name = "dataMapper")
    private DataMapper dataMapper;

    @Resource(name = "userFacade")
    private UserFacade userFacade;
    @Resource(name = "orderStatusValueValidator")
    private EnumValueValidator orderStatusValueValidator;

    protected static String sanitize(final String input) {
        return YSanitizer.sanitize(input);
    }

    protected void validate(final Object object, final String objectName, final Validator validator) {
        final Errors errors = new BeanPropertyBindingResult(object, objectName);
        validator.validate(object, errors);
        if (errors.hasErrors()) {
            throw new WebserviceValidationException(errors);
        }
    }

    /**
     * Adds pagination field to the 'fields' parameter
     *
     * @param fields
     * @return fields with pagination
     */
    protected String addPaginationField(final String fields) {
        String fieldsWithPagination = fields;

        if (StringUtils.isNotBlank(fieldsWithPagination)) {
            fieldsWithPagination += ",";
        }
        fieldsWithPagination += "pagination";

        return fieldsWithPagination;
    }

    protected void setTotalCountHeader(final HttpServletResponse response, final PaginationWsDTO paginationDto) {
        if (paginationDto != null && paginationDto.getTotalResults() != null) {
            response.setHeader(HEADER_TOTAL_COUNT, String.valueOf(paginationDto.getTotalResults()));
        }
    }

    /**
     * Checks if given statuses are valid
     *
     * @param statuses
     */
    protected void validateStatusesEnumValue(final String statuses) {
        if (statuses == null) {
            return;
        }

        final String[] statusesStrings = statuses.split(ENUM_VALUES_SEPARATOR);
        validate(statusesStrings, "", orderStatusValueValidator);
    }

    protected DataMapper getDataMapper() {
        return dataMapper;
    }

    protected UserFacade getUserFacade() {
        return userFacade;
    }
}
