package com.paypalb2bocc.validators;

import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.springframework.validation.Errors;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoInteractions;

@UnitTest
public class PayPalB2BPageTypeValidatorTest {

    private static final String VALID_PAGE_TYPE = "MINICART";
    private static final String INVALID_PAGE_TYPE = "INVALID_PAGE_TYPE";
    private static final String INCORRECT_PAGE_TYPE = "Incorrect pageType parameter";
    @Mock
    private Errors errors;
    @InjectMocks
    @Spy
    private PayPalB2BPageTypeValidator unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldSupportClass() {
        Assert.assertTrue(unit.supports(String.class));
    }

    @Test
    public void shouldNotSupportClass() {
        Assert.assertFalse(unit.supports(Object.class));
    }

    @Test
    public void shouldPassWhenLegalPageTypeTest() {
        unit.validate(VALID_PAGE_TYPE, errors);
        verifyNoInteractions(errors);
    }

    @Test
    public void shouldErrorWhenIllegalPageType() {
        unit.validate(INVALID_PAGE_TYPE, errors);
        verify(errors).reject(INVALID_PAGE_TYPE, INCORRECT_PAGE_TYPE);
    }

}
