package com.paypal.hybris.b2baddon.renderer;

import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.cms2.model.contents.components.AbstractCMSComponentModel;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.servicelayer.model.ModelService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import javax.servlet.jsp.PageContext;
import java.util.Collections;
import java.util.Map;

import static org.junit.Assert.assertEquals;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalB2bDefaultAddOnCMSComponentRendererTest {

    private static final String PROPERTY_NAME = "propertyName";
    private static final String PROPERTY_VALUE = "propertyValue";
    private static final String CLIENT_ID = "clientId";
    private static final String INTENT = "intent";
    private static final String COMMIT = "commit";
    private static final String PAYPAL_SDK_URL = "paypalSDKUrl";
    private static final String PARTNER_ATTRIBUTION_ID = "partnerAttributionId";

    @InjectMocks
    private PayPalB2bDefaultAddOnCMSComponentRenderer<AbstractCMSComponentModel> unit;
    @Mock
    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;
    @Mock
    private ModelService modelService;
    @Mock
    private CMSComponentService cmsComponentService;
    @Mock
    private AbstractCMSComponentModel componentModel;
    @Mock
    private PageContext pageContext;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldExposeVariables() {
        when(cmsComponentService.getReadableEditorProperties(any())).thenReturn(Collections.singletonList(PROPERTY_NAME));
        when(modelService.getAttributeValue(componentModel, PROPERTY_NAME)).thenReturn(PROPERTY_VALUE);
        when(defaultPayPalConfigurationService.getPayPalIntent()).thenReturn(INTENT);
        when(defaultPayPalConfigurationService.getClientID()).thenReturn(CLIENT_ID);
        when(defaultPayPalConfigurationService.getPayPalPartnerAttributionId()).thenReturn(PARTNER_ATTRIBUTION_ID);
        when(defaultPayPalConfigurationService.getPayPalSdkJsUrl()).thenReturn(PAYPAL_SDK_URL);
        when(defaultPayPalConfigurationService.isCommitEnabled()).thenReturn(Boolean.TRUE);

        Map<String, Object> result = unit.exposeVariables(pageContext, componentModel);

        verify(pageContext).setAttribute(PROPERTY_NAME, PROPERTY_VALUE, PageContext.REQUEST_SCOPE);
        verify(pageContext).setAttribute(INTENT, INTENT, PageContext.REQUEST_SCOPE);
        verify(pageContext).setAttribute(CLIENT_ID, CLIENT_ID, PageContext.REQUEST_SCOPE);
        verify(pageContext).setAttribute(PARTNER_ATTRIBUTION_ID, PARTNER_ATTRIBUTION_ID, PageContext.REQUEST_SCOPE);
        verify(pageContext).setAttribute(PAYPAL_SDK_URL, PAYPAL_SDK_URL, PageContext.REQUEST_SCOPE);
        verify(pageContext).setAttribute(COMMIT, Boolean.TRUE, PageContext.REQUEST_SCOPE);

        assertEquals(1, result.size());
        assertEquals(PROPERTY_VALUE, result.get(PROPERTY_NAME));
    }
}
