ACC.hostedfieldschekout = {

    _autoload: [
        "assignEventListenerForUseDeliveryAddressCheckbox",
        ["renderHostedFields", $("#hosted-button-container").length !== 0]
    ],

    renderHostedFields: async function () {
        await ACC.paypalSDKloader.paypalSDKPromise;
        try {
            ACC.hostedfieldschekout.createHostedFields();
        } catch (err) {
            ACC.paypalutil.handlePayPalClientError("paypal.button.render.error" + err.message);
        }
    },

    get3dsVerificationType: function (){
        const threeDsVerificationType = ACC.addons.paypalb2baddon.threeDSVerificationType;
        if(threeDsVerificationType === "ALWAYS"){
            return PAYPAL_CONSTANTS.THREE_DS.SCA_ALWAYS;
        } else if (threeDsVerificationType === "AUTO"){
            return PAYPAL_CONSTANTS.THREE_DS.SCA_WHEN_REQUIRED;
        } else {
            return PAYPAL_CONSTANTS.THREE_DS.NONE;
        }
    },

    getBillingAddress: function (){
        return {
            line1: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.LINE_1).value,
            line2: document.getElementById(
                PAYPAL_CONSTANTS.BILLING_ADDRESS.LINE_2
            ).value,
            region: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.REGION) === null
                ? null
                : document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.REGION).value,
            city: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.TOWN_CITY)
                .value,
            postalCode: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.POSTCODE)
                .value,
            countryCode: document.getElementById(
                PAYPAL_CONSTANTS.BILLING_ADDRESS.COUNTRY
            ).value,
            firstName: document.getElementById(
                PAYPAL_CONSTANTS.BILLING_ADDRESS.FIRST_NAME
            ).value,
            lastName: document.getElementById(
                PAYPAL_CONSTANTS.BILLING_ADDRESS.SURNAME
            ).value,
            phone: document.getElementById(
                PAYPAL_CONSTANTS.BILLING_ADDRESS.PHONE
            ).value,
        };
    },

    getHostedFieldsData: function (){
        return {
            nameOnCard: document.getElementById("card-holder-name").value,
            billingAddress: ACC.hostedfieldschekout.getBillingAddress(),
            isShouldBeSaved: this.isSaveBoxSaved()
        }
    },

    dataVerification: function(cardFields) {

        var dataVerified = true;

        const state = cardFields.getState();
        const fields = [state.fields.number, state.fields.cvv, state.fields.expirationDate];
        const fieldNames = Object.keys(state.fields);
        for (let i = 0; i < fields.length; i++) {
            const field = fields[i];
            const element = document.getElementById(field.container.id);
            if (field.isEmpty || !field.isValid) {
                element.classList.add('fieldError');
                cardFields.addClass(fieldNames[i], 'invalid');
                dataVerified = false;
            } else {
                element.classList.remove('fieldError');
                cardFields.removeClass(fieldNames[i], 'invalid');
            }
        }

        var cardHolderName = document.getElementById(PAYPAL_CONSTANTS.HOSTED_FIELDS.CARD_HOLDER_NAME);
        var addressLine1 = document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.LINE_1);
        var addressRegion = document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.REGION);
        var addressTownCity = document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.TOWN_CITY);
        var addressPostcode = document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.POSTCODE);
        var addressCountry = document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.COUNTRY);
        var addressFirstName = document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.FIRST_NAME);
        var addressSurname = document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.SURNAME);

        dataVerified = this.isDataVerified(cardHolderName, dataVerified);
        dataVerified = this.isDataVerified(addressLine1, dataVerified);
        dataVerified = this.isDataVerified(addressTownCity, dataVerified);
        dataVerified = this.isDataVerified(addressCountry, dataVerified);
        dataVerified = this.isDataVerified(addressFirstName, dataVerified);
        dataVerified = this.isDataVerified(addressSurname, dataVerified);
        dataVerified = this.isDataVerified(addressPostcode, dataVerified);

        if (addressRegion !== undefined){
            dataVerified = this.isDataVerified(addressRegion, dataVerified);
        }

        return dataVerified;
    },

    isDataVerified: function (data, dataVerified) {
        if (data?.value?.trim() === '') {
            data.classList.add('fieldError');
            dataVerified = false;
        } else {
            data?.classList?.remove('fieldError');
        }
        return dataVerified;
    },
    
    shouldShowSavedMessage: function (payload) {
        if (!this.isThreeDSVerificationFailed(payload)
            && this.isSaveBoxSaved()) {
            localStorage.setItem('savedInfoMessage', 'successfully.card.verification');
        }
    },

    isThreeDSVerificationFailed: function (payload) {
        return payload.liabilityShift !== undefined
            && payload.liabilityShift === PAYPAL_CONSTANTS.THREE_DS.LIABILITY_SHIFT_UNKNOWN;
    },

    resolveAuthenticationReason: function (authenticationReason) {
        return authenticationReason === 'SKIPPED_BY_BUYER' ? '3ds.popup.cancelled' : "3ds.validation.failed";
    },

    resolveErrorMessage: function (errorName) {
        let message = PAYPAL_CONSTANTS.ERRORS.ON_PAYPAL_SIDE;
        if (errorName === 'INVALID_REQUEST' || errorName === 'UNPROCESSABLE_ENTITY') {
            message = PAYPAL_CONSTANTS.ERRORS.INVALID_PAYMENT_DETAILS;
        }
        return message;
    },

    isSaveBoxSaved: function () {
        return document.getElementById('saveHostedFieldsPaymentInfoCheckbox')?.checked ?? false;
    },

    createHostedFields: function (){
        const commit = ACC.addons.paypalb2baddon.commit;
        const fundingSource = "paypal_hosted_fields_card";
        // If this returns false or the card fields aren't visible, see Step #1.
        if (paypal.HostedFields.isEligible()) {

        document.getElementById("card-holder-name").style.fontSize = hostedFieldsStylesConf.fontSize;

            // Renders card fields
            paypal.HostedFields.render({
                // Call your server to set up the transaction
                createOrder: () => {
                    const createOrderUrl = PAYPAL_CONSTANTS.CREATE_ORDER_URL;
                    const requestData = JSON.stringify(
                        {
                            "flow": "MARK_CHECKOUT",
                            "funding": fundingSource,
                            "hostedFieldsData": ACC.hostedfieldschekout.getHostedFieldsData()
                        });
                    const createOrderRequest = {
                        url: createOrderUrl, data: requestData,
                        contentType: "application/json; charset=utf-8"
                    }
                    return $.post(createOrderRequest).then(function (res) {
                        return res;
                    })
                },
                styles: {
                   'input': {
                      'font-size': hostedFieldsStylesConf.fontSize,
                      'color': hostedFieldsStylesConf.inputColor,
                    },
                    '.number': {
                      'font-family': 'helvetica',
                      'font-size': hostedFieldsStylesConf.fontSize
                    },
                    '.text': {
                      'font-size': hostedFieldsStylesConf.fontSize
                    },
                     ':focus': {
                      'color': '#333333'
                    },
                    '.valid': {
                        color: hostedFieldsStylesConf.validColor
                    },
                    '.invalid': {
                        color: hostedFieldsStylesConf.invalidColor
                    }
                },
                fields: {
                    number: {
                        selector: "#card-number",
                        placeholder: "Card number"
                    },
                    cvv: {
                        selector: "#cvv",
                        placeholder: "CVV"
                    },
                    expirationDate: {
                        selector: "#expiration-date",
                        placeholder: "MM/YYYY"
                    }
                }
            }).then((cardFields) => {
                document.querySelector("#submit").addEventListener('click', (event) => {
                    const hostedFieldsContainer = 'hosted-button-container';
                    ACC.loadingSpinner.showSpinner(hostedFieldsContainer);
                    var submitButton = document.getElementById("submit");
                    submitButton.disabled = true;

                    var verified = ACC.hostedfieldschekout.dataVerification(cardFields);

                    if (verified) {
                        event.preventDefault();
                        const threeDsVerificationType = ACC.hostedfieldschekout.get3dsVerificationType();
                        cardFields
                            .submit({
                                cardholderName: document.getElementById("card-holder-name").value,
                                billingAddress: {
                                    streetAddress: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.LINE_1).value,
                                    extendedAddress: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.LINE_2).value,
                                    region: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.REGION)?.value ?? null,
                                    locality: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.TOWN_CITY).value,
                                    postalCode: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.POSTCODE).value,
                                    countryCodeAlpha2: document.getElementById(PAYPAL_CONSTANTS.BILLING_ADDRESS.COUNTRY).value,
                                },
                                contingencies: threeDsVerificationType === 'NONE'
                                    ? null
                                    : [threeDsVerificationType]
                            })
                            .then((payload) => {
                                if (this.isThreeDSVerificationFailed(payload)) {
                                    const message = this.resolveAuthenticationReason(payload.authenticationReason);
                                    ACC.paypalutil.handlePayPalClientError(message);
                                    submitButton.disabled = false;
                                    ACC.loadingSpinner.hideSpinner(hostedFieldsContainer);
                                } else {
                                    const requestData = JSON.stringify(
                                        {
                                            "flow": "MARK_CHECKOUT",
                                            "commit": commit,
                                            "funding": fundingSource,
                                            "billingAddress": ACC.hostedfieldschekout.getBillingAddress()
                                        });

                                    const responseRequest = {
                                        url: PAYPAL_CONSTANTS.MARK_PROCESS_URL, data: requestData,
                                        contentType: "application/json; charset=utf-8"
                                    }

                                    return $.post(responseRequest).then(function (res) {
                                        ACC.hostedfieldschekout.shouldShowSavedMessage(payload);
                                        const url = PAYPAL_CONSTANTS.CONTEXT_PATH + res;
                                        window.location.replace(url);
                                    }).catch(function (err) {
                                        ACC.paypalutil.handlePayPalClientError(err.responseJSON);
                                        submitButton.disabled = false;
                                        ACC.loadingSpinner.hideSpinner(hostedFieldsContainer);
                                    });
                                }
                            })
                            .catch((err) => {
                                console.log(err);
                                ACC.paypalutil.handlePayPalClientError(this.resolveErrorMessage(err.name));
                                submitButton.disabled = false;
                                ACC.loadingSpinner.hideSpinner(hostedFieldsContainer);
                            });
                    } else {
                        ACC.paypalutil.handlePayPalClientError(PAYPAL_CONSTANTS.ERRORS.INVALID_PAYMENT_DETAILS);
                        console.error(ACC.addons.paypalb2baddon[PAYPAL_CONSTANTS.ERRORS.INVALID_PAYMENT_DETAILS]);
                        submitButton.disabled = false;
                        ACC.loadingSpinner.hideSpinner(hostedFieldsContainer);
                    }
                });
            });
        } else {
            // Hides card fields if the merchant isn't eligible
            document.querySelector("#card-form").style = 'display: none';
        }

    },

    assignEventListenerForUseDeliveryAddressCheckbox: function () {
        const checkbox = document.getElementById('useDeliveryAddress');
        if (checkbox !== null) {
            onUseDeliveryAddressChange();
        }
        checkbox?.setAttribute("onchange", "onUseDeliveryAddressChange()");
    }
}