ACC.expresscheckout = {
    _autoload: [
        ["renderExpressCheckoutButtons", $('#express-paypal-buttons-container').length !== 0]
    ],

    renderExpressCheckoutButtons: async function () {
        ACC.expresscheckout.renderButtons('#express-paypal-buttons-container', 'express-checkout');
    },

    renderButtons: async function (container, callPlace) {
        await ACC.paypalSDKloader.paypalSDKPromise;
        try {
            if(isPayPalEnableExpress) {
                payPalFundingOnExpressCheckout.filter(funding => ACC.expresscheckout.filterCardFunding(funding)).forEach(function (funding) {
                    ACC.paypalstandalonebutton.renderMarkButton(funding, ACC.expresscheckout.getContainerId(funding, callPlace), PAYPAL_CONSTANTS.FLOWS.EXPRESS_CHECKOUT, paypalButtonConfig);
                });
            }
            if (venmoEnable)
            {
                ACC.paypalstandalonebutton.renderMarkButton('venmo', container, PAYPAL_CONSTANTS.FLOWS.EXPRESS_CHECKOUT);
            }
        } catch (err) {
            ACC.expresscheckout.handleError("paypal.button.render.error" + err.message);
        }
    },

    handleError: function (message) {
        $("#errorMessage span").text(message);
    },

    getContainerId: function (funding, callPlace) {
        return '#' + funding + '-' + callPlace + '-render-btn-container';
    },

    filterCardFunding: function (funding) {
      if (isChangePaymentButtonEnabled) {
        return funding !== PAYPAL_CONSTANTS.FUNDINGS.CARD;
      }
      return true;
    }
}
