<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="template" tagdir="/WEB-INF/tags/responsive/template"%>
<spring:url value="/" var="homeUrl"/>
<spring:theme code="paypal.button.render.error" var="buttonError"/>
<spring:theme code="wrong.sent.parameters" var="errorMessage"/>
<spring:theme code="error.on.paypal.side" var="paypalError"/>

<template:page pageTitle="${pageTitle}" hideHeaderLinks="true">
    <jsp:body>
        <c:choose>
            <c:when test="${not shouldSavePaymentInfo}">
                <div class="save-payment-info-container">
                    <p id="save-payment-info-text">
                        <spring:theme code="paypal.connect.registration.save.address.info"/>
                    </p>
                    <div class="save-payment-info">
                        <div class="save-payment-info-form-action row">
                            <form:form method="POST" action="${homeUrl}${vaultProcessUrl}">
                                <button data-theme="b" type="submit"
                                    class="save-payment-info-button btn btn-primary btn-block"> Yes </button>
                            </form:form>
                            <form:form method="POST" action="${homeUrl}${savePaymentInfoUrl}">
                                <button data-theme="b" type="submit"
                                    class="save-payment-info-button btn btn-primary btn-block"> No </button>
                                <div id="errorMessage"><span></span></div>
                            </form:form>
                        </div>
                    </div>
                </div>
            </c:when>
        <c:otherwise>
        <div class="save-payment-info-container">
            <form:form method="POST"
                       action="${homeUrl}${savePaymentInfoUrl}">
                <p id="save-payment-info-text">
                    <c:choose>
                        <c:when test="${not shouldSaveAddress}">
                            <spring:theme code="paypal.connect.registration.save.payment.info"/>
                        </c:when>
                        <c:otherwise>
                            <spring:theme code="paypal.connect.registration.save.payment.address.info"/>
                        </c:otherwise>
                    </c:choose>
                </p>
                <div class="save-payment-info">
                    <div class="save-payment-info-form-action row">
                        <div id="paypalConnectAddPaymentBtn"></div>
                        <button data-theme="b" type="submit"
                                class="save-payment-info-button btn btn-primary btn-block"> Yes </button>
                        <button data-theme="b" type="submit"
                                class="save-payment-info-button btn btn-primary btn-block"> No </button>
                        <div id="errorMessage"><span></span></div>
                    </div>
                </div>

            </form:form>

            <form:form id="savePaymentInfo" method="POST" action="${homeUrl}${vaultProcessUrl}">
                             <input type="hidden" name="setupToken" id="setupToken"/>
                             <input type="hidden" name="customerId" id="customerId"/>
                             <input type="hidden" name="paymentInfoPK" id="paymentInfoPK"/>
            </form:form>

        </div>
        </c:otherwise>
        </c:choose>
    </jsp:body>
</template:page>
