<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="template" tagdir="/WEB-INF/tags/addons/b2bacceleratoraddon/responsive/secureportal/sptemplate"%>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags"%>
<%@ taglib prefix="fragments" tagdir="/WEB-INF/tags/addons/paypalb2baddon/responsive/login"%>

<spring:url value="/" var="homeUrl"/>

<template:page pageTitle="${pageTitle}">

    <fragments:accountConnectCancelPopup />

    <div class="container" id="additional-security-container">
        <form:form id="accountConnectVerification" action="${homeUrl}/connect/password/verification/j_spring_security_check" method="POST">
            <div class="container">
                <c:if test="${not empty message}">
                            <span class="has-error"> <springs:theme code="${message}" />
                            </span>
                </c:if>
                <fieldset class="password-field-set">
                    <legend><spring:theme code="paypal.connect.password.verification.info" arguments="${[baseSiteName, email]}"/></legend>

                    <input type="hidden" name="j_username" value="${email}"/>
                    <label class="control-label " for="j_password"> Password </label>
                    <input type="password" name="j_password" id="j_password" class=" form-control"/>

                    <div class = "forgotten-password">
                        <ycommerce:testId code="login_forgotPassword_link">
                            <a href="#" data-link="<c:url value='/login/pw/request'/>" class="js-password-forgotten" data-cbox-title="<spring:theme code="forgottenPwd.title"/>">
                                <spring:theme code="login.link.forgottenPwd" />
                            </a>
                        </ycommerce:testId>
                    </div>

                    <div class = "form-buttons">
                        <button data-theme="b" type="submit" class="btn btn-primary btn-block" onClick='onASLSubmitClick()'> Confirm </button>
                        <button data-theme="b" type="button" class="btn btn-default btn-block" onClick='showCancelModalWindow()'> Cancel </button>
                    </div>
                </fieldset>
            </div>
        </form:form>
    </div>
</template:page>