<%@ page trimDirectiveWhitespaces="true" contentType="application/json" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="theme" tagdir="/WEB-INF/tags/shared/theme" %>
<%@ taglib prefix="express" tagdir="/WEB-INF/tags/addons/paypalb2baddon/responsive/checkout/express" %>
<%@ taglib prefix="format" tagdir="/WEB-INF/tags/shared/format" %>
<%@ taglib prefix="product" tagdir="/WEB-INF/tags/responsive/product" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags"%>
<%@ taglib prefix="cart" tagdir="/WEB-INF/tags/responsive/cart" %>

<c:set var="isAnonymousUser" scope="session" value="${isAnonymousUser}"/>
<c:set var="cartTotalPrice" value="${fn:escapeXml(cartDataTotalPrice.value)}" />
<c:set var="cartCurrencyIso" value="${fn:escapeXml(cartDataTotalPrice.currencyIso)}" />

{"cartData": {
"total": "${cartData.totalPrice.value}",
"products": [
<c:forEach items="${cartData.entries}" var="cartEntry" varStatus="status">
	{
		"sku":		"${cartEntry.product.code}",
		"name": 	"<c:out value='${cartEntry.product.name}' />",
		"qty": 		"${cartEntry.quantity}",
		"price": 	"${cartEntry.basePrice.value}",
		"categories": [
		<c:forEach items="${cartEntry.product.categories}" var="category" varStatus="categoryStatus">
			"<c:out value='${category.name}' />"<c:if test="${not categoryStatus.last}">,</c:if>
		</c:forEach>
		]
	}<c:if test="${not status.last}">,</c:if>
</c:forEach>
]
},

"quickOrderErrorData": [
<c:forEach items="${quickOrderErrorData}" var="quickOrderEntry" varStatus="status">
	{
		"sku":		"${quickOrderEntry.productData.code}",
		"errorMsg": "<spring:theme code='${quickOrderEntry.errorMsg}' htmlEscape='true' />"
	}<c:if test="${not status.last}">,</c:if>
</c:forEach>
],

"cartAnalyticsData":{"cartCode" : "${cartCode}","productPostPrice":"${entry.basePrice.value}","productName":"<c:out value='${product.name}' />"}
,
"addToCartLayer":"<spring:escapeBody javaScriptEscape="true">
	<spring:theme code="text.addToCart" var="addToCartText"/>
	<c:url value="/cart" var="cartUrl"/>
	<c:url value="/cart/checkout" var="checkoutUrl"/>
	<ycommerce:testId code="addToCartPopup">
		<script>
		    $("#checkout-js").remove();
		    $("#paypal-js").remove();
		</script>
		<div id="addToCartLayer" class="add-to-cart">
            <div class="cart_popup_error_msg">
                <c:choose>
	                <c:when test="${quickOrderErrorData ne null and not empty quickOrderErrorData}">
	                	<spring:theme code="${quickOrderErrorMsg}" arguments="${fn:length(quickOrderErrorData)}" htmlEscape="true" />
                    </c:when>
                    <c:when test="${multidErrorMsgs ne null and not empty multidErrorMsgs}">
                        <c:forEach items="${multidErrorMsgs}" var="multidErrorMsg">
                            <spring:theme code="${multidErrorMsg}" />
                        </br>
                        </c:forEach>
                    </c:when>
                    <c:otherwise>
                        <spring:theme code="${errorMsg}" />
                    </c:otherwise>
                </c:choose>
            </div>

            <c:choose>
                <c:when test="${modifications ne null}">
                    <c:forEach items="${modifications}" var="modification">
                        <c:set var="product" value="${modification.entry.product}" />
                        <c:set var="entry" value="${modification.entry}" />
                        <c:set var="quantity" value="${modification.quantityAdded}" />
                        <cart:popupCartItems entry="${entry}" product="${product}" quantity="${quantity}"/>
                    </c:forEach>
                </c:when>
                <c:otherwise>
                    <cart:popupCartItems entry="${entry}" product="${product}" quantity="${quantity}"/>
                </c:otherwise>
            </c:choose>

            <div class="cartPopupButtons btn-block add-to-cart-button addToCartPopupButtons">
                <c:choose>
                    <c:when test="${not empty expressCheckoutComponent and !isAnonymousUser}">
                        <div id="paypal-buttons">
                            <cms:component component="${expressCheckoutComponent}" evaluateRestriction="true"/>
                        </div>
                    </c:when>
                    <c:otherwise>
                        <div id="paypal-buttons">
                            <express:paypalexpressbuttons paypalRenderBtnContainer="minicart-render-btn-container" callPlace="add-to-cart"/>
                            <script>
                                ACC.expresscheckout.renderButtons("#minicart-render-btn-container", "add-to-cart");
                                ACC.applepaycheckout.renderApplePayButton("add-to-cart");
                            </script>
                        </div>
                    </c:otherwise>
                </c:choose>
                <script>
                  if(!${payPalPluginConfiguration.payPalConfigurationData.expressCheckoutEnable})
                    document.getElementById("paypal-buttons").style.display = "none"
                </script>
            </div>
            <input type="hidden" name="cartTotalPrice" value="${cartTotalPrice}">
            <input type="hidden" name="cartCurrencyIso" value="${cartCurrencyIso}">

            <ycommerce:testId code="checkoutLinkInPopup">
                <a href="${cartUrl}" class="btn btn-primary btn-block add-to-cart-button">
                    <spring:theme code="checkout.checkout" />
                </a>
            </ycommerce:testId>


            <a href="" class="btn btn-default btn-block js-mini-cart-close-button">
                <spring:theme code="cart.page.continue"/>
            </a>
		</div>
	</ycommerce:testId>
</spring:escapeBody>"
}



