<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<%@ attribute name="paypalRenderBtnContainer" required="true" type="java.lang.String" %>
<%@ attribute name="callPlace" required="true" type="java.lang.String" %>

<spring:htmlEscape defaultHtmlEscape="true" />

<c:if test="${payPalPluginConfiguration.payPalGeneralConfigurationData.fraudNetIntegration}">
    <script type="application/json" fncls="fnparams-dede7cc5-15fd-4c75-a9f4-36c430ee3a99">
         {
            "f":"${correlationId}",
            "s":"${pageId}",
            "sandbox":${payPalPluginConfiguration.payPalGeneralConfigurationData.fraudNetSandbox}
        }
    </script>
    <script type="text/javascript" src="https://c.paypal.com/da/r/fb.js"></script>
</c:if>

<script>
    var paypalButtonConfig = {
        color:   "${paypalButtonConfig.color}",
        shape:   "${paypalButtonConfig.shape}",
        label:   "${paypalButtonConfig.label}",
        borderRadius: parseInt("${paypalButtonConfig.borderRadius}"),
        height:  parseInt("${paypalButtonConfig.height}"),
    }

    var applePayButtonConfigCart = {
      buttonstyle:   "${applePayButtonConfigCart.color}",
      type:   "${applePayButtonConfigCart.type}",
    }

    var applePayButtonConfigMiniCart = {
      buttonstyle:   "${applePayButtonConfigMiniCart.color}",
      type:   "${applePayButtonConfigMiniCart.type}",
    }

    var payPalFundingOnExpressCheckout = [];
    <c:forEach items="${payPalPluginConfiguration.payPalConfigurationData.payPalFundingOnExpressCheckout}" var="fund">
        payPalFundingOnExpressCheckout.push("${fund}".toLowerCase())
    </c:forEach>

    var venmoEnable = ${payPalPluginConfiguration.venmoConfigurationData.enable}

    var isSessionPaymentPayPalExist = ${isSessionPaymentPayPalExist}
    var isChangePaymentButtonEnabled = ${payPalPluginConfiguration.payPalConfigurationData.changePaymentButtonEnabled}
    var isSessionPaymentVenmoExist = ${isSessionPaymentVenmoExist}
    var isPayPalEnableExpress = ${payPalPluginConfiguration.payPalConfigurationData.payPalEnable};
</script>

<div id="${paypalRenderBtnContainer}">
    <div id="paypal-${callPlace}-render-btn-container"></div>
    <div id="credit-${callPlace}-render-btn-container"></div>
    <div id="paylater-${callPlace}-render-btn-container"></div>
    <div id="card-${callPlace}-render-btn-container"></div>
</div>

<c:if test="${payPalPluginConfiguration.applePayConfigurationData.enable and isAvailableForExpressCheckout}">
    <div id="applepay-${callPlace}-render-btn-container"></div>
</c:if>
