package com.paypal.hybris.b2baddon.security;

import de.hybris.bootstrap.annotations.UnitTest;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

@UnitTest
public class ConnectWithPayPalAuthenticationTokenTest {

    private static final String PRINCIPAL = "principal";
    private static final String ROLE = "Role";

    @Test
    public void shouldCreateWithPrincipalAndNotAuthenticate() {
        ConnectWithPayPalAuthenticationToken token = new ConnectWithPayPalAuthenticationToken(PRINCIPAL);

        assertEquals(PRINCIPAL, token.getPrincipal());
        assertFalse(token.isAuthenticated());
    }

    @Test(expected = IllegalArgumentException.class)
    public void shouldThrowIllegalArgumentExceptionWhenPrincipalIsNull() {
        new ConnectWithPayPalAuthenticationToken(null);
    }

    @Test(expected = IllegalArgumentException.class)
    public void shouldThrowIllegalArgumentExceptionWhenPrincipalIsBlank() {
        new ConnectWithPayPalAuthenticationToken(StringUtils.EMPTY);
    }

    @Test
    public void shouldCreateWithPrincipalAndAuthorities() {
        SimpleGrantedAuthority simpleGrantedAuthority = new SimpleGrantedAuthority(ROLE);
        List<SimpleGrantedAuthority> authorities = List.of(simpleGrantedAuthority);

        ConnectWithPayPalAuthenticationToken token = new ConnectWithPayPalAuthenticationToken(PRINCIPAL, authorities);

        assertEquals(PRINCIPAL, token.getPrincipal());
        assertTrue(token.isAuthenticated());
        assertEquals(simpleGrantedAuthority, token.getAuthorities().stream().findFirst()
                .orElseThrow(AssertionError::new));
    }

    @Test
    public void shouldReturnEmptyCredentials() {
        ConnectWithPayPalAuthenticationToken token = new ConnectWithPayPalAuthenticationToken(PRINCIPAL);
        assertEquals(StringUtils.EMPTY, token.getCredentials());
    }

}
