package com.paypal.hybris.b2baddon.validators;

import com.paypal.hybris.addon.forms.CreditCardAddressForm;
import com.paypal.hybris.core.util.ExpiredDateValidatorUtil;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class PaypalExpiredDateValidator implements Validator {

    private static final String EXPIRY_YEAR = "expiryYear";
    private static final String EXPIRY_MONTH = "expiryMonth";
    private static final String CREDIT_CARD_EXPIRY_MONTH_INVALID = "credit.card.expiry.month.invalid";
    private static final String CREDIT_CARD_EXPIRY_YEAR_INVALID = "credit.card.expiry.year.invalid";

    private ExpiredDateValidatorUtil expiredDateValidatorUtil;

    @Override
    public boolean supports(Class<?> clazz) {
        return CreditCardAddressForm.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, Errors errors) {
        CreditCardAddressForm creditCard = (CreditCardAddressForm) target;
        long monthsToExpiration = expiredDateValidatorUtil.getMonthsToExpiration(creditCard.getExpiryMonth(),
                creditCard.getExpiryYear());

        if (monthsToExpiration < 0) {
            errors.rejectValue(EXPIRY_YEAR, CREDIT_CARD_EXPIRY_YEAR_INVALID);
            errors.rejectValue(EXPIRY_MONTH, CREDIT_CARD_EXPIRY_MONTH_INVALID);
        }
    }

    public void setExpiredDateValidatorUtil(ExpiredDateValidatorUtil expiredDateValidatorUtil) {
        this.expiredDateValidatorUtil = expiredDateValidatorUtil;
    }

}
