package com.paypal.hybris.b2baddon.security.handler;


import de.hybris.platform.cms2.model.site.CMSSiteModel;
import de.hybris.platform.cms2.servicelayer.services.CMSSiteService;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CONNECT_LOGIN_ACCOUNT_CONNECT;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CONNECT_LOGIN_NO_AUTHENTICATION_ACCOUNT_CONNECT;

public class PasswordVerificationSuccessHandler implements AuthenticationSuccessHandler {

    private RedirectStrategy redirectStrategy;
    private CMSSiteService cmsSiteService;

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response,
                                        Authentication authentication) throws IOException {

        final CMSSiteModel site = cmsSiteService.getCurrentSite();
        if (site.isRequiresAuthentication()) {
            redirectStrategy.sendRedirect(request, response, CONNECT_LOGIN_ACCOUNT_CONNECT);
        } else {
            redirectStrategy.sendRedirect(request, response, CONNECT_LOGIN_NO_AUTHENTICATION_ACCOUNT_CONNECT);
        }
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    public void setCmsSiteService(CMSSiteService cmsSiteService) {
        this.cmsSiteService = cmsSiteService;
    }
}