package com.paypal.hybris.b2baddon.controllers.pages;

import com.paypal.hybris.facade.facades.PayPalAcceleratorCheckoutFacade;
import de.hybris.platform.acceleratorstorefrontcommons.annotations.RequireHardLogIn;
import de.hybris.platform.acceleratorstorefrontcommons.checkout.steps.CheckoutStep;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.checkout.steps.AbstractCheckoutStepController;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.commerceservices.order.CommerceCartModificationException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ORDER_ID_PLACEHOLDER;


@Controller
@RequestMapping(value = "/paypal/checkout/multi/payment-method")
public class PayPalPaymentMethodCheckoutStepController extends AbstractCheckoutStepController {

    private static final String PAYMENT_METHOD = "payment-method";

    @Resource(name = "defaultPayPalAcceleratorCheckoutFacade")
    private PayPalAcceleratorCheckoutFacade acceleratorCheckoutFacade;

    @RequestMapping(value = "/paypal/choose", method = RequestMethod.GET)
    @RequireHardLogIn
    public String doSelectPayPalPaymentMethod(
        @RequestParam("selectedPaymentMethodId") final String selectedPaymentMethodId) {
        if (StringUtils.isNotBlank(selectedPaymentMethodId)) {
            acceleratorCheckoutFacade.setSelectedPaymentInfoToCart(selectedPaymentMethodId);
        }
        return getCheckoutStep().nextStep();
    }

    @Override
    public String enterStep(Model model, RedirectAttributes redirectAttributes) throws CMSItemNotFoundException, CommerceCartModificationException {
        return getCheckoutStep().currentStep();
    }

    @Override
    public String back(RedirectAttributes redirectAttributes) {
        return getCheckoutStep().previousStep();
    }

    @Override
    public String next(RedirectAttributes redirectAttributes) {
        return getCheckoutStep().nextStep();
    }

    protected CheckoutStep getCheckoutStep()
    {
        return getCheckoutStep(PAYMENT_METHOD);
    }
}
