package com.paypal.hybris.b2baddon.controllers.pages;

import com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants;
import de.hybris.platform.acceleratorstorefrontcommons.annotations.RequireHardLogIn;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractCheckoutController;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value = "/checkout/multi/delivery-address")
public class PayPalDeliveryAddressCheckoutStepController extends AbstractCheckoutController {

    private static final String INCORRECT_DELIVERY_ADDRESS = "checkout.multi.incorrect.deliveryAddress";

    @GetMapping(value = "/add/invalid-address")
    @RequireHardLogIn
    public String enterStepWithError(final Model model) {
        GlobalMessages.addErrorMessage(model, INCORRECT_DELIVERY_ADDRESS);

        return FORWARD_PREFIX + Paypalb2baddonWebConstants.CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS;
    }

}
