package com.paypal.hybris.b2baddon.controllers.misc;

import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.IS_ANONYMOUS_USER;

import com.paypal.hybris.b2baddon.controllers.Paypalb2baddonControllerConstants;
import com.paypal.hybris.b2baddon.model.PayPalMiniCartComponentB2BModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.AbstractController;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.user.UserFacade;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Controller
@Scope("tenant")
public class PayPalMiniCartController extends AbstractController {

    private static final String CART_DATA = "cartData";
    private static final String ENTRIES = "entries";
    private static final String NUMBER_ITEMS_IN_CART = "numberItemsInCart";
    private static final String NUMBER_SHOWING = "numberShowing";
    private static final String LIGHTBOX_BANNER_COMPONENT = "lightboxBannerComponent";
    private static final String EXPRESS_CHECKOUT_COMPONENT = "expressCheckoutComponent";
    private static final String PAYPAL_EXPRESS_CHECKOUT_ENABLED = "isExpressCheckoutEnabled";

    @Resource(name = "cartFacade")
    private CartFacade cartFacade;

    @Resource(name = "userFacade")
    private UserFacade userFacade;

    @Resource(name = "cmsComponentService")
    private CMSComponentService cmsComponentService;

    @Resource(name = "payPalConfigurationService")
    private PayPalConfigurationService defaultPayPalConfigurationService;

    /**
     * Controller that handle minicart popup with embedded PayPal buttons
     *
     * @param componentUid
     * @param model
     * @return
     * @throws CMSItemNotFoundException
     */
    @RequestMapping(value = "/cart/rollover/paypal{componentUid}", method = RequestMethod.GET)
    public String rolloverMiniCartPopup(@PathVariable final String componentUid, final Model model)
            throws CMSItemNotFoundException {
        final CartData cartData = cartFacade.getSessionCart();
        model.addAttribute(CART_DATA, cartData);

        final PayPalMiniCartComponentB2BModel component = (PayPalMiniCartComponentB2BModel) cmsComponentService
                .getSimpleCMSComponent(componentUid);

        final List entries = cartData.getEntries();
        if (entries != null) {
            Collections.reverse(entries);
            model.addAttribute(ENTRIES, entries);

            model.addAttribute(NUMBER_ITEMS_IN_CART, Integer.valueOf(entries.size()));
            if (entries.size() < component.getShownProductCount()) {
                model.addAttribute(NUMBER_SHOWING, Integer.valueOf(entries.size()));
            } else {
                model.addAttribute(NUMBER_SHOWING, Integer.valueOf(component.getShownProductCount()));
            }
        }
        if (defaultPayPalConfigurationService.isExpressCheckoutEnabled()) {
            model.addAttribute(LIGHTBOX_BANNER_COMPONENT, component.getLightboxBannerComponent());
            model.addAttribute(PAYPAL_EXPRESS_CHECKOUT_ENABLED, defaultPayPalConfigurationService.isExpressCheckoutEnabled());
            model.addAttribute(IS_ANONYMOUS_USER, userFacade.isAnonymousUser());
        }
        return Paypalb2baddonControllerConstants.Views.Fragments.Cart.CART_POPUP;
    }
}
