/*

 */
package com.paypal.hybris.b2baddon.controllers.cms;

import com.paypal.hybris.b2baddon.controllers.Paypalb2baddonControllerConstants;
import com.paypal.hybris.b2baddon.model.PayPalConnectButtonComponentB2BModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController;
import de.hybris.platform.commerceservices.request.mapping.annotation.RequestMappingOverride;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller("PayPalConnectButtonComponentB2BController")
@Scope("tenant")
@RequestMapping(value = Paypalb2baddonControllerConstants.Actions.Cms.PAYPAL_CONNECT_BUTTON_COMPONENT)
public class PayPalConnectButtonComponentB2BController extends
        AbstractCMSAddOnComponentController<PayPalConnectButtonComponentB2BModel> {

    private static final String CONNECT_WITH_PAYPAL_COMPONENT = "PayPalConnectButtonComponentB2B";
    private static final String CONTAINER_ID = "containerID";
    private static final String THEME = "theme";
    private static final String BUTTON_TYPE = "buttonType";
    private static final String BUTTON_SHAPE = "buttonShape";
    private static final String BUTTON_SIZE = "buttonSize";
    private static final String FULL_PAGE = "fullPage";
    private static final String PAYPAL_CONNECT_SCRIPT = "payPalConnectScript";
    private static final String PAYPAL_CONNECT_SCOPES = "payPalConnectScopes";
    private static final String PAYPAL_CONNECT_RESPONSE_TYPE = "payPalConnectResponseType";
    private static final String PAYPAL_CONNECT_RETURN_URL = "payPalConnectReturnUrl";
    private static final String PAYPAL_ENV_CONFIGURATION = "environmentType";
    private static final String CLIENT_ID = "clientID";
    private static final String IS_PAYPAL_CONNECT_ENABLED = "isPayPalConnectEnabled";

    @Resource(name = "payPalConfigurationService")
    private PayPalConfigurationService defaultPayPalConfigurationService;


    @Override
    protected void fillModel(HttpServletRequest request, Model model, PayPalConnectButtonComponentB2BModel component) {
        model.addAttribute(CONTAINER_ID, component.getButtonDiv());
        model.addAttribute(THEME, component.getButtonTheme().toString().toLowerCase());
        model.addAttribute(BUTTON_TYPE, component.getButtonType());
        model.addAttribute(BUTTON_SHAPE, component.getButtonShape().toString().toLowerCase());
        model.addAttribute(BUTTON_SIZE, component.getButtonSize().toString().toLowerCase());
        model.addAttribute(FULL_PAGE, component.getFullPage());
        model.addAttribute(PAYPAL_CONNECT_SCRIPT, defaultPayPalConfigurationService.getPayPalConnectScript());
        model.addAttribute(PAYPAL_CONNECT_SCOPES, defaultPayPalConfigurationService.getPayPalConnectScopes());
        model.addAttribute(PAYPAL_CONNECT_RESPONSE_TYPE, defaultPayPalConfigurationService.getPayPalConnectResponseType());
        if (component.getUid().equals(CONNECT_WITH_PAYPAL_COMPONENT)) {
            model.addAttribute(PAYPAL_CONNECT_RETURN_URL, defaultPayPalConfigurationService.getPayPalConnectReturnUrl());
        } else {
            model.addAttribute(PAYPAL_CONNECT_RETURN_URL, defaultPayPalConfigurationService.getPayPalConnectCheckoutReturnUrl());
        }
        model.addAttribute(PAYPAL_ENV_CONFIGURATION, defaultPayPalConfigurationService.getEnvironmentType());
        model.addAttribute(CLIENT_ID, defaultPayPalConfigurationService.getClientID());
        model.addAttribute(IS_PAYPAL_CONNECT_ENABLED, component.getEnabled());

    }

    @Override
    @RequestMappingOverride
    @RequestMapping
    public String handleGet(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        return super.handleGet(request, response, model);
    }

}

