/*
 * [y] hybris Platform
 *
 * Copyright (c) 2018 SAP SE or an SAP affiliate company.  All rights reserved.
 *
 * This software is the confidential and proprietary information of SAP
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with SAP.
 */
package com.paypal.hybris.b2baddon.controllers;

import com.paypal.hybris.b2baddon.model.PayPalButtonComponentB2BModel;
import com.paypal.hybris.b2baddon.model.PayPalCreditMessageComponentB2BModel;
import com.paypal.hybris.b2baddon.model.PayPalMiniCartComponentB2BModel;
import com.paypal.hybris.b2baddon.model.PayPalConnectButtonComponentB2BModel;


import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonConstants.EXTENSIONNAME;


/**
 *
 */
public interface Paypalb2baddonControllerConstants {

    String ADDON_PREFIX = "addon:/" + EXTENSIONNAME + "/";

    interface Actions {

        interface Cms {

            String PREFIX = "/view/";
            String SUFFIX = "Controller";

            String PAYPAL_MINI_CART_COMPONENT = PREFIX + PayPalMiniCartComponentB2BModel._TYPECODE + SUFFIX;

            String PAYPAL_CREDIT_MESSAGE_COMPONENT = PREFIX + PayPalCreditMessageComponentB2BModel._TYPECODE + SUFFIX;

            String PAYPAL_BUTTON_COMPONENT = PREFIX + PayPalButtonComponentB2BModel._TYPECODE + SUFFIX;

            String PAYPAL_CONNECT_BUTTON_COMPONENT = PREFIX + PayPalConnectButtonComponentB2BModel._TYPECODE + SUFFIX;

        }
    }

    interface Views {

        interface Pages {

            interface MultiStepCheckout {

                String SILENT_ORDER_POST_PAGE = ADDON_PREFIX + "pages/checkout/multi/silentOrderPostPage";
                String CHECKOUT_SUMMARY_PAGE = ADDON_PREFIX + "pages/checkout/multi/checkoutSummaryPage";
            }

            interface Checkout {
                String CHECKOUT_SUMMARY_PAGE = "pages/checkout/multi/checkoutSummaryPage";
                String CHECKOUT_CONFIRMATION_PAGE = ADDON_PREFIX + "pages/checkout/checkoutConfirmationPage";
                String CHECKOUT_LOGIN_PAGE = "pages/checkout/checkoutLoginPage";
            }

            interface Account{

                String ACCOUNT_LOGIN_PAGE = "pages/account/accountLoginPage";
            }

            interface Login {
                String ACCOUNT_CONNECT_PASSWORD_VERIFICATION_PAGE = ADDON_PREFIX + "pages/login/accountConnectPasswordVerificationPage";
            }
        }

        interface Fragments {

            interface Cart {

                String CART_POPUP = ADDON_PREFIX + "fragments/cart/cartPopup";
                String ADD_TO_CART_POPUP = ADDON_PREFIX + "fragments/cart/addToCartPopup";
            }
        }
    }
}
