package com.paypal.hybris.addon.renderer;

import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.cms2.model.contents.components.AbstractCMSComponentModel;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.servicelayer.model.ModelService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import javax.servlet.jsp.PageContext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalDefaultAddOnCMSComponentRendererTest {

    private static final String CLIENT_ID = "clientId";
    private static final String INTENT = "intent";
    private static final String COMMIT = "commit";
    private static final String PAYPAL_SDK_URL = "paypalSDKUrl";
    private static final String PARTNER_ATTRIBUTION_ID = "partnerAttributionId";
    private static final String PROPERTY = "property";

    @Mock
    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;

    @Mock
    private AbstractCMSComponentModel component;

    @Mock
    private ModelService modelService;

    @Mock
    private CMSComponentService cmsComponentService;

    @Mock
    private PageContext pageContext;

    @InjectMocks
    private PayPalDefaultAddOnCMSComponentRenderer<AbstractCMSComponentModel> unit;

    private List<String> readableEditorProperties;

    Map<String, Object> variables;

    private Object value;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        value = new Object();
        readableEditorProperties = new ArrayList<>();
        variables = new HashMap<>();

        readableEditorProperties.add(PROPERTY);
        variables.put(PROPERTY, value);
    }

    @Test
    public void shouldExposeVariablesWhenVariablesEqualsNull() {
        when(cmsComponentService.getReadableEditorProperties(component)).thenReturn(Collections.emptyList());

        assertEquals(new HashMap<>(), unit.exposeVariables(pageContext, component));

        verify(pageContext, never()).setAttribute(CLIENT_ID, CLIENT_ID, 2);
        verify(pageContext, never()).setAttribute(INTENT, INTENT, 2);
        verify(pageContext, never()).setAttribute(COMMIT, Boolean.TRUE, 2);
        verify(pageContext, never()).setAttribute(PAYPAL_SDK_URL, PAYPAL_SDK_URL, 2);
        verify(pageContext, never()).setAttribute(PARTNER_ATTRIBUTION_ID, PARTNER_ATTRIBUTION_ID, 2);
    }

    @Test
    public void shouldExposeVariablesWhenVariablesNotEqualsNull() {
        when(cmsComponentService.getReadableEditorProperties(component)).thenReturn(readableEditorProperties);
        when(modelService.getAttributeValue(component, PROPERTY)).thenReturn(value);
        when(defaultPayPalConfigurationService.getClientID()).thenReturn(CLIENT_ID);
        when(defaultPayPalConfigurationService.getPayPalIntent()).thenReturn(INTENT);
        when(defaultPayPalConfigurationService.isCommitEnabled()).thenReturn(Boolean.TRUE);
        when(defaultPayPalConfigurationService.getPayPalSdkJsUrl()).thenReturn(PAYPAL_SDK_URL);
        when(defaultPayPalConfigurationService.getPayPalPartnerAttributionId()).thenReturn(PARTNER_ATTRIBUTION_ID);

        assertEquals(variables, unit.exposeVariables(pageContext, component));

        verify(pageContext).setAttribute(CLIENT_ID, CLIENT_ID, 2);
        verify(pageContext).setAttribute(INTENT, INTENT, 2);
        verify(pageContext).setAttribute(COMMIT, Boolean.TRUE, 2);
        verify(pageContext).setAttribute(PAYPAL_SDK_URL, PAYPAL_SDK_URL, 2);
        verify(pageContext).setAttribute(PARTNER_ATTRIBUTION_ID, PARTNER_ATTRIBUTION_ID, 2);
    }
}