package com.paypal.hybris.addon.renderer;

import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;

import de.hybris.platform.addonsupport.renderer.impl.DefaultAddOnCMSComponentRenderer;
import de.hybris.platform.cms2.model.contents.components.AbstractCMSComponentModel;

import javax.annotation.Resource;
import javax.servlet.jsp.PageContext;
import java.util.Map;


public class PayPalDefaultAddOnCMSComponentRenderer<C extends AbstractCMSComponentModel>
    extends DefaultAddOnCMSComponentRenderer<C> {

    private static final String CLIENT_ID = "clientId";
    private static final String INTENT = "intent";
    private static final String COMMIT = "commit";
    private static final String PAYPAL_SDK_URL = "paypalSDKUrl";
    private static final String PARTNER_ATTRIBUTION_ID = "partnerAttributionId";

    @Resource(name = "payPalConfigurationService")
    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;
    @Override
    protected Map<String, Object> exposeVariables(final PageContext pageContext,
        @SuppressWarnings("unused") final C component)
    {
        final Map<String, Object> variables = getVariablesToExpose(pageContext, component);
        if (variables != null) {

            variables.forEach((key, value) -> pageContext
                .setAttribute(key, value, getScopeForVariableName(key)));

            pageContext.setAttribute(CLIENT_ID, defaultPayPalConfigurationService.getClientID(),
                getScopeForVariableName(CLIENT_ID));
            pageContext.setAttribute(INTENT, defaultPayPalConfigurationService.getPayPalIntent(),
                getScopeForVariableName(INTENT));
            pageContext.setAttribute(COMMIT, defaultPayPalConfigurationService.isCommitEnabled(),
                getScopeForVariableName(COMMIT));
            pageContext.setAttribute(PAYPAL_SDK_URL, defaultPayPalConfigurationService.getPayPalSdkJsUrl(),
                getScopeForVariableName(PAYPAL_SDK_URL));
            pageContext.setAttribute(PARTNER_ATTRIBUTION_ID, defaultPayPalConfigurationService.getPayPalPartnerAttributionId(),
                    getScopeForVariableName(PARTNER_ATTRIBUTION_ID));
        }
        return variables;
    }
}
