ACC.venmochekout = {

    _autoload: [
        ["showVenmoSelector", $('#mark-venmo-button-container').length !== 0],
        ["renderVenmoBtn", $('#mark-venmo-button-container').length !== 0]
    ],

    renderVenmoBtn: async function () {
        await ACC.paypalSDKloader.paypalSDKPromise;
        try {
            ACC.paypalstandalonebutton.renderMarkButton('venmo','#mark-venmo-button-container', PAYPAL_CONSTANTS.FLOWS.MARK_CHECKOUT);
        } catch (err) {
            ACC.venmochekout.handleError("paypal.button.render.error" + err.message);
        }
    },

    handleError: function (message) {
        $("#errorMessage span").text(message);
    },

    showVenmoSelector: function () {
        var venmoButtonContainer = $(PAYPAL_CONSTANTS.VENMO_PAYMENT_SECTION).get(0);
        new MutationObserver(() => {
            if (venmoButtonContainer.hasChildNodes()) {
                $(PAYPAL_CONSTANTS.VENMO_RADIO).closest("label").removeAttr("hidden");
            }
        }).observe(venmoButtonContainer, {childList: true});
    }
}
