ACC.paypalutil ={
    handlePayPalClientError: function (error) {
        $(PAYPAL_CONSTANTS.GLOBAL_MESSAGES).empty();
        $(PAYPAL_CONSTANTS.GLOBAL_MESSAGES).append(ACC.paypalutil.createErrorDiv(ACC.addons.paypaladdon[error]));
    },

    showPayPalClientError: function (error) {
        $(PAYPAL_CONSTANTS.GLOBAL_MESSAGES).empty();
        $(PAYPAL_CONSTANTS.GLOBAL_MESSAGES).append(ACC.paypalutil.createGlobalErrorDiv(ACC.addons.paypaladdon[error]));
    },

    showValidationGlobalAlert: function (error) {
        if ($(PAYPAL_CONSTANTS.GLOBAL_ALERTS).length !== 0) {
            $(PAYPAL_CONSTANTS.GLOBAL_ALERTS).empty();
        } else {
            $(PAYPAL_CONSTANTS.GLOBAL_ALERTS_DIV).insertBefore($(PAYPAL_CONSTANTS.ACCOUNT_SECTION));
        }
        $(PAYPAL_CONSTANTS.GLOBAL_ALERTS).append(ACC.paypalutil.createGlobalErrorDiv(ACC.addons.paypaladdon[error]));
    },

    handlePayPalClientInfoMessage: function (message) {
        $(PAYPAL_CONSTANTS.GLOBAL_MESSAGES).empty();
        $(PAYPAL_CONSTANTS.GLOBAL_MESSAGES).append(ACC.paypalutil.createInfoDiv(ACC.addons.paypaladdon[message]));
    },

    createErrorDiv: function (message) {
        const errorComponent = $(PAYPAL_CONSTANTS.HTML.DIV).attr(PAYPAL_CONSTANTS.HTML.CLASS, PAYPAL_CONSTANTS.ERROR_ALERT_NEGATIVE_CSS_CLASS);
        errorComponent.prepend(message);
        return errorComponent;
    },

    createInfoDiv: function (message) {
        const infoComponent = $(PAYPAL_CONSTANTS.HTML.DIV).attr(PAYPAL_CONSTANTS.HTML.CLASS, PAYPAL_CONSTANTS.INFO_ALERT_CSS_CLASS);
        infoComponent.prepend(message);
        return infoComponent;
    },

    createGlobalErrorDiv: function (message) {
        const buttonComponent = "<button id='hide-err-btn' class='close closeAccAlert' aria-hidden='true' data-dismiss='alert' type='button'>&times;</button>";
        const errorComponent = $(PAYPAL_CONSTANTS.HTML.DIV).attr(PAYPAL_CONSTANTS.HTML.CLASS, PAYPAL_CONSTANTS.ERROR_ALERT_NEGATIVE_CSS_CLASS);
        errorComponent.attr(PAYPAL_CONSTANTS.HTML.ID, PAYPAL_CONSTANTS.CARD_VALIDATION_ERROR);
        errorComponent.prepend(message).append(buttonComponent);
        return errorComponent;
    }
}