ACC.paypalstandalonebutton = {

    renderMarkButton: function (funding, container, flow, buttonStyle = undefined) {

        if (paypal.isFundingEligible(funding)) {
            buttonStyle = this.getButtonStyle(funding, buttonStyle);
            paypal.Buttons(
                {
                    style: buttonStyle,

                    fundingSource: funding,

                    onClick: function (button) {
                        funding = button.fundingSource;
                        const orderReviewUrl = PAYPAL_CONSTANTS.CONTEXT_PATH + '/checkout/multi/summary/view';
                        if (funding === 'paypal' && ACC.paypalstandalonebutton.isSessionPaymentForPayPalOnExpressCheckoutExist()) {
                            window.location.replace(orderReviewUrl);
                        } else if (funding === 'venmo' && ACC.paypalstandalonebutton.isSessionPaymentForVenmoOnExpressCheckoutExist()) {
                            window.location.replace(orderReviewUrl);
                        }
                    },

                    createOrder: function (data) {
                        const createOrderUrl = PAYPAL_CONSTANTS.CREATE_ORDER_URL;
                        const requestData = JSON.stringify(
                            {
                                "flow": flow,
                                "funding": data.paymentSource === null ? "paypal" : data.paymentSource,
                                "savePaymentMethod": $("#savePayPalPaymentInfo #savePaymentInfoCheckbox").is(":checked")
                            });
                        const createOrderRequest = {
                            url: createOrderUrl, data: requestData,
                            contentType: "application/json; charset=utf-8"
                        }
                        return $.post(createOrderRequest).then(function (res) {
                            return res;
                        });
                    },
                    onApprove: function (data) {
                        const requestData = JSON.stringify(
                            {
                                "flow": flow,
                                "funding": data.paymentSource === null ? "paypal" : data.paymentSource
                            });
                        const responseRequest = {
                            url: PAYPAL_CONSTANTS.MARK_PROCESS_URL, data: requestData,
                            contentType: "application/json; charset=utf-8"
                        }
                        if ($("#savePayPalPaymentInfo #savePaymentInfoCheckbox").is(":checked")) {
                            localStorage.setItem("savedInfoMessage", "successfully.paypal.verification");
                        }

                        return $.post(responseRequest)
                            .then(function (res) {
                                const url = PAYPAL_CONSTANTS.CONTEXT_PATH + res;
                                window.location.replace(url);
                            })
                            .catch(function (err) {
                                console.log(err);
                            });
                    },
                    onError: function (err) {
                        console.log(err);
                    }
                }).render(container);
        } else {
            console.log("Payment" + funding + " is not eligible");
        }
    },

    isSessionPaymentForPayPalOnExpressCheckoutExist() {
       return typeof isSessionPaymentPayPalExist !== 'undefined' && isSessionPaymentPayPalExist;
    },

    isSessionPaymentForVenmoOnExpressCheckoutExist() {
       return typeof isSessionPaymentVenmoExist !== 'undefined' && isSessionPaymentVenmoExist;
    },

    getButtonStyle: function (funding, buttonStyle) {
        let btnStyle = { ...buttonStyle }
        if (btnStyle?.borderRadius == 0) {
            btnStyle.borderRadius = undefined;
        }
        if (btnStyle != undefined && funding !== 'paypal' && funding !== 'paylater') {
            btnStyle.color = undefined;
        }
        return btnStyle;
    }
}
