ACC.hostedFieldsSavePayment = {

    _autoload: [
        ["loadPayPalSdkAndInitPage", $("#hosted-fields-my-account").length !== 0]
    ],

    loadPayPalSdkAndInitPage: async function () {
        await ACC.paypalSDKloader.paypalSDKPromise
           .then(() => {
                ACC.hostedFieldsSavePayment.assignEventListenerForHostedFieldElements();
           });
    },

    assignEventListenerForHostedFieldElements: function () {
        if (typeof showHostedFields !== 'undefined' && showHostedFields === "true") {

            ACC.hostedFieldsSavePayment.resolveCardVisibility(showHostedFields)
            ACC.hostedFieldsSavePayment.handleValidationError(isValidationError);

            const currentSelectedOption = document.getElementById("billingAddressSelector")?.selectedOptions[0];
            if (currentSelectedOption?.value === "newAddress") {
                document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.COUNTRY_SELECTOR_FORM).style.display = 'block';
            }

            if (currentSelectedOption?.value !== "newAddress" && currentSelectedOption?.value !== "noAddress") {
                ACC.hostedFieldsSavePayment.addSelectedAddressFieldToTheForm(currentSelectedOption?.value);
            }

            document.querySelectorAll('input[name=payment-option]').forEach(function(el) {
                el.addEventListener('change', function(event) {
                        ACC.hostedFieldsSavePayment.resolvePaymentMethodVisibility(event.target.value);
                    });
                });

            document.getElementById('address.cardNumber').addEventListener('input', function() {
                ACC.hostedFieldsSavePayment.processNumberInput(this);
            });
            document.getElementById('address.cvv').addEventListener('input', function() {
                ACC.hostedFieldsSavePayment.processNumberInput(this);
            });

            document.getElementById('save-credit-card-btn').addEventListener('click', function() {
                $(PAYPAL_CONSTANTS.GLOBAL_ALERTS)?.empty();
                if (ACC.hostedFieldsSavePayment.fieldValidation()) {
                    this.disabled = true;
                    ACC.loadingSpinner.showSpinner("hosted-fields-my-account");
                    document.getElementById('save_credit_card').submit();
                }
            });

    	    document.getElementById('billingAddressSelector').addEventListener('change', function(event) {
                if (event.target.value === 'newAddress') {
                    document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.COUNTRY_SELECTOR_FORM).style.display = 'block';
                    document.getElementById(PAYPAL_CONSTANTS.HOSTED_FIELDS.SELECTED_ADDRESS).innerHTML = "";
                } else {
                    document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.COUNTRY_SELECTOR_FORM).style.display = 'none';

                    const selectedAddressInput = document.createElement("input");
                    selectedAddressInput.setAttribute("type", "hidden");
                    selectedAddressInput.setAttribute("name", "selectedAddressCode");
                    selectedAddressInput.setAttribute("value", event.target.value);

                    document.getElementById(PAYPAL_CONSTANTS.HOSTED_FIELDS.SELECTED_ADDRESS).innerHTML = "";
                    document.getElementById(PAYPAL_CONSTANTS.HOSTED_FIELDS.SELECTED_ADDRESS).appendChild(selectedAddressInput);
                }
            });

        }
    },

    resolvePaymentMethodVisibility: function (paymentMethodType) {
        if (paymentMethodType === 'paypal') {
            document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.CARD_BUTTON_CONTAINER).style.display = 'none';
            document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.PAYMENT_METHOD_BUTTON_CONTAINER).style.display = 'block';
        }
        if (paymentMethodType === 'card') {
            document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.CARD_BUTTON_CONTAINER).style.display = 'block';
            document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.PAYMENT_METHOD_BUTTON_CONTAINER).style.display = 'none';
        }
    },

    handleValidationError: function (isValidationError) {
        if (typeof isValidationError !== 'undefined' && isValidationError === "true") {
            document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.CARD_BUTTON_CONTAINER).style.display = 'block';
            if (document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.PAYMENT_METHOD_BUTTON_CONTAINER) !== null) {
                document.querySelector(PAYPAL_CONSTANTS.HOSTED_FIELDS.PAYMENT_METHOD_BUTTON_CONTAINER).style.display = 'none';
            }
            if (document.getElementById('paypalCheckbox') !== null) {
                document.getElementById('paypalCheckbox').checked = false;
            }
            document.getElementById('cardCheckbox').checked = true;
        }
    },

    processNumberInput: function (input) {
      let value = input.value;
      let numbers = value.replace(/[^0-9]/g, "");
      input.value = numbers;
    },

    addSelectedAddressFieldToTheForm: function (addressId) {
        let selectedAddressInput = document.createElement("input");
        selectedAddressInput.setAttribute("type", "hidden");
        selectedAddressInput.setAttribute("name", "selectedAddressCode");
        selectedAddressInput.setAttribute("value", addressId);

        document.getElementById('selected-address').innerHTML = "";
        document.getElementById('selected-address').appendChild(selectedAddressInput);
    },

    fieldValidation: function () {
         const nameOnCard = document.getElementById('address.nameOnCard');
         const cardNumber = document.getElementById('address.cardNumber');
         const expiryMonth = document.getElementById('address.expiryMonth');
         const expiryYear = document.getElementById('address.expiryYear');
         const cvv = document.getElementById('address.cvv');
         const addressSelector = document.getElementById('billingAddressSelector');

         let validData = true;

         nameOnCard.parentNode.classList.remove(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
         if (nameOnCard.nextSibling?.classList.contains(PAYPAL_CONSTANTS.HOSTED_FIELDS.HELP_BLOCK)) {
             nameOnCard.nextSibling.innerHTML = "";
         }
         cardNumber.parentNode.classList.remove(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
         if (cardNumber.nextSibling?.classList.contains(PAYPAL_CONSTANTS.HOSTED_FIELDS.HELP_BLOCK)) {
             cardNumber.nextSibling.innerHTML = "";
         }
         expiryMonth.parentNode.classList.remove(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
         if (expiryMonth.nextSibling?.classList.contains(PAYPAL_CONSTANTS.HOSTED_FIELDS.HELP_BLOCK)) {
             expiryMonth.nextSibling.innerHTML = "";
         }
         expiryYear.parentNode.classList.remove(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
         if (expiryYear.nextSibling?.classList.contains(PAYPAL_CONSTANTS.HOSTED_FIELDS.HELP_BLOCK)) {
             expiryYear.nextSibling.innerHTML = "";
         }
         cvv.parentNode.classList.remove(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
         if (cvv.nextSibling?.classList.contains(PAYPAL_CONSTANTS.HOSTED_FIELDS.HELP_BLOCK)) {
            cvv.nextSibling.innerHTML = "";
         }
         addressSelector.parentNode.classList.remove(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);

         if (!(/^[A-Za-z-.' ]{1,24}$/.test(nameOnCard.value))) {
             nameOnCard.parentNode.classList.add(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
             validData = false;
         }

         if (!(/^[0-9| ]{13,19}$/.test(cardNumber.value))) {
             cardNumber.parentNode.classList.add(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
             validData = false;
         }

         if (!(/^(0[1-9]|1[012])$/.test(expiryMonth.value))) {
             expiryMonth.parentNode.classList.add(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
             validData = false;
         }

         if (!(/^(19[7-9]\d|2\d{3})$/.test(expiryYear.value))) {
             expiryYear.parentNode.classList.add(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
             validData = false;
         }

         if (!(/^[0-9]{3,4}$/.test(cvv.value))) {
            cvv.parentNode.classList.add(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
            validData = false;
         }

         if (addressSelector.value === 'noAddress') {
             addressSelector.parentNode.classList.add(PAYPAL_CONSTANTS.HOSTED_FIELDS.HAS_ERROR);
             validData = false;
         }

        ACC.hostedFieldsSavePayment.handlePaymentValidation(validData);

        const targetDiv = document.getElementById("card-validation-error");
        const btn = document.getElementById("hide-err-btn");

        ACC.hostedFieldsSavePayment.hideTargetDivOnClick(btn, targetDiv);

        return validData;
    },

    hideTargetDivOnClick: function (btn, targetDiv) {
        if (typeof(targetDiv) != 'undefined' && targetDiv != null) {
            btn.onclick = function () {
                if (targetDiv.style.display !== "none") {
                    targetDiv.style.display = "none";
                }
            };
        }
    },

    handlePaymentValidation: function (validData) {
        if (!validData) {
            ACC.paypalutil.showValidationGlobalAlert('invalid.payment.details.error');
        } else {
            const validationDiv = document.getElementById("card-validation-error");
            if (typeof(validationDiv) != 'undefined' && validationDiv != null) {
                validationDiv.style.display = "none";
            }
        }
    },

    resolveCardVisibility: async function (showHostedFields) {
        const paypalCheckbox = document.querySelector("#paypalCheckbox");
        const isPayPalVaultEnabled = ACC.addons.paypaladdon.isVaultEnabled === 'true' && !paypalCheckbox?.disabled;
        const isEligible = paypal.HostedFields?.isEligible();
        if (!isPayPalVaultEnabled) {
            document.querySelector('#cardCheckbox').setAttribute('checked', 'true');
            document.querySelector('#country-selector-form').style.display = 'none';
        } else if (showHostedFields && isEligible) {
            document.querySelector('#card-button-container').style.display = 'none';
            document.querySelector('#country-selector-form').style.display = 'none';
        } else if (!isEligible) {
            document.querySelector('#hosted-fields-my-account').setAttribute('hidden', 'true');
        }
    }
}
