<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="template" tagdir="/WEB-INF/tags/responsive/template" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="multiCheckout" tagdir="/WEB-INF/tags/responsive/checkout/multi" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="order" tagdir="/WEB-INF/tags/responsive/order" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="formElement" tagdir="/WEB-INF/tags/responsive/formElement" %>
<%@ taglib prefix="hostedFilds" tagdir="/WEB-INF/tags/responsive/formElement" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="address" tagdir="/WEB-INF/tags/responsive/address" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags" %>
<%@ taglib prefix="fragments" tagdir="/WEB-INF/tags/addons/paypaladdon/responsive/paymentDetails"%>
<%@ taglib prefix="order-payment-method" tagdir="/WEB-INF/tags/addons/paypaladdon/responsive/order" %>

<c:url value="/checkout/multi/summary/view" var="checkoutSummaryViewPageUrl"/>

<spring:htmlEscape defaultHtmlEscape="true"/>

<template:page pageTitle="${pageTitle}" hideHeaderLinks="true">
    <div class="col-sm-12" id="globalMessages"></div>
    <div class="row">
        <div class="col-sm-6">
            <div class="checkout-headline">
                <span class="glyphicon glyphicon-lock"></span>
                <spring:theme code="checkout.multi.secure.checkout"/>
            </div>
            <multiCheckout:checkoutSteps checkoutSteps="${checkoutSteps}" progressBarId="${progressBarId}">
                <jsp:body>
                    <c:if test="${not empty paymentFormUrl}">
                        <div class="checkout-paymentmethod">
                            <div class="checkout-indent">

                                <div class="headline"><spring:theme code="checkout.multi.paymentMethod"/></div>

                                <div class="span-14 append-1">
                                    <div id="checkoutContentPanelPayment" class="clearfix">
                                        <cms:pageSlot position="PayPalSectionSlot" var="feature">
                                            <cms:component component="${feature}"/>
                                        </cms:pageSlot>
                                    </div>

                                    <c:if test="${not empty sessionPaymentMethod}">
                                        <div class="form-group border-top">
                                            <div class="session-payment-text-container">
                                                <div class="session-payment-text-label">
                                                    <spring:theme code="checkout.summary.session.payment.text"/>
                                                </div>
                                            </div>
                                            <div class="session-payment-method-container">
                                                <div class="paypal-width-40">
                                                    <order-payment-method:paymentDetailsItem
                                                            paymentInfo="${sessionPaymentMethod}"/>
                                                </div>
                                                <div class="paypal-width-40">
                                                    <div class="label-order">
                                                        <spring:theme
                                                                code="text.account.paymentDetails.billingAddress"/>
                                                    </div>
                                                    <div class="value-order">
                                                        <order:addressItem
                                                                address="${sessionPaymentMethod.billingAddress}"/>
                                                    </div>
                                                </div>
                                            </div>
                                            <a href="${checkoutSummaryViewPageUrl}" class="btn btn-primary btn-block">
                                                <spring:theme code="checkout.multi.paymentMethod.usePreviouslyEnteredPaymentMethod"/>
                                            </a>
                                        </div>
                                    </c:if>

                                    <c:if test="${not empty paymentInfos}">
                                        <div class="form-group border-top-padding-top">
                                            <button type="button"
                                                    class="btn btn-default btn-block js-saved-payments">
                                                <spring:theme
                                                        code="checkout.multi.paymentMethod.addPaymentDetails.useSavedPaymentMethod"/></button>
                                        </div>
                                    </c:if>
                                </div>
                            </div>
                        </div>

                        <div id="errorMessage"><span></span></div>

                    </c:if>

                    <c:if test="${not empty paymentInfos}">
                        <div id="savedpayments">
                            <div id="savedpaymentstitle">
                                <div class="headline">
                                    <span class="headline-text"><spring:theme
                                            code="checkout.multi.paymentMethod.addPaymentDetails.useSavedPaymentMethod"/></span>
                                </div>
                            </div>
                            <div id="savedpaymentsbody">
                                <spring:url var="choosePaymentMethodUrl"
                                            value="{contextPath}/paypal/checkout/multi/payment-method/choose"
                                            htmlEscape="false">
                                    <spring:param name="contextPath" value="${request.contextPath}"/>
                                </spring:url>
                                <c:forEach items="${paymentInfos}" var="paymentInfo" varStatus="status">
                                    <div class="saved-payment-entry">
                                        <form action="${fn:escapeXml(choosePaymentMethodUrl)}" method="GET">
                                            <input type="hidden" name="selectedPaymentMethodId"
                                                   value="${fn:escapeXml(paymentInfo.id)}"/>
                                            <ul>
                                                <c:choose>
                                                    <c:when test="${paymentInfo.cardType eq 'paypal'}">
                                                        <br>
                                                        <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
                                                        ${fn:escapeXml(paymentInfo.payerEmail)}
                                                    </c:when>
                                                    <c:when test="${paymentInfo.cardType eq 'card'}">
                                                        <br>
                                                        <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
                                                        PayPal Debit/Credit Card <br/>
                                                        ${fn:escapeXml(paymentInfo.payerEmail)}
                                                    </c:when>
                                                    <c:otherwise>
                                                        <div class="expired-status-content-box">
                                                            <fragments:expirationStatus expirationStatus="${paymentInfo.expirationStatus}"
                                                                                        expireRemained="${paymentInfo.remainderMonthToExpire}"/>
                                                        </div>
                                                        <span>
                                                            <c:if test="${paymentInfo.defaultPaymentInfo}">
                                                            <strong>
                                                                </c:if>
                                                                    ${fn:escapeXml(paymentInfo.accountHolderName)}<c:if test="${paymentInfo.defaultPaymentInfo}" >&nbsp;(<spring:theme code="text.default" />)</c:if>
                                                                <c:if test="${paymentInfo.defaultPaymentInfo}" ></strong></c:if>
                                                        </span> <br/>
                                                        <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
                                                        <span>${fn:escapeXml(paymentInfo.cardTypeData.name)}</span> <br/>
                                                        <span>
                                                            <ycommerce:testId code="paymentDetails_item_cardNumber_text" >${fn:escapeXml(paymentInfo.cardNumber)}</ycommerce:testId>
                                                        </span> <br/>
                                                        <span>
                                                            ${fn:escapeXml(paymentInfo.expiryMonth)}&nbsp;/&nbsp;${fn:escapeXml(paymentInfo.expiryYear)}
                                                        </span>
                                                    </c:otherwise>
                                                </c:choose>
                                                <c:if test="${paymentInfo.billingAddress ne null}">
                                                    <br/>${fn:escapeXml(paymentInfo.billingAddress.line1)}
                                                    <br/>${fn:escapeXml(paymentInfo.billingAddress.town)}&nbsp;${fn:escapeXml(paymentInfo.billingAddress.region.isocodeShort)}
                                                    <br/>${fn:escapeXml(paymentInfo.billingAddress.country.name)}&nbsp;${fn:escapeXml(paymentInfo.billingAddress.postalCode)}
                                                </c:if>
                                            </ul>
                                            <c:choose>
                                                <c:when test="${paymentInfo.defaultPaymentInfo}">
                                                    <button type="submit" class="btn btn-primary btn-block default-payment-method"
                                                            tabindex="${fn:escapeXml((status.count * 2) - 1)}"><spring:theme
                                                            code="checkout.multi.paymentMethod.addPaymentDetails.useDefaultPaymentDetails"/></button>
                                                </c:when>
                                                <c:otherwise>
                                                    <button type="submit" class="btn btn-primary btn-block"
                                                            tabindex="${fn:escapeXml((status.count * 2) - 1)}"><spring:theme
                                                            code="checkout.multi.paymentMethod.addPaymentDetails.useThesePaymentDetails"/></button>
                                                </c:otherwise>
                                            </c:choose>
                                        </form>
                                    </div>
                                </c:forEach>
                            </div>
                        </div>
                    </c:if>

                </jsp:body>
            </multiCheckout:checkoutSteps>
        </div>

        <div class="col-sm-6 hidden-xs">
            <multiCheckout:checkoutOrderDetails cartData="${cartData}" showDeliveryAddress="true"
                                                showPaymentInfo="false" showTaxEstimate="false" showTax="true"/>
        </div>

        <div class="col-sm-12 col-lg-12">
            <cms:pageSlot position="SideContent" var="feature" element="div" class="checkout-help">
                <cms:component component="${feature}"/>
            </cms:pageSlot>
        </div>
    </div>

</template:page>
