<%@ tag body-content="empty" trimDirectiveWhitespaces="true" %>
<%@ attribute name="paymentInfo" required="true" type="de.hybris.platform.commercefacades.order.data.CCPaymentInfoData" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fragments" tagdir="/WEB-INF/tags/addons/paypaladdon/responsive/paymentDetails"%>

<spring:htmlEscape defaultHtmlEscape="true"/>
<div class="label-order">
    <spring:theme code="text.account.paymentType"/>
</div>
<div class="value-order">
    <c:choose>
        <c:when test="${paymentInfo.cardType eq 'paypal'}">
            <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
            <spring:theme code="paymentMethod.type"/>
            <br/>
            ${fn:escapeXml(paymentInfo.payerEmail)}
        </c:when>
         <c:when test="${paymentInfo.cardType eq 'applepay'}">
            <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
            <spring:theme code="paymentMethod.applepay"/>
            <br/>
            ${fn:escapeXml(paymentInfo.payerEmail)}
        </c:when>
        <c:when test="${paymentInfo.cardType eq 'local_payment'}">
            <spring:theme code="paymentMethod.lpm"/>
            <br/>
        </c:when>
        <c:when test="${paymentInfo.cardType eq 'venmo'}">
            <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
            <spring:theme code="paymentMethod.venmo"/>
            <br/>
            ${fn:escapeXml(paymentInfo.payerEmail)}
        </c:when>
        <c:when test="${paymentInfo.cardType eq 'card'}">
            <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
            <c class="pp-account-email-card"><spring:theme code="paymentMethod.credit-debit"/>,
                    ${fn:escapeXml(paymentInfo.accountHolderName)},
                    ${fn:escapeXml(paymentInfo.payerEmail)} </c>
        </c:when>
        <c:otherwise>
            <c:if test="${ (not empty paymentInfo.accountHolderName) and (paymentInfo.accountHolderName ne ' ') }">
                ${fn:escapeXml(paymentInfo.accountHolderName)}
                <br/>
            </c:if>
            <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
            ${fn:escapeXml(paymentInfo.cardTypeData.name)}
            <br/>
            ${fn:escapeXml(paymentInfo.cardNumber)}
            <br/>
            <c:if test="${(paymentInfo.expiryMonth ne '0') and (paymentInfo.expiryYear ne '0')}">
                Expires: ${paymentInfo.expiryMonth}/${paymentInfo.expiryYear}
            </c:if>
        </c:otherwise>
    </c:choose>
</div>