<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>

<spring:url value="/" var="homeUrl"/>

<style type="text/css">
    .modal-container {
      display: none;
      position: fixed;
      z-index: 1;
      left: 0;
      top: 0;
      width: 100%;
      height: 100%;
      overflow: auto;
      background-color: rgb(0,0,0);
      background-color: rgba(0,0,0,0.4);
    }

    .modal-content {
      background-color: #ffffff;
      margin: 15% auto;
      padding: 20px;
      border: 1px solid #888;
      width: 30%;
    }
</style>

<div id="cancel-pass-modal" class="modal-container">
  <div class="modal-content">
    <p><spring:theme code="paypal.connect.password.verification.cancel.message"/></p>
    <button data-theme="b" type="button" class="btn btn-primary btn-block" onClick='redirectToLoginPage()'> OK </button>
  </div>
</div>

<script>

    var loginUrl = "${homeUrl}" + "/login";
    var modal = document.getElementById("cancel-pass-modal");

    function showCancelModalWindow() {
      modal.style.display = "block";
    }

    function onASLSubmitClick() {
      ACC.loadingSpinner.showSpinner('additional-security-container');
    }

    function redirectToLoginPage() {
     window.location=loginUrl;
    }

    // When the user clicks anywhere outside of the modal, close it
    window.onclick = function(event) {
      if (event.target == modal) {
        redirectToLoginPage();
      }
    }

</script>