package com.paypal.hybris.addon.security.impl;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.acceleratorstorefrontcommons.security.GUIDCookieStrategy;
import de.hybris.platform.commercefacades.customer.CustomerFacade;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.RememberMeServices;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import static org.mockito.Mockito.any;
import static org.mockito.Mockito.eq;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalAutoLoginStrategyTest {

    private static final String REMOTE_ADDRESS = "remoteAddress";
    private static final String SESSION_ID = "sessionId";
    private static final String USER_NAME = "userName";

    @Mock
    private AuthenticationManager authenticationManager;

    @Mock
    private CustomerFacade customerFacade;

    @Mock
    private GUIDCookieStrategy guidCookieStrategy;

    @Mock
    private RememberMeServices rememberMeServices;

    @Mock
    private HttpServletRequest request;

    @Mock
    private HttpServletResponse response;

    @Mock
    private HttpSession httpSession;

    @Mock
    private Authentication authentication;

    @InjectMocks
    private DefaultPayPalAutoLoginStrategy unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        when(request.getRemoteAddr()).thenReturn(REMOTE_ADDRESS);
        when(request.getSession(false)).thenReturn(httpSession);
        when(httpSession.getId()).thenReturn(SESSION_ID);
    }

    @Test
    public void shouldSuccessfullyLogin() {
        when(authenticationManager.authenticate(any())).thenReturn(authentication);

        unit.login(USER_NAME, request, response);

        verify(customerFacade).loginSuccess();
        verify(guidCookieStrategy).setCookie(request, response);
        verify(rememberMeServices).loginSuccess(eq(request), eq(response), any());
    }

    @Test
    public void shouldFailureDuringLogin() {
        when(authenticationManager.authenticate(any())).thenThrow(RuntimeException.class);

        unit.login(USER_NAME, request, response);

        verify(customerFacade, never()).loginSuccess();
        verify(guidCookieStrategy, never()).setCookie(request, response);
        verify(rememberMeServices, never()).loginSuccess(eq(request), eq(response), any());
    }
}