package com.paypal.hybris.addon.validators;

import de.hybris.platform.acceleratorstorefrontcommons.forms.UpdatePasswordForm;
import org.apache.commons.lang.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;


public class PayPalPasswordValidator implements Validator {

	private static final String NEW_PASSWORD = "newPassword";
	private static final String UPDATE_PWD_INVALID = "updatePwd.pwd.invalid";
	private static final String CHECK_NEW_PASSWORD = "checkNewPassword";

	@Override
	public boolean supports(Class<?> clazz) {
		return UpdatePasswordForm.class.equals(clazz);
	}

	@Override
	public void validate(Object target, Errors errors) {
		UpdatePasswordForm passwordForm = (UpdatePasswordForm) target;
		String newPasswd = passwordForm.getNewPassword();
		String checkPasswd = passwordForm.getCheckNewPassword();

		if (StringUtils.isEmpty(newPasswd)) {
			errors.rejectValue(NEW_PASSWORD, UPDATE_PWD_INVALID);
		} else if (StringUtils.length(newPasswd) < 6 || StringUtils.length(newPasswd) > 255) {
			errors.rejectValue(NEW_PASSWORD, UPDATE_PWD_INVALID);
		}

		if (StringUtils.isEmpty(checkPasswd)) {
			errors.rejectValue(CHECK_NEW_PASSWORD, UPDATE_PWD_INVALID);
		} else if (StringUtils.length(checkPasswd) < 6 || StringUtils.length(checkPasswd) > 255) {
			errors.rejectValue(CHECK_NEW_PASSWORD, UPDATE_PWD_INVALID);
		}

	}
}
