package com.paypal.hybris.addon.security;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class ConnectWithPayPalAuthenticationToken extends AbstractAuthenticationToken {

    private static final long serialVersionUID = 520L;
    private final Object principal;

    public ConnectWithPayPalAuthenticationToken(Object principal) {
        super(null);
        if (principal != null && !StringUtils.EMPTY.equals(principal)) {
            this.principal = principal;
            this.setAuthenticated(false);
        } else {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
    }

    public ConnectWithPayPalAuthenticationToken(Object principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        super.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return StringUtils.EMPTY;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }
}
