package com.paypal.hybris.addon.controllers.pages;

import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.CHECKOUT_MULTI_CONFIRMATION_PAGE;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.EXPRESS_CHECKOUT;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.MARK_CHECKOUT;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAYPAL_CHECKOUT_MULTI_SUMMARY_PLACE_ORDER;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAYPAL_FLOW_OPTION;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAYPAL_CHECKOUT_MULTI_ADD_PAYMENT_PAGE;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAYPAL_FUNDING;
import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.PAY_PAL_REQUEST_ORDER_ID;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.APPLE_PAY_INVALID_SHIPPING_CONTACT_ERROR_CODE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_HOSTED_FIELDS;

import com.paypal.hybris.core.exception.ApplePayInvalidAddressException;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.data.ApplePayErrorData;
import com.paypal.hybris.data.ApplePayLineItem;
import com.paypal.hybris.data.PayPalAddressDetailsData;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.PayPalCreateOrderData;
import de.hybris.platform.commercefacades.order.CartFacade;
import com.paypal.hybris.data.ApplePayAddressDetailsData;
import de.hybris.platform.commercefacades.order.data.CartData;
import com.paypal.hybris.data.PayPalOrderDetailsData;
import de.hybris.platform.commercefacades.address.AddressVerificationFacade;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.converters.Populator;
import com.paypal.hybris.data.PayPalResponseData;
import com.paypal.orders.AddressPortable;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.user.data.PrincipalData;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import com.paypal.hybris.facade.facades.PayPalAcceleratorCheckoutFacade;
import com.paypal.hybris.facade.facades.PayPalGuestCheckoutFacade;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractPageController;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.acceleratorstorefrontcommons.security.GUIDCookieStrategy;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.core.enums.CreditCardType;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.RequestContextUtils;

import java.util.List;
import java.util.Optional;

@Controller
@RequestMapping(value = "/paypal/checkout/hop")
public class PayPalHopPaymentResponseController extends AbstractPageController {

    private static final Logger LOG = Logger.getLogger(PayPalHopPaymentResponseController.class);
    private static final String APPLEPAY = "applepay";
    private static final String STATUS_INVALID_SHIPPING_POSTAL_ADDRESS = "STATUS_INVALID_SHIPPING_POSTAL_ADDRESS";
    private static final String FAILED_3DS_FOR_USER_S = "3DS failed for user %s";
    private static final String FAILED_3DS_VALIDATION = "3ds.validation.failed";

    @Resource(name = "defaultPayPalAcceleratorCheckoutFacade")
    private PayPalAcceleratorCheckoutFacade acceleratorCheckoutFacade;

    @Resource(name = "guidCookieStrategy")
    private GUIDCookieStrategy guidCookieStrategy;

    @Resource(name = "payPalGuestCheckoutFacade")
    private PayPalGuestCheckoutFacade payPalGuestCheckoutFacade;

    @Resource(name = "payPalConfigurationService")
    private PayPalConfigurationService payPalConfigurationService;

    @Resource
    private AddressVerificationFacade addressVerificationFacade;

    @Resource
    private Populator<ApplePayAddressDetailsData, PayPalAddressDetailsData> applePayPayPalAddressDataPopulator;

    @Resource
    private Populator<ApplePayAddressDetailsData, AddressData> applePayAddressDataPopulator;

    @Resource
    private Populator<PayPalAddressDetailsData, AddressData> payPalAddressDataPopulator;

    @Resource(name = "cartFacade")
    private CartFacade cartFacade;

    /*
     * (non-Javadoc)
     *
     * @see
     * de.hybris.platform.storefront.controllers.pages.checkout.steps.HopPaymentResponseController#doHandleHopResponse
     * (javax.servlet.http.HttpServletRequest)
     */
    @RequestMapping(value = "/response")
    public ResponseEntity<String> doHandleHopResponse(final HttpServletRequest request,
                                                      final HttpServletResponse response,
                                                      @RequestBody final PayPalResponseData payPalResponseData) {
        final String checkoutType = payPalResponseData.getFlow();
        final String fundingSource = payPalResponseData.getFunding();
        final PayPalOrderDetailsData orderDetailsData = acceleratorCheckoutFacade.getPayPalOrderDetails();
        try {
            if (acceleratorCheckoutFacade.isPickupInStore() && orderDetailsData.getShippingAddress() == null) {
                PayPalAddressDetailsData billingAddress = PAYPAL_HOSTED_FIELDS.equals(fundingSource)
                        ? payPalResponseData.getBillingAddress()
                        : orderDetailsData.getBillingAddress();
                orderDetailsData.setShippingAddress(billingAddress);
            }
            if (APPLEPAY.equals(fundingSource)) {
                PayPalAddressDetailsData payPalAddressDetailsData = new PayPalAddressDetailsData();
                applePayPayPalAddressDataPopulator.populate(payPalResponseData.getApplePayBillingAddress(), payPalAddressDetailsData);
                orderDetailsData.setBillingAddress(payPalAddressDetailsData);
                orderDetailsData.getShippingAddress().setEmail(payPalResponseData.getEmail());
                orderDetailsData.getBillingAddress().setEmail(payPalResponseData.getEmail());
            }
            if (StringUtils.equals(EXPRESS_CHECKOUT, checkoutType)) {
                if (getUserFacade().isAnonymousUser()) {
                    payPalGuestCheckoutFacade.processCheckoutForAnonymous(orderDetailsData.getShippingAddress());
                    guidCookieStrategy.setCookie(request, response);
                }
                acceleratorCheckoutFacade.processExpressCheckout(orderDetailsData, fundingSource);
            } else if (StringUtils.equals(MARK_CHECKOUT, checkoutType)) {
                CartData cartData = acceleratorCheckoutFacade.getCheckoutCart();
                Optional<String> currentUser = Optional.ofNullable(cartData.getUser())
                        .map(PrincipalData::getUid);
                currentUser.ifPresent(uid -> LOG.info(String.format("Process response on submit payment for user %s", uid)));
                if (PAYPAL_HOSTED_FIELDS.equals(fundingSource)) {
                    orderDetailsData.setBillingAddress(payPalResponseData.getBillingAddress());
                    if (isHostedFields3DSVerificationRequiredButNotProvided(orderDetailsData) ||
                            !acceleratorCheckoutFacade.isThreeDsVerificationSuccess(orderDetailsData.getAuthenticationResult())){
                        currentUser.ifPresent(uid -> LOG.info(String.format(FAILED_3DS_FOR_USER_S, uid)));
                        return ResponseEntity.badRequest().body(FAILED_3DS_VALIDATION);
                    }
                }

                final String orderId = cartData.getPayPalOrderId();
                final CCPaymentInfoData paymentInfo = acceleratorCheckoutFacade.getCCPaymentInfoByOrderId(orderId);

                final CCPaymentInfoData payPalPaymentSubscription = acceleratorCheckoutFacade
                        .updatePayPalPaymentSubscription(orderDetailsData, paymentInfo);
                acceleratorCheckoutFacade.setPaymentDetails(payPalPaymentSubscription.getId());
                currentUser.ifPresent(uid -> LOG.info(String.format("Cart for user %s, is ready for confirmation %s", uid, isReadyForConfirmation())));
            } else {
                GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                        GlobalMessages.ERROR_MESSAGES_HOLDER, "error.something.went.wrong", null);
                return ResponseEntity.ok(CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS);
            }
        }catch (ConversionException e){
            LOG.warn("This country not support delivery mode", e);
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.ERROR_MESSAGES_HOLDER, "checkout.multi.incorrect.deliveryAddress", null);
            return ResponseEntity.ok(CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS);
        }
        return ResponseEntity.ok(getPayPalCheckoutResponseUrl());
    }

    private boolean isHostedFields3DSVerificationRequiredButNotProvided(PayPalOrderDetailsData orderDetailsData) {
        return payPalConfigurationService.isThreeDsVerificationOnCheckoutAlwaysRequiredEnable() &&
                orderDetailsData.getAuthenticationResult() == null;
    }

    @PostMapping(value = "/create-order")
    public ResponseEntity<String> createOrderResponse(@RequestBody final PayPalCreateOrderData payPalCreateOrderData) {
        String orderID ;
        final String flow = payPalCreateOrderData.getFlow();
        if (APPLEPAY.equalsIgnoreCase(payPalCreateOrderData.getFunding())) {
            AddressData addressData = new AddressData();
            applePayAddressDataPopulator.populate(payPalCreateOrderData.getApplePayShippingAddress(), addressData);
            if (!acceleratorCheckoutFacade.isPayPalAddressValid(addressData)) {
                return ResponseEntity.status(HttpStatus.NOT_ACCEPTABLE)
                        .body(STATUS_INVALID_SHIPPING_POSTAL_ADDRESS);
            }
        }
        if (MARK_CHECKOUT.equals(flow)) {
            orderID = acceleratorCheckoutFacade.createPayPalOrder(payPalCreateOrderData);
            final CreditCardType paymentType = acceleratorCheckoutFacade.setCreditCardType(payPalCreateOrderData.getFunding());
            boolean isShouldBeSaved = false;
            String nameOnCard = StringUtils.EMPTY;
            if (payPalCreateOrderData.getHostedFieldsData() != null) {
                isShouldBeSaved = payPalCreateOrderData.getHostedFieldsData().getIsShouldBeSaved();
                nameOnCard = payPalCreateOrderData.getHostedFieldsData().getNameOnCard();
            } else {
                isShouldBeSaved = payPalCreateOrderData.isSavePaymentMethod();
            }
            acceleratorCheckoutFacade.createPayPalPaymentSubscriptionForMarkCheckout(orderID, paymentType, nameOnCard, isShouldBeSaved);
        } else {
            if (APPLEPAY.equalsIgnoreCase(payPalCreateOrderData.getFunding())) {
                orderID = acceleratorCheckoutFacade.createApplePayOrderForExpressCheckout(payPalCreateOrderData.getApplePayShippingAddress());
            } else {
                orderID = acceleratorCheckoutFacade.createPayPalOrderForExpressCheckout();
            }
        }
        LOG.info("Order was created with id - " + orderID);
        return ResponseEntity.ok(orderID);
    }

    @GetMapping(value = "/apple-pay/line-items")
    public ResponseEntity<List<ApplePayLineItem>> getApplePayLineItems() {
        return ResponseEntity.ok(acceleratorCheckoutFacade.getApplePayLineItemsFromCart());
    }

    @PostMapping(value = "/apple-pay/shipping-address/update")
    public ResponseEntity<List<ApplePayLineItem>> getApplePayLineItems(
            @RequestBody final ApplePayAddressDetailsData shippingAddress) {
        acceleratorCheckoutFacade.updateApplePayShippingAddress(shippingAddress);

        return ResponseEntity.ok(acceleratorCheckoutFacade.getApplePayLineItemsFromCart());
    }

    @ExceptionHandler(ApplePayInvalidAddressException.class)
    public ResponseEntity<ApplePayErrorData> handleApplePayInvalidAddressException(ApplePayInvalidAddressException e) {
        ApplePayErrorData errorData = GenericBuilder.of(ApplePayErrorData::new)
                .with(ApplePayErrorData::setCode, APPLE_PAY_INVALID_SHIPPING_CONTACT_ERROR_CODE)
                .with(ApplePayErrorData::setMessage, getMessageSource().getMessage(e.getMessageCode(),
                        null, getI18nService().getCurrentLocale()))
                .with(ApplePayErrorData::setContactField, e.getInvalidField())
                .build();
        return ResponseEntity.unprocessableEntity().body(errorData);
    }
    
    private boolean isReadyForConfirmation() {
        return !acceleratorCheckoutFacade.hasNoDeliveryAddress() && !acceleratorCheckoutFacade.hasNoPaymentInfo() && !acceleratorCheckoutFacade
            .hasNoDeliveryMode();
    }

    private String getPayPalCheckoutResponseUrl() {
        String responseUrl = CHECKOUT_MULTI_ADD_DELIVERY_ADDRESS;
        if (acceleratorCheckoutFacade.isLocalPaymentFlow()) {
            responseUrl = PAYPAL_CHECKOUT_MULTI_SUMMARY_PLACE_ORDER;
        } else if (isReadyForConfirmation()) {
            responseUrl = CHECKOUT_MULTI_CONFIRMATION_PAGE;
        }
        return responseUrl;
    }
}
