package com.paypal.hybris.addon.controllers.misc;


import com.paypal.hybris.addon.controllers.PaypaladdonControllerConstants;
import com.paypal.hybris.addon.model.PayPalMiniCartComponentModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import com.paypal.hybris.facade.facades.PayPalAcceleratorCheckoutFacade;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.AbstractController;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.contents.components.SimpleCMSComponentModel;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.order.data.OrderEntryData;
import de.hybris.platform.commercefacades.user.UserFacade;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

@Controller
@Scope("tenant")
public class PayPalMiniCartController extends AbstractController {

    private static final String CART_DATA = "cartData";
    private static final String ENTRIES = "entries";
    private static final String NUMBER_ITEMS_IN_CART = "numberItemsInCart";
    private static final String NUMBER_SHOWING = "numberShowing";
    private static final String LIGHTBOX_BANNER_COMPONENT = "lightboxBannerComponent";
    private static final String EXPRESS_CHECKOUT_COMPONENT = "expressCheckoutComponent";
    private static final String PICKUP_IN_STORE_FLOW = "isPickupInStoreFlow";
    private static final String PAYPAL_EXPRESS_CHECKOUT_ENABLED = "isExpressCheckoutEnabled";

    @Resource(name = "cartFacade")
    private CartFacade cartFacade;

    @Resource(name = "cmsComponentService")
    private CMSComponentService cmsComponentService;

    @Resource(name = "userFacade")
    private UserFacade userFacade;

    @Resource(name = "defaultPayPalAcceleratorCheckoutFacade")
    private PayPalAcceleratorCheckoutFacade acceleratorCheckoutFacade;

    @Resource(name = "payPalConfigurationService")
    private PayPalConfigurationService defaultPayPalConfigurationService;

    /**
     * Controller that handle minicart popup with embedded PayPal buttons
     *
     * @param componentUid
     * @param model
     * @return
     * @throws CMSItemNotFoundException
     */
    @GetMapping(value = "/cart/rollover/paypal{componentUid}")
    public String rolloverMiniCartPopup(@PathVariable final String componentUid, final Model model)
            throws CMSItemNotFoundException {
        final CartData cartData = cartFacade.getSessionCart();
        model.addAttribute(CART_DATA, cartData);

        final PayPalMiniCartComponentModel component = (PayPalMiniCartComponentModel) cmsComponentService
                .getSimpleCMSComponent(componentUid);

        final List<OrderEntryData> entries = cartData.getEntries();
        if (entries != null) {
            Collections.reverse(entries);
            model.addAttribute(ENTRIES, entries);

            model.addAttribute(NUMBER_ITEMS_IN_CART, Integer.valueOf(entries.size()));
            if (entries.size() < component.getShownProductCount()) {
                model.addAttribute(NUMBER_SHOWING, Integer.valueOf(entries.size()));
            } else {
                model.addAttribute(NUMBER_SHOWING, Integer.valueOf(component.getShownProductCount()));
            }
        }
        if (defaultPayPalConfigurationService.isExpressCheckoutEnabled()) {
            model.addAttribute(LIGHTBOX_BANNER_COMPONENT, component.getLightboxBannerComponent());
            model.addAttribute(PICKUP_IN_STORE_FLOW, acceleratorCheckoutFacade.isPickupInStore());
            model.addAttribute(PAYPAL_EXPRESS_CHECKOUT_ENABLED, defaultPayPalConfigurationService.isExpressCheckoutEnabled());
        }
        return PaypaladdonControllerConstants.Views.Fragments.Cart.CART_POPUP;
    }
}
