/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Links;
import com.paypal.api.payments.PayoutBatch;
import com.paypal.api.payments.PayoutItem;
import com.paypal.api.payments.PayoutSenderBatchHeader;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Payout
extends PayPalResource {
    private PayoutSenderBatchHeader senderBatchHeader;
    private List<PayoutItem> items;
    private List<Links> links;

    public Payout() {
    }

    public Payout(PayoutSenderBatchHeader senderBatchHeader, List<PayoutItem> items) {
        this.senderBatchHeader = senderBatchHeader;
        this.items = items;
    }

    public PayoutBatch createSynchronous(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("sync_mode", "true");
        return this.create(apiContext, parameters);
    }

    public PayoutBatch createSynchronous(APIContext apiContext) throws PayPalRESTException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("sync_mode", "true");
        return this.create(apiContext, parameters);
    }

    public PayoutBatch create(String accessToken, Map<String, String> parameters) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext, parameters);
    }

    public PayoutBatch create(APIContext apiContext, Map<String, String> parameters) throws PayPalRESTException {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        Object[] parametersObj = new Object[]{parameters};
        String pattern = "v1/payments/payouts?sync_mode={0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parametersObj);
        String payLoad = this.toJSON();
        return Payout.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, PayoutBatch.class);
    }

    public static PayoutBatch get(String accessToken, String payoutBatchId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Payout.get(apiContext, payoutBatchId);
    }

    public static PayoutBatch get(APIContext apiContext, String payoutBatchId) throws PayPalRESTException {
        if (payoutBatchId == null) {
            throw new IllegalArgumentException("payoutBatchId cannot be null");
        }
        Object[] parameters = new Object[]{payoutBatchId};
        String pattern = "v1/payments/payouts/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Payout.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, PayoutBatch.class);
    }

    public PayoutSenderBatchHeader getSenderBatchHeader() {
        return this.senderBatchHeader;
    }

    public List<PayoutItem> getItems() {
        return this.items;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Payout setSenderBatchHeader(PayoutSenderBatchHeader senderBatchHeader) {
        this.senderBatchHeader = senderBatchHeader;
        return this;
    }

    public Payout setItems(List<PayoutItem> items) {
        this.items = items;
        return this;
    }

    public Payout setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payout)) {
            return false;
        }
        Payout other = (Payout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PayoutSenderBatchHeader this$senderBatchHeader = this.getSenderBatchHeader();
        PayoutSenderBatchHeader other$senderBatchHeader = other.getSenderBatchHeader();
        if (this$senderBatchHeader == null ? other$senderBatchHeader != null : !((Object)this$senderBatchHeader).equals(other$senderBatchHeader)) {
            return false;
        }
        List<PayoutItem> this$items = this.getItems();
        List<PayoutItem> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Payout;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        PayoutSenderBatchHeader $senderBatchHeader = this.getSenderBatchHeader();
        result = result * 59 + ($senderBatchHeader == null ? 43 : ((Object)$senderBatchHeader).hashCode());
        List<PayoutItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }
}

