/*!
 * paypaljsbuttons
 * JavaScript integration for PayPal's buttons
 *
 * @version 2.9.3
 * @url http://paypal.github.io/JavaScriptButtons
 * @license MIT
 */

/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/dist/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(1);


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var DataStore = __webpack_require__(2),
	    factory = __webpack_require__(4),
	    constants = __webpack_require__(3),
	    app = {};
	app.counter = {
	    buynow: 0,
	    cart: 0,
	    donate: 0,
	    subscribe: 0,
	    checkout: 0
	};
	app.create = function (business, data, config, parent) {
	    var result = factory(business, data, config, parent);
	    if (result) {
	        // Log how many buttons were created
	        app.counter[result.label] += 1;
	        // Add it to the page
	        if (parent) {
	            parent.appendChild(result.el);
	        }
	    }
	    return result;
	};
	app.process = function (el) {
	    var nodes = el.getElementsByTagName('script'),
	        node, data, business, i, len;
	    for (i = 0, len = nodes.length; i < len; i++) {
	        node = nodes[i];
	        if (!node || !node.src) {
	            continue;
	        }
	        data = new DataStore();
	        data.parse(node);
	       
	        // If there's a merchant ID attached then it's a button of interest
	        if ((business = data.pluck('merchant') || node.src.split('?merchant=')[1])) {
	            app.create(business, data, {
	                type: data.pluck('type'),
	                label: data.pluck('button'),
	                size: data.pluck('size'),
	                style: data.pluck('style'),
	                host: data.pluck('host'),
	                shape: data.pluck('shape'),
	                buttonId: data.pluck('button-id'),
	                buttonType: data.pluck('button-type'),
	                buttonDisabled: data.pluck('button-disabled')
	            }, node.parentNode);
	            // Clean up
	            node.parentNode.removeChild(node);
	        }
	    }
	};
	// Support node and the browser
	if (typeof window === 'undefined') {
	    module.exports = app;
	} else {
	    // Make the API available
	    if (!window.paypal) {
	        window.paypal = {};
	    }
	    window.paypal.button = app;
	    // Bind to existing scripts
	    window.paypal.button.process(document);
	}

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var constants = __webpack_require__(3);
	
	function DataStore() {
	    this.items = {};
	}
	DataStore.prototype.add = function addData(key, val) {
	    // Remap nice values
	    key = constants.PRETTY_PARAMS[key] || key;
	    // Wrap strings in the value object
	    if (typeof val === 'string') {
	        val = {
	            value: val
	        };
	    }
	    this.items[key] = {
	        label: val.label || '',
	        value: val.value || '',
	        editable: !!val.editable
	    };
	};
	DataStore.prototype.get = function getData(key) {
	    var item = this.items[key];
	    return item && item.value;
	};
	DataStore.prototype.remove = function removeData(key) {
	    delete this.items[key];
	};
	DataStore.prototype.pluck = function pluckData(key) {
	    var val = this.get(key);
	    this.remove(key);
	    return val;
	};
	DataStore.prototype.parse = function parseData(el) {
	    var attrs, attr, matches, key, label, value, editable, len, i;
	    if ((attrs = el.attributes)) {
	        for (i = 0, len = attrs.length; i < len; i++) {
	            attr = attrs[i];
	            if ((matches = attr.name.match(/^data-([a-z0-9_]+)(-editable)?/i))) {
	                key = matches[1];
	                editable = !!matches[2];
	                value = attr.value;
	                if (key.indexOf('option') === 0) {
	                    value = value.split('=');
	                    label = value[0];
	                    value = value[1].split(',');
	                }
	                this.add(key, {
	                    label: label,
	                    value: value,
	                    editable: editable
	                });
	            }
	        }
	    }
	};
	module.exports = DataStore;

/***/ },
/* 3 */
/***/ function(module, exports) {

	'use strict';
	var PRIMARY = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALoAAAAyCAYAAADr7cFEAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAB71JREFUeNrsXf114jgQd/zy/3IV4K0gbAUxFSyp4KCCkApCKiCpwKQCvBXgVGCoIE4FOBVw0q2cU7wSnhnJlp3TvOdlH/GHNPPTfMuEgYZOp1NyskdHduzYsWbHJPBEJsa/iB2vFmXD77Vlx5Lfe4D8OAKwN9JdHJ/aJc7cuYctSbBJy7LZDkUZIXA6CTX3aHuiXHMkgqkjD18079qkGTvygSgiEC8uLi72OqCPOxooZ+rOYxdFXWnbZABghwC94P+Ejpn577MYQ1cevyBTza1flxYw6bkbc2UK9K6DklvvwvRKm8u0HrhGf+kT0DnIfXDq3j9XUdzjbAxk4as1Oo9kHQ362uO4l0B3ZUma3DjomLSuC5SZJTtuLgSx/0/FccOOjfg7Vqt7sqMM9uz4LuTylySbBTuyrwB0BF72upWyAuYmd00rDpDM/0Qex41aDFooWjbcZ47Mra96yAsITo/V+SExktWvFEE8d8k+Hjw8nbguTbLZNJ0zABpj+GDiuryZMrxGmcexFZ8Uyvdf/4NF/8GHSwN/bO9Q6LGYaFQbT8m01VddMOBAlPGgtPzsEiiXkcDPRPKhSyGbgo2rsDgmSNLkXQl0pNYoLDNz3+RXso+fwe9q6rnz+EfKjqcK9MLHbArk7oS7VQksaQh4uAAfqmsI2nkNANdCAi1UNtCFPrYhG8ErLpu/m8bIzi0k2RRQPrNzbxTPpPMC08wFFOgaEfDMzwRO1G69RNwDFXAh+PBKAHmECNJj6botZs4WA9uTClj8O0TiQtVRyOU6w/IBKZ9I57rElrXGjOqjC+ZuEWNS0ZxY7IBqaQ7aCGmSmzSYbDH3hHTaGwDkMSawrbtCwiJtA3pev9LkGVEeIOsmyyUkmrMCwMwVghGf/DfByNwQ5OTFKwSb2l7MIu0HHc+iBjArSkgokLWBApoL2URdyUYRc4yw4w5tZ1yEaeaMvEdM+Fm+Pvjd0WiDkRgqiFmJn1CXBcGTRzmoRlqlskGT7wJcAei5BvKkY7moFu41lg9U12WsKCKMBTgpWnhTc1c6r5Iq3I8UKFTuL44AmQ6oy8JdhTtqxoVbGO771r67EuDGKo9MCtAnDkCu8x4g8zgogY7UGnOLE9lIILsP3JSbM5W5ZDxJga7JrFqsNlwWA/crQFrSJnqoKSAX9EYE+l7nukQOJsG14J1kVpfIlc6v5T0cvJ/je/Bfnw1lHCqCui/XhqnED2Bp0pXfHMgmldynJRIfmViwU6kPitpnkyncL3ocKTbHdk0z6fk7W70XhD6blS5wg6bLzowlN+0dQvLG1p7ekRRzYdKGcVNAjhzLpHb9zCj9jcx526B5DZhG+XZV4EVZcIr7bCm53irzhABIdGYMxw7lcpTBhZjDK7SQg9ngTeTpa9ADrXGsgxWxyFYYm4fQppMz94AWNdYKqwKl5bl0YIcgz+sLDlFYmiDkArUSOVHx7ALHWmOn0lxAZh6x2+2g2ghwnyNWiyAW2daiZTJRPiuNC2itGkvgz4543R9zCZFJeGrAyQPEHywumdbTeAL4kEBn00Kzkj5o+TPV2ERRtYgFoydA3iya7tty6o5nVvgmjZVBtufJYgJAphfFdxOKTC+Rkey5JH59gKWch7UgyJcO87Sq7AskNuBuToZI8S0AixdbLNo3/P0g5pwBWhdAexMojW0BvA0iIKTA1UBHMvMHcWLagotFDUAR1AtAkCljcgkQDu/gu0XUDyCWArN9bmrZ6kFwgU4ZSu28WMBGCF4oXRfoDTLLIG+NBDNnFhcQBJTQ6mNVA7AFNk7PLbl2tsb3yfIRAQtRiqWKDyFBa7giLEOXludkc0fOAgHKqOeyiQjv5LknAvYblQ8hMhB9cwh0cGlbxBz3NgEi3AwbGvMRuguqhe1zbdESIZskIJTwEYHoWaC73D6XITRHAmAkDxqhfRkl0tynhnNVNWzZ0Oalw4wUp9umRSnqAUkA75OiAv1dCXTH2+ew95zrXmssCjs87wrtEqQsXFP3ZYE83/X+3QMig5KLukWkADgHdx7gmgHfFTEXug+9DhCn711BFFdUBajcoFBCKXRQC2srwrO2bc0D+PyIONdXIRuTHyyI6+4odvtc3XWxvemWQk/E6+LArK2XEnNsKO6ZpiAD0ZTOYieRZ6fIPRKyiQweX1DcOF1tgAMdun2uzdRV2pJb1MbifUaeD6l+nlvIrpWQk5dQKQAbmfAhRKy6Q4uT+uhL75gKwlj3yOseKO8zQW6EKVqUTUa0YkZBu+I79Pa5OtBjg4fbZGhqSXuAgWj5hTpKS8We8Ui8NkLwru153FmS/8Zg4UL4cTgHdOdaQxLYysDMV4ycAsdKEhzi7Qal4Vx6oYAkizsN6OnVymJDFdmBCPS9aRah0189ENE+5tfXtrWX/awBbakzwrisbOaw/Kxlx7KZITJdR5FyHCHwlmtemJRjW3o/LdagxyT1q0QKH+1FaO60ix4PMRbo+0x4w9Yi+MIkahlcuVzVeFJ1SGZf+D2YX1qwW0QO2f+ogadBgnxOLXR48jQUkGNeCrr2HPM0VKBDA6/cc8vTUEGOeS3yxHPM0xBBHrfZsOXJU1+ADu2823lu9Z9CzwItQVKEptVPTx3RpWeBlnjJe9YA8rSDPhNPFugfAQYATZCeCRL6KXcAAAAASUVORK5CYII=',
	    VECTOR_PRIMARY = 'data:image/svg+xml;base64,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',
	    CHECKOUT_LOGO = 'data:image/png;base64,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',
	    VECTOR_CHECKOUT_LOGO = 'data:image/svg+xml;base64,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',
	    CHECKOUT_REVERSE_LOGO = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOsAAAA8CAMAAACw771wAAABRFBMVEUAAAAjHyD///////8jHyD///8jHyAjHyD////+/v7////b29sjHyAjHyBZVlf////Ix8f///8jHyD///////////////////////8jHyAjHyD5+fn19fXn5+cjHyD////u7e3///+tq6sjHyDx8fHIx8f////h4eH+/v7S0dG+vb3///8jHyC/vb6Zl5f//////////v62tLX///9/fH3////+/v6enJz+/v7////t7Oz////i4eHT0tKRj5BmZGT////CwcG5uLj////////29vb8/PympaVsamr///+tq6t4dnZycHD////q6enl5eX////a2trOzc7s6+uhn5/////r6+v////o6Oj////////7+/vv7+/m5ub////29fb6+vrh4OGtq6vR0NDIx8eRj4+Bf3/i4uKtq6v////19fXx8fHJpFAaAAAAaXRSTlMAM63mGoAmDb/xQJkUA0DPmRAhsDDs358gMAbm2bMKUL9wZinMgGCmK4xyjy1aWbuC+GBXTcK4W/3z8tvMs0AwopaM6dfFenRNTEpCIgvm2ci/nntwbFg2HuXNs7Gql5aTjIB5ZmZZSTOLYEonAAAHXUlEQVRo3u2aZ5vaMAzHE5oQEkIogYZ1QCml9A5K99577733cPv93zfUxlLi2KbtlRc8/b067mKhvyzLip4zGKGZRT70W8aq4ZtS8o6xWlimgnzJWCXywYWtAh8+f6FiBysl9uYJksX+H6cuXJuJNVaI80TK99OxWt9YGbqniYITV82JsTI4p4iK71dNR2Mgn8ZySpu3FaFg/TfuQout6bKPJ4iSE9c0Sdz8p7fVIMv6YNFzZTIs+vHsd6LmtKUOvJlNuDl7+1d3YSul9SjR8OOWOoVNCZtSwFtS60is3jeWZReIjk/qIzESFrS3DwMI5l/hDEXrO9cPzfLG0GOtsTV9GritWq1XlPbC7EWdwGxuQhZb7WzrsdqudjH4ZkMZVrNVWWf2SFa50824mUOZ9Q1IG41vsK/WHb1WpdND2TL3kNabxb0Vmeb1qzcIw6NacRk+vi3F8f3HZloVV2ypSGTs1HqzuLci7aZ2MfjWoGX4GGqBt2Rw8fgDVU11thMpZ/Ra9N5K2dCuBt/o50c467ZkcuR8IC8E/hqR8vAvVOoj2dEtBt8KNHC4DG/L1lrNPZCfWIuvLtsx1YgAL9EGOcq+UR9Jd2a9jq0XcEyclsq3On3oPlp9MVPqyVwud1VaZm7w1T36C1vwpuXn2f1vxR45FqU7k8J+TjjashglHEmb/nEXAVgU/ZB2qZPQMYwuW+sYMWeSi/27sPZY9ra+iLW+lmo9QOD8UwpJraXQRFgG7/JQWzPBR3QCz4K3xDMo75JaS1Yz0Zfy9jnhW08ow/slxzUXc0OmFYoHlBOs1WmmGln+A24AnayRUBdHsibE1p014xOJ9Qn3DRbflGqFFJ7xRFY8Ovy4zm9/0Dqeex7sKMZsTBM7jF9iLDCIHxAjae3AkfSZ9fXY+nCaEJ3wTez8j2dqPZybIesT/Z2EUWUvsyb4Z1OpwzV+JxYDc8R2JS7SjYj9ejjgGdw0h6wtjGpCJFuhCa1LnUod8lLtdgL+5W9nvuzki4UBzDb5tub2actwMR8zS1i4hLzZJm0kOtq1AG2Lx38dtPisegqhAm/J9pn1WcJy9aTfjb9tRzvZl7bRVloufBUMYBRl+Iha61m42k3KDjAYb1LQSXeO6B6owGKfZzDcMhXwlhSZ9cCFExyfgKLMepn6Ju38szOYclDbr+6gzhyCQFdDMxA7DexAlfcFIctg5L2HIzlkUsFe5MMmi1Sxb7tgAKO4cso5jdZ1vpxWiZELBp+gTRLp4dvSNUvpDB4nI0krHLJuT0CqiI1984QBzP7MXWXslgxgxBd1HPjsv8I9AEk8dWZZhvYtqmBvRdxbtEzJI9kq/kYZPnkkx5FdOTsVXzegRxc6yDJBGAZO4lEYO9c0RygU2FsROwxcZH1s2wWC8JBvLgxgJJ1/BJuqKMNtIqNeMiEQVdpUeS54l2z51pqGkUd1zZZEEpZPOvCBJmkNxRL7VqD3lazzv3TvSA7jaccGojPOFF2FjFqqV4YkPtT1zaANq9WRLFdKAVivMOsVHsoIX4djsQxH9/YymE7g3O2Fxwbw/X4HiiKnjjcOf14PUQa7NRpJuVTDWccnm2FDJJUDmP3VnJSDvzmAiXYldqUBCz4m7wGjx5sFfDP3lZF07cSbbS8j9LZ6ALNNLvXN7d8aG1Spjm8ZL5r+jvR7C0+7ADK4oBrAlPu/9tHhylGlDCBYygHMSbnW3QuMDco2pc+P9lfe87T4FdXkiSAk9Qb0tQ0hktF4bn2esM/4VMuBt0GIpHoAU5ZK9fRjA9g7wOZaB0ys3zQ7sBupJF6DywoiCUcyjcetN7vs8abJz3CFvpXIBjCHJUrPyaXisYFKq9m0HMexJtDOoti4whEQI1k3RK3ooIe+4/yafbQhksoBjKQ07aMJpRvAeAqtayanA/eAkMTQ8msjibW63Dhsa0E9gCGZSq/AUdUNYAR68BYjOEP6wmNi1M6oIlkj6Vcg/GqrHsBsS6fuvn0Hn0L91Q5gVN646/QVaLugCJJY2PDkAEaEgNjgl3XUfNvqAUykuU71AxhAFNHeXuxA8YE8EJI4qqgjCVRR2m8vjnamcqM7knf+l9CWGiL6AYzImMgRcl3YQV0kdymsN9QDmMNCo6/HwUkj0nCJiHhF5dFj2E7rsjKSRqSMZDdV8fEAZi9o3bWo1gq6ErPoy1+C8Ix0RLI30FVFEioxgM1UUosvZ5fh64tq9SSFUnafuAXR+64ptPxCJCH4yiyu4zzwUotd5IamJVTvmyt7wk4kbs0W8qA0EFp+bSRBrIurmudhO16qAhDgOdL6bFGtjQKjJ3+k7s6DHXtcY8/bKIMDV9JnVqrs6bHc+jji7xuwoF5Bvs3jlyjDgLG51Ly+7XnSf1RBLf+fWu95+uc8e877y7gML40Sbdchr5fBrVeg9bGxNPLm1IWCsiR2C13TUkhO+ZfEdaT1qbE0LDzlXxYHkdaGsTQ81PIvjevLPK5AhFr+5dHYzWgYSwQ1TCtPzaM0jP/85z9qfgLuxVZptT4OCAAAAABJRU5ErkJggg==',
	    CREDIT_LOGO = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAegAAABECAYAAABK+aYtAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAFLhJREFUeNrsXb1vHMcVH16YNC50KeKWq9qFjk1aHvsEoqp00bEMEIDkP2Dx0qUiCbgnVcYNT0DagEukc6OTEQdIEINLpEggGdbJAJXEiq3sUG+V1Wp3b95782b2eO8HHOiP29uZeW/e17x5b8U44vXr14P8z5aRxSz/TOGfs5WVlcwoFAqFQrGEWHFUzqP8z3GkMaagtM9zhT1RkikUCoVC8UY5J6+7g+f559iOSSmjUCgUipuMnsN3Bh0abz//WG/+IlfSB/mnryRUKBQKhSrobmE3/5zB2bhCoVAoFEunoNc6PP6BKmmFQqFQLKuCTjo+BxvmPtZwt0KhUChuEuZmcdvMrAWZy+HKysqeklShUCgUN15BQ7b0xQLN57benVYoFArFTcC8EHeyYPN5oCRVKBQKxTIo6EVLvtpSkioUCoViGRT02oLNp68Z3QqFQqFQD7qjSlrJqlAoFApV0N2DetAKhUKhWHis3kBvVD1ohULRCjgKa5QVKysrqa6SorMKOmfg4YLOKeugMOh79Oy1DafSbSGUXI5ZPudpB8aZ5H+sPNuAv4nDM9fjN9BJL/+kbUrbo7z0xicO9OFgmo9zVrPOCfeHJY0jxBjfmZ9nWeC+xi0TGRlei8lX+ed5/vnO86B7YFj8IP/8MP/8CP4W2OyS9Qub5Exgo0xLwmNS3SwKNt22gP+l6PZokdunwvqcOnw1yn4EgWrHuONRsNo9tpfP56TyrgPzpjdAZ/hEaExlWJlzr2KgnHn8fbvWaUm+ZQF5tjCUbpeefRxBQU/azqC5ltDXAsrZ4vv8823++Vf++Sb/fJV/nsI/f2e6hwdCVqxllsKIst299rXcqVfsCNPtFNqn7i/o+mwg5htUMcOaXsDe8Pn+oqxwVTYOO8gnI+Gl7guvQWFgHYB8OwOnkYO7mEhGxfiIktvU87AB6/AtKNJQsIr5ChT1L/IF/ahDgiwJ8I4+GAKP9ZqZVwEZhG7WOl9AurmON1iIO1/DXVDMUkZx054eBOSTxGEd+kY+F2fqUV+4YAjG0WPGcQJGFs9ajJFQeNJDWEhYhRkDVkl/mH9+kxNxc4kEfZkBtbuXBy8s8KZcxK5snVHQVmlBCPIgBN3KIfvANBuAEZ54og0HLzzqC8pe2Sc8i1HsTyLJ8Hf2Tk+IyLEU9MvSP/86J+JPIwv6GIS1G+VUw90LY1SV6Xa8CIuDMWCkcyPAmwp5PjiLpJje2d8d4N808p6xEQVnOUeQh2XD8k6krTbrCSmW/0SaUNWqs0r6g4iyLJaStBb2rlEskoK+fq+Hc7YurU8qrJztWp0F3mdThlcWik9CrEcW2RGxwCR9DajzM5F6UthITa9FwHMQy4P+pvLvVjlvRxRkw4jvvq96duEMK4udBVgfV/mQCSvnGBGHqoJe6yCfSJ8Hm0pWdRKRF4c5L7jwwQA5v2lkg/16fXtCHkQMBX3V4LnHDHPHrGWe6Fk0GRsR3z1wSQRaEAV9KaScBybeccClZ2eGwyd9IQdrHlLP+oKLEVyh8iWLy9GBWPS9HsOqgGJ5FWlCzxr++wf2LDq3iD7rsCArCPKw9O+3gPETxoYbmoBZtDcImPW2wurcM90S08GCOwQDJhVQzlYpnUWcOyfEbc+vjypyNjH0SNugYY2llUrWIUekgM3wTltyHgbE+cVS0I/aFDRnUDG85/+2KGgLe+E8hoLGbLz1JuYCK+6UYKlqopi8gr7XQjdL/wMC3YZG+PyWCVe+kkgQ8108ZloZ59Dh+2VjAYP3ipww93fSwHNYZfsQaWScMPZL1UixuFMyajk8afNu9j3s6bcGtz0Hztd0bw7PWQNlhPh9u35t0aWs4JNVD4qlTlmGxvM57w1uBSE3b9aW7WrPe+Da2GMT97znxgN5LJDOoVsKdLu4YcaS0xr5LvMJYUwfPd+t8Gus0AU8cB+Ebpluswq9OYlHdfsbyyeJB6N800OVLoy+OMrft9/iiOzUrLsrdvLfOGzYkwmVTvnvHc7hyxFGQee/55wX1WtYJA5Ch7itYv77nO/EyOQecDduhah1lqcirvfsSreTJTRgJI5WDjwo5ttWQLaVz7SGRf6xXpONvE1a5oRNPErn8Al2zTKm3JlxlTNBX0zbHBFY93Ui//TrDDhiVCGazGhV0B48tO8Dy4x/mnjXunwp6Knn7ynC0M01CepcWEB00YDxOgfwUqiyySq/e6CYncdllSbUm95roONaZJrW/Sbmzu40ID9gjFqrqK2STgnjuethjNh12ZDig1WmgKrDtwGFxZWD9xwLmM17KTQGJ0YrdftJzP8TVwpmuoS/6ZJ00ZIQcNhwXUag253SeyTp5iofnnimC/X6mVXOm5xwO4Q4D5myMpSCTgKPiXN9aR6scYQN+28x12RGKK6D+X2Usb7KVCxVhEwQs6HtLx2/+/SGeNBezrxAuKO7/eTP2N8bFwkMjndRLbOvl5WEY2cYaz1vU5ULopvPdiVxp+9jfaUseKDbCOiWOK6F/b2jEt32zZt61fPmVnc+ueZ5bVzGP2A4DpuCLS8Tz3vcR3haIgLkyxFB0cEqSkjQOsbyS4Xm0lEFlAGA+eGeZw86pIL+EjxoFzyLoKATAabYQDL4tIGBi6YC2G4/dk7H0FnGKgqXYiiFQinePXR8p/0e6cwRkolcK6ndr3mvb28A1UWnJSt8H+h2gOSvAdCtKI2440jrhMHXPj1GatGdPeF+1BgaXM7h2RHSOJw0RFQwSAM7IuisfjAquR6thCwuG49G6vd9h7hDhbf/Zt60s3RFDA86QTDhzIER+gaXwZo2/Map4Vc4GyJ/Jy3N1WY2zxyFEXqcMEeMxX1EFHCY44MBk24D46d14hYIuz6T9i48nXrcS5TM7XRe9i3Tq8fy5ryoyAPk7z3yEKm5j5zHpMbgwfDkOXG5p0hZMKgYMJgxvhA00rwoaM7mlU4Qs2Htv5j3S3rOw0VIzYxkeldBdszZwCDkfdYtxswxq7H+Ry7et/WGkQ3rTxFznFR+G7PZZkJ0Oxem28j1i1UlizBgMo97iXo/dtwVA7xNMJeML8zvZQ17YijFCy3zkDgSqtsTQyL/SEcVsMcS9BA3o89mAckrVlYpf05QzlcRkpsSX0wLrfROCV7ERFDIo1Cz/pjCCBuIzbiL2Mh2o2wzBNy5A93ODL7SVFfoxrlL6nO/UWTS1LMHz93j7whmK2dtSBv2NaUTV5PxIV3RK2PqiywCHyfCYxQ9315lTqbOw/UNe4XKZmpTz5G/6DpT1DB6HzbtHUML700KpVgqjRirUMa0zjODhDOXdbLz33O0lDFhwroKYLcQz9+qoVsCnw2iYpkUY4ptVDUIkxh3oCmt/h4GWB/MuGwk6LWn96Z11cg8yW+s8kK9L4DRxDbwCM6cN2dMWkF/b/yGuG0C2D8MP8ErRolPzOYdGVqoqQ3lgiaYkG+ITV328F0SuZKarMw6YEpAHjYIC4wns2v8t/QcE+cTSkG7emg+rw1SZFIIRZBEoMn1fe6W/z8IzBMJcuwxeHdNmG9Es+arCprTxYfrPdvnv4HP18Zf8ZGuN8nwjUmhfCAzdEgQAvb5JxUm3yIqjCctXo6rghua9iQbTGg7M80hwphdeQ5LUY99wliK8PhlxVCklsa87IgHjY5ECGdux+KV4j53U4Z/X9igqzs/xegLDk3uENZK3IgIkTVfVdAcAn8HSvY5Qrn+G7770siEx89yproy4RFL0L89V4UNi72mNAZFMathxj34Pay3P20Soogwt71mc9iySbih7RACbt4ajUvj2EHS3D570jKvY4Ki7kqI24fn7xUR2rhmwLfTDnnPWH3BoQunpCrmWWxxnYRAR5aC5hDZKto/G/e7ySHwaegXRuzBXLWwMR7v3GpL8LvbcJQ2Qo6r0dt39KKve982eA+YEP64ZY5RjarS3HYR85nCs/Podg+a2o+YwsRpXIRKTL7XUxohDblD4Nt584qhoMWLooABnlDGSTC6sUYEKrpDSVbueVQsf+2Ycrbec4z7z7EybqsKFuOFOVdbgk4sGYIp28I6mGSeuiL4+xivrqmLDtEalqLbfcSz24hw7h5GeVWFCSJjN42870Psv2EAvjgxbxp77DkaPNLzfsF0RKge9Aj5/UcMowWrQNek59/zKKC+Nt2BNRSOI717GPh9ViCulwU1sjTimHBmN/HB8PBe101xt0ZAuIa2665UxVbQKQjgaUUJuo4DVSULhPwEMTbq+mSR936ISIjkdSYbyv4xtrGH4eUPudD0hLlfqHyBrSJHLVBCyV1IpOff88jYLzukoD+JdPYsvXmrBLebuK5esquRYIU2pdrSuUemdFUa1TlhDDAXI2QjAt1mRLplLVdt2nDJoFvi+R1iCHDMhBHM2JD7ToAxTcE4dMXtGhmDVX4ZgY672HlV9rl0ERXJ8+33FDRHsbww3cHvcyJ9FvH9kp5YEfq6B5vmhKlsJsTzQtdnXBS5a5i7DzW2saFt15KPknQrPJBNX3RjjIOqZF0zaVOBSIO014XFEPHdI6TwHxZ8Lih3Hnoo3iR6fYmQ/FmsNdXozpDjkz7fvsaqJwHVlbNne+58HHkMmM1bKNwXc74zBa8p87xZqS0BB4j5zbOsMdncG/Bdn6FtqlckQTfXdaXWNE4YwiTxRXMho6IMW6VrLJGsBoIZg2ItMcrGNjZJXcfvsy64kEFAUX7Y+g11USXMGLF7inINkqWghwxidcGD/jQn0O9iDoCweaVa4Ulfh7nj+fdds7m3kHzqdI6HDInajXZbKFO5L7nZER5FRuUpAX62gnNEWEdrqN+LuLfKtLIRnB0EfYvmGXue+cangsbsQ+djj1LlQx/lT8WMCMO7+uWMHlGxdElB20ztj2MrZwLR0kAFFXxubGxXLdf5HSGsdtc1niCabGA28iTyNSKq8ZgY905UU6IBI8HPKfG5LbhaRjK0oTXna+grzhLMwC9HyGHsItZdtGFDAy95p2GpvC1WOb9X/jRAnfAQTULenkFzkypeRZA5VjHbZLBf5Z8Y9ba5G2XagfFSEqNc7+k6CwLwcn2uh/29bSG6XXaAbkPCMw8YfNlHrLtXMHnDhrofuyo6UMz75k33u62Gua8h+bDAISHy4VpoSLRhA9OgNfPmXVp3SuOQpmMs6aiC2Pm2hIJ+ZsLgCiys34JiPuuYo4LZvF0Q9CNM9ASs0gdCDO+zwcE20ksILeC4QCVBQcnXEUOYuhoET4Tme8R41so2q6TPbFZw1bOqdJZ6Dvzdb9mnGFmZlQwNihc9BNr5VJg++Jd9fQm6vVXXnYK9hmMs6agCZs2pOSNvz6A5Gdy+rld90fLfrbd8EaFt5KJ60KmjUC3Kgc71NiGzFBMyxNJqYvClSetwSDjvCRKuclSOLmOxwu0Yisa4KOdjpjBZi7k2NnwJoWbOUdyw2BPIxlKpR8F8SFBEB/l45x2rYOTOFuEa2lHluAilL6Dtanmv+boGd9hyI0La6E6Q+5qloDkLxlXQn3bk/NgHQluyPgTlCM6UahOqStcdRsgxoCIE9t35u6ZMXnxb05ogvMnegGfDagtBt36TB1Eq5LLlgXcSAb7DYuzJgOPupYT6rFWyOV1OkHup1YgmnAcnBh+iPjeMAiBGpniTrT2/50kWo/g2ZNZ8jzAZb9aB9Y5vkHJGraNwotE5YQNdwHmdveKxD0ky9izuwtDaYaaEZ7hhbmxoGyvgpMPbWLpttdDtsaF1ssqoAlay3y/cZQ9+vFA2fjwlHlEMyFHLu5MAy5AxPHYJnDhEjyTzSoJlza96IDLHg+5KchcbyM2bCg+nCBdjGWngcfNljHGTPCyid4vhfens7RPi/L3RrapkETkKWYBttg2GRyhw+h/XCmaIFGG9aAN8sR7IO51H25h9yucq5wBtIINlzfcIVmEVnCtWF8voPUsLM2JCipjngXyGomTnNcKYFz2Q8nApdDuJSLaMIYyyADw1NbjsfN/rgTLmWgQzxYseQOnLKtYCrHvKiCL4QtEcxoX+iQe+b0OwpNKehxAJx6t4am4OMOsYIoP70IRpveebKR8S+I9TkOJWVwwrwF5EunEUdJDwMyQFhVLSTyQEMxiiFEPsQU1EIxFeg1ng9zWt5Sai/vwQyVPYfR3MGfOhoF8xNltmbg4wmzcNIMi4iotjjHHoiq0zPWby0SDUZkPQbTsS3aYMDy3YtcGASpoT4p5nsFC86KJCGpV/Q6+BD761SZDryOMr6TaQweom9JCKpYqv1HsmMW4QDwlCU9ueNso2gpk592FHGEPHsRGGl80mmQRVec/EM91cDYvLrnvQFSW9Lmw0ZQzB/MLBOaHw01YRZiY0bPChoEN0fcvAgLlN3N9iHm6A822vHjSnScYzc7Pg3EAiZIlPD4LMMtg6sr0hiSmRhVB8RQik619z6LbJoNukRLeBsDCZmTgZ1lPg7bEAfWY1PdZ9C+YxcWwPAnnPISMjRb/yolPfPiO5SrINJFZfsgzIVRPvDvSNyeAGWE/lvgMTjkMPDATNbShaseNA82KzPKx4jS7nw48oniZ4A5iCGtuerqqNHb2ChxHolubrsg5RhfsIuh1VjEB7rn13zrNHDYajy7zHseqTw3vt9bJDxDrNU6yPzPtHLRl8EsffmDrStxg3pXUhZkzUtaga5jZRcujhd4vxWwMg9Rydsr+15fg9rIfuuubXCZ/cY9yV18iyOhX8keEJf9LBUp1LAVCGg5qNZplpGqOJB5T8c723aysr3VtCuiUgGDpDtw6vk12jO8DnSYNAnYIgPRdQEgoF3wCFMmxUi+gPhn7N6uMONblQxBWoVjGfIizY9UXsKKVQKBQoBQ0CkqKgrUX6c8a7f5kL2SslgXo75k3xCdcQ36Z6OgqFYhlwXUmMeGb4M8Z7r1Q5KwDHCOV8qMpZoVAsC3qMZz9gPJvp0iugB+zQ8evURhgKhUKxdAr6I8azF7r0S6+ci25LrtjWc2eFQqEK2g0/YTz7Upd+qZWzDWmfIh4Za4ayQqFQBe2ODxnP/kmXfqlhPefE8bucRhgKhUKxlAqaiqd6vWrp4Vx1zfivJ65QKBQLgf8JMACS6gb+74x/LgAAAABJRU5ErkJggg==',
	    VECTOR_CREDIT_LOGO = 'data:image/svg+xml;base64,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',
	    VECTOR_CHECKOUT_REVERSE_LOGO = 'data:image/svg+xml;base64,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';
	module.exports = {
	    BN_CODE: 'JavaScriptButtons_{label}',
	    PAYPAL_URL: 'https://{host}/cgi-bin/webscr',
	    QR_URL: 'https://{host}/webapps/ppint/qrcode?data={url}&pattern={pattern}&height={size}',
	    QR_PATTERN: 13,
	    QR_SIZE: 250,
	    LIMITS: {
	        width: {
	            min: 100,
	            max: 500
	        },
	        height: {
	            min: 24,
	            max: 100
	        },
	        length: {
	            max: 60
	        },
	        length_with_wordmark: {
	            max: 40
	        }
	    },
	    PRETTY_PARAMS: {
	        name: 'item_name',
	        number: 'item_number',
	        locale: 'lc',
	        currency: 'currency_code',
	        recurrence: 'p3',
	        period: 't3',
	        callback: 'notify_url',
	        button_id: 'hosted_button_id'
	    },
	    WIDGET_NAME: 'paypal-button-widget',
	    DEFAULT_HOST: 'www.paypal.com',
	    DEFAULT_TYPE: 'button',
	    DEFAULT_LABEL: 'buynow',
	    DEFAULT_SIZE: 'large',
	    DEFAULT_STYLE: 'primary',
	    DEFAULT_LOCALE: 'en_US',
	    DEFAULT_ENV: 'www',
	    STRINGS: {"en_AD":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AD":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AD":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AD":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_AE":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_AE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_AG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_AI":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AI":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AI":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AI":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_AL":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AL":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AL":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AL":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_AM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_AN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AN":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AN":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AN":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_AO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AO":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AO":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AO":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_AR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AR":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AR":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AR":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"de_AT":{"buynow":"Kaufen mit {wordmark}","buynow_nowordmark":"Jetzt kaufen","cart":"In den Warenkorb","donate":"Spenden mit {wordmark}","donate_nowordmark":"Spenden","subscribe":"Abonnieren mit {wordmark}","subscribe_nowordmark":"Abonnieren","paynow":"Jetzt bezahlen mit {wordmark}","paynow_nowordmark":"Jetzt bezahlen","login":"Einloggen mit {wordmark}","login_nowordmark":"Einloggen","item_name":"Artikel","number":"Nummer","amount":"Betrag","quantity":"Anzahl","checkout":"Direkt zu {wordmark}","checkout_tag":"Einfach schneller und sicherer bezahlen","credit":"{wordmark}","credit_tag":"Kaufen Sie jetzt und bezahlen Sie nach und nach."},"en_AT":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_AU":{"buynow":"Buy with {wordmark}","cart":"Add to Cart","donate":"Donate with {wordmark}","subscribe":"Subscribe with {wordmark}","paynow":"Pay now with {wordmark}","login":"Log In with {wordmark}","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"en_AW":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AW":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AW":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AW":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_AZ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_AZ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_AZ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_AZ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BB":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BB":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BB":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BB":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Pay with {wordmark}","checkout_tag":"The safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"fr_BE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer avec {wordmark}","paynow_nowordmark":"Payer","login":"Connexion avec {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Le réflexe sécurité pour payer","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"nl_BE":{"buynow":"Kopen met {wordmark}","buynow_nowordmark":"Nu kopen","cart":"Toevoegen aan winkelwagentje","donate":"Doneren met {wordmark}","donate_nowordmark":"Doneren","subscribe":"Abonneren met {wordmark}","subscribe_nowordmark":"Abonneren","paynow":"Nu betalen met {wordmark}","paynow_nowordmark":"Nu betalen","login":"Inloggen met {wordmark}","login_nowordmark":"Inloggen","item_name":"Object","number":"Nummer","amount":"Bedrag","quantity":"Hoeveelheid","checkout":"Betalen met {wordmark}","checkout_tag":"De veiligere en snellere manier om te betalen.","credit":"{wordmark}","credit_tag":"Koop nu. Betaal later."},"en_BF":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BF":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BF":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BF":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_BH":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_BH":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BH":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BH":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BH":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BI":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BI":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BI":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BI":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BJ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BJ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BJ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BJ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_BO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BO":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BO":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BO":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"pt_BR":{"buynow":"Comprar com {wordmark}","buynow_nowordmark":"Comprar agora","cart":"Adicionar ao carrinho","donate":"Doar com {wordmark}","donate_nowordmark":"Doar","subscribe":"Assinar com {wordmark}","subscribe_nowordmark":"Assinar","paynow":"Pagar agora com {wordmark}","paynow_nowordmark":"Pagar agora","login":"Log in com {wordmark}","login_nowordmark":"Log in","item_name":"Produto","number":"Número","amount":"Valor","quantity":"Quantidade","checkout":"{wordmark} Finalizar","checkout_tag":"A maneira fácil e segura de enviar pagamentos.","credit":"{wordmark} Crédito","credit_tag":"Compre agora e pague depois."},"en_BS":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BS":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BS":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BS":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BT":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_BW":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BW":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BW":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BW":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BY":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BY":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BY":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BY":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_BZ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_BZ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_BZ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_BZ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_C2":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay.","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"zh_C2":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式。","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"fr_CA":{"buynow":"Achetez avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"Souscrire avec {wordmark}","subscribe_nowordmark":"S'abonner","paynow":"Payez maintenant avec {wordmark}","paynow_nowordmark":"Payer maintenant","login":"Se connecter à {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"{wordmark} Payer","checkout_tag":"Votre réflexe sécurité pour payer","credit":"{wordmark} Crédit","credit_tag":"Acheter. Payer plus tard."},"en_CD":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CD":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CD":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CD":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"de_CH":{"buynow":"Kaufen mit {wordmark}","buynow_nowordmark":"Jetzt kaufen","cart":"In den Warenkorb","donate":"Spenden mit {wordmark}","donate_nowordmark":"Spenden","subscribe":"Abonnieren mit {wordmark}","subscribe_nowordmark":"Abonnieren","paynow":"Jetzt bezahlen mit {wordmark}","paynow_nowordmark":"Jetzt bezahlen","login":"Einloggen mit {wordmark}","login_nowordmark":"Einloggen","item_name":"Artikel","number":"Nummer","amount":"Betrag","quantity":"Anzahl","checkout":"Direkt zu {wordmark}","checkout_tag":"Einfach schneller und sicherer bezahlen","credit":"{wordmark}","credit_tag":"Kaufen Sie jetzt und bezahlen Sie nach und nach."},"en_CH":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"fr_CH":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer avec {wordmark}","paynow_nowordmark":"Payer","login":"Connexion avec {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Le réflexe sécurité pour payer","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"en_CI":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CI":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CI":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CI":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CK":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CK":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CK":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CK":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CL":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CL":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CL":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CL":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"zh_CN":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订用","subscribe_nowordmark":"订用","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark} Credit","credit_tag":"立即购买，分期付款。"},"en_CO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CO":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CO":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CO":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CR":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CR":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CR":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CV":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CV":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CV":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CV":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CY":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CY":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CY":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CY":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_CZ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_CZ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_CZ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_CZ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"de_DE":{"buynow":"Kaufen mit {wordmark}","buynow_nowordmark":"Jetzt kaufen","cart":"In den Warenkorb","donate":"Spenden mit {wordmark}","donate_nowordmark":"Spenden","subscribe":"Abonnieren mit {wordmark}","subscribe_nowordmark":"Abonnieren","paynow":"Jetzt bezahlen mit {wordmark}","paynow_nowordmark":"Jetzt zahlen","login":"Einloggen mit {wordmark}","login_nowordmark":"Einloggen","item_name":"Artikel","number":"Nummer","amount":"Betrag","quantity":"Anzahl","checkout":"Direkt zu {wordmark}","checkout_tag":"Überall schnell und sicher bezahlen.","credit":"{wordmark} Kredit","credit_tag":"Kaufen Sie jetzt und bezahlen Sie nach und nach."},"en_DE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"en_DJ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_DJ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_DJ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_DJ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"da_DK":{"buynow":"Køb med {wordmark}","cart":"Læg i indkøbsvogn","donate":"Doner med {wordmark}","subscribe":"Abonner med {wordmark}","paynow":"Betal nu med {wordmark}","item_name":"Vare","number":"Nummer","amount":"Beløb","quantity":"Antal","checkout":"{wordmark} Betal","checkout_tag":"Betal nemt og sikkert"},"en_DK":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"en_DM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_DM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_DM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_DM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_DO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_DO":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_DO":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_DO":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_DZ":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_DZ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_DZ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_DZ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_DZ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_EC":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_EC":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_EC":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_EC":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_EE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_EE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_EE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"ru_EE":{"buynow":"Оплатить через {wordmark}","buynow_nowordmark":"Купить сейчас","cart":"Добавить в корзину","donate":"Отправить пожертвование через {wordmark}","donate_nowordmark":"Отправить пожертвование","subscribe":"Оплатить подписку через {wordmark}","subscribe_nowordmark":"Подписаться","paynow":"Оплатить сейчас через {wordmark}","paynow_nowordmark":"Оплатить сейчас","login":"Войти через {wordmark}","login_nowordmark":"Войти","item_name":"Товар","number":"Номер","amount":"Сумма","quantity":"Количество","checkout":"Оформить заказ через {wordmark}","checkout_tag":"Более безопасный и простой способ оплаты.","credit":"{wordmark}","credit_tag":"Покупайте сейчас, платите потом."},"zh_EE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_EG":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_EG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_EG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_EG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_EG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_ER":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_ER":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_ER":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_ER":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_ES":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"es_ES":{"buynow":"Comprar con {wordmark}","cart":"Añadir al carro","donate":"Donar con {wordmark}","subscribe":"Suscribirse con {wordmark}","paynow":"Pagar ahora con {wordmark}","login":"Identificarse con {wordmark}","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar"},"en_ET":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_ET":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_ET":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_ET":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_FI":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_FI":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_FI":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_FI":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_FJ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_FJ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_FJ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_FJ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_FK":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_FK":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_FK":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_FK":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_FM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"da_FO":{"buynow":"Køb med {wordmark}","buynow_nowordmark":"Køb nu","cart":"Læg i indkøbsvogn","donate":"Doner med {wordmark}","donate_nowordmark":"Doner","subscribe":"Abonner med {wordmark}","subscribe_nowordmark":"Abonner","paynow":"Betal nu med {wordmark}","paynow_nowordmark":"Betal nu","login":"Log på med {wordmark}","login_nowordmark":"Log på","item_name":"Vare","number":"Nummer","amount":"Beløb","quantity":"Antal","checkout":"Betal med {wordmark}","checkout_tag":"Betal nemt og sikkert","credit":"{wordmark}","credit_tag":"Køb nu, betal senere."},"en_FO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_FO":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_FO":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_FO":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_FR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Pay","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"fr_FR":{"buynow":"Acheter avec {wordmark}","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","subscribe":"S'abonner avec {wordmark}","paynow":"Payer maintenant avec {wordmark}","login":"Connexion avec {wordmark}","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"{wordmark} Payer"},"en_GA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GB":{"buynow":"Buy with {wordmark}","cart":"Add to Cart","donate":"Donate with {wordmark}","subscribe":"Subscribe with {wordmark}","paynow":"Pay now with {wordmark}","login":"Log In with {wordmark}","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"en_GD":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GD":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GD":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GD":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GF":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GF":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GF":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GF":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GI":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GI":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GI":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GI":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"da_GL":{"buynow":"Køb med {wordmark}","buynow_nowordmark":"Køb nu","cart":"Læg i indkøbsvogn","donate":"Doner med {wordmark}","donate_nowordmark":"Doner","subscribe":"Abonner med {wordmark}","subscribe_nowordmark":"Abonner","paynow":"Betal nu med {wordmark}","paynow_nowordmark":"Betal nu","login":"Log på med {wordmark}","login_nowordmark":"Log på","item_name":"Vare","number":"Nummer","amount":"Beløb","quantity":"Antal","checkout":"Betal med {wordmark}","checkout_tag":"Betal nemt og sikkert","credit":"{wordmark}","credit_tag":"Køb nu, betal senere."},"en_GL":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GL":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GL":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GL":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GN":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GN":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GN":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GP":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GP":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GP":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GP":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GR":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GR":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GR":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GT":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GT":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GT":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GT":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GW":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GW":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GW":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GW":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_GY":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_GY":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_GY":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_GY":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_HK":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"zh_HK":{"buynow":"{wordmark} 購物","buynow_nowordmark":"立即買","cart":"加到購物車","donate":"{wordmark} 捐款","donate_nowordmark":"捐款","subscribe":"{wordmark} 訂用","subscribe_nowordmark":"訂用","paynow":"{wordmark} 立即付款","paynow_nowordmark":"立即付款","login":"使用 {wordmark} 登入","login_nowordmark":"登入","item_name":"物品","number":"號碼","amount":"金額","quantity":"數量","checkout":"{wordmark} 結帳","checkout_tag":"更安全、更方便的付款方式","credit":"{wordmark} 信貸","credit_tag":"先購買，後付款。"},"en_HN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_HN":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_HN":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_HN":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_HR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_HR":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_HR":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_HR":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_HU":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_HU":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_HU":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_HU":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_ID":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"id_ID":{"buynow":"Beli dengan {wordmark}","buynow_nowordmark":"Beli Sekarang","cart":"Tambah ke Keranjang","donate":"Donasikan dengan {wordmark}","donate_nowordmark":"Donasikan","subscribe":"Berlangganan dengan {wordmark}","subscribe_nowordmark":"Berlangganan","paynow":"Bayar sekarang dengan {wordmark}","paynow_nowordmark":"Bayar sekarang","login":"Log In dengan {wordmark}","login_nowordmark":"Log In","item_name":"Barang","number":"Nomor","amount":"Jumlah","quantity":"Jumlah","checkout":"{wordmark} Check Out","checkout_tag":"Cara yang lebih mudah dan aman untuk membayar.","credit":"{wordmark} Kredit","credit_tag":"Beli Sekarang. Bayar dalam Jangka Waktu Tertentu."},"en_IE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_IE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_IE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_IE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_IL":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"he_IL":{"buynow":"קנה באמצעות {wordmark}","buynow_nowordmark":"קנה עכשיו","cart":"הוסף לסל הקניות","donate":"תרום באמצעות {wordmark}","donate_nowordmark":"תרום","subscribe":"הצטרף כמנוי באמצעות {wordmark}","subscribe_nowordmark":"הצטרף כמנוי","paynow":"שלם עכשיו באמצעות {wordmark}","paynow_nowordmark":"שלם עכשיו","login":"היכנס באמצעות {wordmark}","login_nowordmark":"כניסה","item_name":"פריט","number":"מספר","amount":"סכום","quantity":"כמות","checkout":"{wordmark} שלם","checkout_tag":".הדרך הקלה והבטוחה יותר לשלם","credit":"{wordmark} אשראי","credit_tag":"קנה עכשיו. שלם לאורך זמן."},"en_IN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay.","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_IS":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_IS":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_IS":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_IS":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_IT":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"it_IT":{"buynow":"Compra con {wordmark}","buynow_nowordmark":"Paga adesso","cart":"Aggiungi al carrello","donate":"Fai una donazione con {wordmark}","donate_nowordmark":"Dona","subscribe":"Iscriviti con {wordmark}","subscribe_nowordmark":"Iscriviti","paynow":"Paga adesso con {wordmark}","paynow_nowordmark":"Paga adesso","login":"Accedi con {wordmark}","login_nowordmark":"Accedi","item_name":"Oggetto","number":"Numero","amount":"Importo","quantity":"Quantità","checkout":"{wordmark} Paga adesso","checkout_tag":"Il modo rapido e sicuro per pagare","credit":"{wordmark} Credito","credit_tag":"Acquista ora. Paga più tardi."},"en_JM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_JM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_JM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_JM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_JO":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_JO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_JO":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_JO":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_JO":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_JP":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"ja_JP":{"buynow":"{wordmark}で購入","buynow_nowordmark":"購入","cart":"カートに入れる","donate":"{wordmark}で寄付する","donate_nowordmark":"寄付する","subscribe":"{wordmark}で定期購入する","subscribe_nowordmark":"定期購入する","paynow":"{wordmark}で支払う","paynow_nowordmark":"支払う","login":"{wordmark}でログイン","login_nowordmark":"ログイン","item_name":"商品","number":"番号","amount":"金額","quantity":"数量","checkout":"{wordmark}で支払う","checkout_tag":"より安全・簡単にお支払い","credit":"{wordmark} Credit","credit_tag":"今すぐ購入して、分割してお支払い。"},"en_KE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_KE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_KE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_KE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_KG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_KG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_KG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_KG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_KH":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_KI":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_KI":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_KI":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_KI":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_KM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_KM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_KM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_KM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_KN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_KN":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_KN":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_KN":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_KR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay.","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"ko_KR":{"buynow":"{wordmark}로 구매","buynow_nowordmark":"바로 구매","cart":"카트에 추가","donate":"{wordmark}로 기부","donate_nowordmark":"기부","subscribe":"{wordmark}로 구독","subscribe_nowordmark":"구독","paynow":"{wordmark}로 결제","paynow_nowordmark":"바로 결제","login":"{wordmark}로 로그인","login_nowordmark":"로그인","item_name":"상품","number":"번호","amount":"금액","quantity":"수량","checkout":"{wordmark} 체크 아웃","checkout_tag":"더 안전하고 빠른 결제 방법","credit":"{wordmark}","credit_tag":"지금 구매하고 천천히 결제하세요."},"ar_KW":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_KW":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_KW":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_KW":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_KW":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_KY":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_KY":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_KY":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_KY":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_KZ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_KZ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_KZ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_KZ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_LA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_LC":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_LC":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_LC":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_LC":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_LI":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_LI":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_LI":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_LI":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_LK":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_LS":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_LS":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_LS":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_LS":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_LT":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_LT":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_LT":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"ru_LT":{"buynow":"Оплатить через {wordmark}","buynow_nowordmark":"Купить сейчас","cart":"Добавить в корзину","donate":"Отправить пожертвование через {wordmark}","donate_nowordmark":"Отправить пожертвование","subscribe":"Оплатить подписку через {wordmark}","subscribe_nowordmark":"Подписаться","paynow":"Оплатить сейчас через {wordmark}","paynow_nowordmark":"Оплатить сейчас","login":"Войти через {wordmark}","login_nowordmark":"Войти","item_name":"Товар","number":"Номер","amount":"Сумма","quantity":"Количество","checkout":"Оформить заказ через {wordmark}","checkout_tag":"Более безопасный и простой способ оплаты.","credit":"{wordmark}","credit_tag":"Покупайте сейчас, платите потом."},"zh_LT":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"de_LU":{"buynow":"Kaufen mit {wordmark}","buynow_nowordmark":"Jetzt kaufen","cart":"In den Warenkorb","donate":"Spenden mit {wordmark}","donate_nowordmark":"Spenden","subscribe":"Abonnieren mit {wordmark}","subscribe_nowordmark":"Abonnieren","paynow":"Jetzt bezahlen mit {wordmark}","paynow_nowordmark":"Jetzt bezahlen","login":"Einloggen mit {wordmark}","login_nowordmark":"Einloggen","item_name":"Artikel","number":"Nummer","amount":"Betrag","quantity":"Anzahl","checkout":"Direkt zu {wordmark}","checkout_tag":"Einfach schneller und sicherer bezahlen","credit":"{wordmark}","credit_tag":"Kaufen Sie jetzt und bezahlen Sie nach und nach."},"en_LU":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_LU":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_LU":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_LU":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_LV":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_LV":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_LV":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"ru_LV":{"buynow":"Оплатить через {wordmark}","buynow_nowordmark":"Купить сейчас","cart":"Добавить в корзину","donate":"Отправить пожертвование через {wordmark}","donate_nowordmark":"Отправить пожертвование","subscribe":"Оплатить подписку через {wordmark}","subscribe_nowordmark":"Подписаться","paynow":"Оплатить сейчас через {wordmark}","paynow_nowordmark":"Оплатить сейчас","login":"Войти через {wordmark}","login_nowordmark":"Войти","item_name":"Товар","number":"Номер","amount":"Сумма","quantity":"Количество","checkout":"Оформить заказ через {wordmark}","checkout_tag":"Более безопасный и простой способ оплаты.","credit":"{wordmark}","credit_tag":"Покупайте сейчас, платите потом."},"zh_LV":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_MA":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_MA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MC":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MC":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MC":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MC":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MD":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MD":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MD":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MD":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_ME":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_ME":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_ME":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_ME":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MH":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MH":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MH":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MH":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MK":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MK":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MK":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MK":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_ML":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_ML":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_ML":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_ML":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_MQ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MQ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MQ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MQ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MR":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MR":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MR":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MS":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MS":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MS":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MS":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MT":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MT":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MT":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MT":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MU":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MU":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MU":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MU":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MV":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_MW":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MW":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MW":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MW":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_MX":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check out","checkout_tag":"The safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MX":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"Pagar con {wordmark}","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"en_MY":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay.","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_MZ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_MZ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_MZ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_MZ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_NA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_NA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_NA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_NA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_NC":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_NC":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_NC":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_NC":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_NE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_NE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_NE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_NE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_NF":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_NF":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_NF":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_NF":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_NG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_NG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_NG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_NG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_NI":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_NI":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_NI":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_NI":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_NL":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"nl_NL":{"buynow":"Kopen met {wordmark}","cart":"Toevoegen aan winkelwagentje","donate":"Doneren met {wordmark}","subscribe":"Abonneren met {wordmark}","paynow":"Nu betalen met {wordmark}","login":"Inloggen met {wordmark}","item_name":"Object","number":"Nummer","amount":"Bedrag","quantity":"Hoeveelheid","checkout":"{wordmark} Betalen","checkout_tag":"Een veilige en makkelijke manier om te betalen."},"en_NO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"no_NO":{"buynow":"Kjøp med {wordmark}","buynow_nowordmark":"Kjøp nå","cart":"Legg i kurven","donate":"Doner med {wordmark}","donate_nowordmark":"Doner","subscribe":"Abonner med {wordmark}","subscribe_nowordmark":"Abonner","paynow":"Betal nå med {wordmark}","paynow_nowordmark":"Betal nå","login":"Logg på med {wordmark}","login_nowordmark":"Logg på","item_name":"Artikkel","number":"Nummer","amount":"Beløp","quantity":"Antall","checkout":"{wordmark} Betal","checkout_tag":"En trygg og enkel betalingsmetode","credit":"{wordmark} Kreditt","credit_tag":"Kjøp nå, betal senere."},"en_NP":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_NR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_NR":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_NR":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_NR":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_NU":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_NU":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_NU":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_NU":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_NZ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay.","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_NZ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar.","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_NZ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"{wordmark} Payer","checkout_tag":"Un réflexe sécurité.","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_NZ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式。","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_OM":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_OM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_OM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_OM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_OM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_PA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_PA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_PA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_PA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_PE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_PE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_PE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_PE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_PF":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_PF":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_PF":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_PF":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_PG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_PG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_PG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_PG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_PH":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay.","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_PL":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"pl_PL":{"buynow":"Kup w systemie {wordmark}","buynow_nowordmark":"Kup teraz","cart":"Dodaj do koszyka","donate":"Przekaż darowiznę w systemie {wordmark}","donate_nowordmark":"Przekaż darowiznę","subscribe":"Subskrybuj w systemie {wordmark}","subscribe_nowordmark":"Subskrybuj","paynow":"Zapłać teraz w systemie {wordmark}","paynow_nowordmark":"Zapłać teraz","login":"Zaloguj się z {wordmark}","login_nowordmark":"Zaloguj się","item_name":"Przedmiot","number":"Numer","amount":"Kwota","quantity":"Ilość","checkout":"{wordmark} Do kasy","checkout_tag":"Płać wygodnie i bezpiecznie","credit":"{wordmark} Credit","credit_tag":"Kup teraz. Płać w ratach"},"en_PM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_PM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_PM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_PM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_PN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_PN":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_PN":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_PN":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_PT":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"pt_PT":{"buynow":"Compre com {wordmark}","buynow_nowordmark":"Comprar agora","cart":"Adicionar ao carrinho de compras","donate":"Doar com {wordmark}","donate_nowordmark":"Doar","subscribe":"Subscrever com {wordmark}","subscribe_nowordmark":"Subscrever","paynow":"Pague agora com {wordmark}","paynow_nowordmark":"Pagar agora","login":"Iniciar sessão com {wordmark}","login_nowordmark":"Iniciar sessão","item_name":"Artigo","number":"Número","amount":"Valor","quantity":"Quantidade","checkout":"{wordmark} Checkout","checkout_tag":"A forma rápida e segura de pagar","credit":"{wordmark} Crédito","credit_tag":"Compre agora. Vá pagando."},"en_PW":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_PW":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_PW":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_PW":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_PY":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_PY":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_PY":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_PY":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_QA":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_QA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_QA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_QA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_QA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_RE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_RE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_RE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_RE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_RO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_RO":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_RO":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_RO":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_RS":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_RS":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_RS":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_RS":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_RU":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"ru_RU":{"buynow":"Оплатить через {wordmark}","buynow_nowordmark":"Купить сейчас","cart":"Добавить в корзину","donate":"Сделать пожертвование через {wordmark}","donate_nowordmark":"Сделать пожертвование","subscribe":"Оплатить подписку через {wordmark}","subscribe_nowordmark":"Оформить подписку","paynow":"Оплатить сейчас с помощью {wordmark}","paynow_nowordmark":"Оплатить сейчас","login":"Войти в систему с помощью {wordmark}","login_nowordmark":"Войти","item_name":"Товар","number":"Номер","amount":"Сумма","quantity":"Количество","checkout":"{wordmark}Оформить покупку","checkout_tag":"Более безопасный и простой способ оплаты.","credit":"{wordmark}Кредит","credit_tag":"Покупайте сейчас, платите потом."},"en_RW":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_RW":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_RW":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_RW":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_SA":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_SA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SB":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SB":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SB":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SB":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SC":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SC":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SC":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SC":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"sv_SE":{"buynow":"Betala med {wordmark}","cart":"Lägg till i kundvagn","donate":"Donera med {wordmark}","subscribe":"Abonnera med {wordmark}","paynow":"Betala nu med {wordmark}","login":"Logga in med {wordmark}","item_name":"Objekt","number":"Nummer","amount":"Belopp","quantity":"Antal","checkout":"{wordmark} Betala","checkout_tag":"Ett tryggt och smidigt sätt att betala"},"en_SG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay.","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_SH":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SH":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SH":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SH":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SI":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SI":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SI":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SI":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SJ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SJ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SJ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SJ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SK":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SK":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SK":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SK":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SL":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SL":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SL":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SL":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SN":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SN":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SN":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SO":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SO":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SO":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SR":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SR":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SR":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_ST":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_ST":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_ST":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_ST":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SV":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SV":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SV":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SV":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_SZ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_SZ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_SZ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_SZ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_TC":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_TC":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_TC":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_TC":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_TD":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_TD":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_TD":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_TD":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_TG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_TG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_TG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_TG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_TH":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"th_TH":{"buynow":"ซื้อด้วย {wordmark}","buynow_nowordmark":"ซื้อทันที","cart":"เพิ่มสินค้าลงในตะกร้า","donate":"บริจาคด้วย {wordmark}","donate_nowordmark":"บริจาค","subscribe":"บอกรับสมาชิกด้วย {wordmark}","subscribe_nowordmark":"บอกรับ","paynow":"ชำระทันทีด้วย {wordmark}","paynow_nowordmark":"ชำระทันที","login":"เข้าสู่ระบบด้วย {wordmark}","login_nowordmark":"เข้าสู่ระบบ","item_name":"รายการสินค้า","number":"หมายเลข","amount":"จำนวนเงิน","quantity":"ปริมาณ","checkout":"{wordmark} ชำระเงิน","checkout_tag":"วิธีชำระเงินที่ปลอดภัยและง่ายกว่า","credit":"{wordmark} เครดิต","credit_tag":"ซื้อวันนี้ แล้วค่อยๆ จ่ายทีหลัง"},"en_TJ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_TJ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_TJ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_TJ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_TM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_TM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_TM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_TM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_TN":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_TN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_TN":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_TN":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_TN":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_TO":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_TR":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"tr_TR":{"buynow":"{wordmark} ile Satın Alın","buynow_nowordmark":"Hemen Satın Alın","cart":"Sepete Ekleyin","donate":"{wordmark} ile Bağışta Bulunun","donate_nowordmark":"Bağış Yapın","subscribe":"{wordmark} ile Abone Olun","subscribe_nowordmark":"Abone Olun","paynow":"{wordmark} ile Hemen Ödeyin","paynow_nowordmark":"Hemen ödeyin","login":"{wordmark} ile Giriş Yapın","login_nowordmark":"Giriş","item_name":"Ürün","number":"Numarası","amount":"Tutar","quantity":"Miktar","checkout":"{wordmark} ile Satın Alın","checkout_tag":"Ödeme yapmanın daha güvenli ve kolay yolu","credit":"{wordmark} Credit","credit_tag":"Şimdi Alın. Daha Sonra Ödeyin."},"en_TT":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_TT":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_TT":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_TT":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_TV":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_TV":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_TV":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_TV":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_TW":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark} Credit","credit_tag":"Buy Now. Pay Over Time."},"zh_TW":{"buynow":"使用 {wordmark} 購買","buynow_nowordmark":"立即購","cart":"加到購物車","donate":"使用 {wordmark} 捐款","donate_nowordmark":"捐款","subscribe":"使用 {wordmark} 訂閱","subscribe_nowordmark":"訂閱","paynow":"使用 {wordmark} 立即付款","paynow_nowordmark":"立即付款","login":"使用 {wordmark} 登入","login_nowordmark":"登入","item_name":"商品","number":"號碼","amount":"金額","quantity":"數量","checkout":"{wordmark} 結帳","checkout_tag":"更安全、更方便的付款方式","credit":"{wordmark} 信貸","credit_tag":"先購買，後付款。"},"en_TZ":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_TZ":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_TZ":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_TZ":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_UA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_UA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_UA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"ru_UA":{"buynow":"Оплатить через {wordmark}","buynow_nowordmark":"Купить сейчас","cart":"Добавить в корзину","donate":"Отправить пожертвование через {wordmark}","donate_nowordmark":"Отправить пожертвование","subscribe":"Оплатить подписку через {wordmark}","subscribe_nowordmark":"Подписаться","paynow":"Оплатить сейчас через {wordmark}","paynow_nowordmark":"Оплатить сейчас","login":"Войти через {wordmark}","login_nowordmark":"Войти","item_name":"Товар","number":"Номер","amount":"Сумма","quantity":"Количество","checkout":"Оформить заказ через {wordmark}","checkout_tag":"Более безопасный и простой способ оплаты.","credit":"{wordmark}","credit_tag":"Покупайте сейчас, платите потом."},"zh_UA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_UG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_UG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_UG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_UG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_US":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check out","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_US":{"buynow":"Compre con {wordmark}","cart":"Añadir al carro","donate":"Donar con {wordmark}","subscribe":"Suscribir con {wordmark}","paynow":"Pagar ahora con {wordmark}","login":"Identificarse con {wordmark}","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"Pagar con {wordmark}","checkout_tag":"La forma rápida y segura de pagar"},"fr_US":{"buynow":"Acheter avec {wordmark}","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","subscribe":"S'abonner avec {wordmark}","paynow":"Payer maintenant avec {wordmark}","login":"Connexion avec {wordmark}","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"{wordmark} Payer","checkout_tag":"Votre réflexe sécurité pour payer en ligne"},"zh_US":{"buynow":"使用{wordmark}购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","subscribe":"使用{wordmark}订用","paynow":"使用{wordmark}立即付款","login":"通过{wordmark}登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"使用{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式"},"en_UY":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_UY":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_UY":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_UY":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_VA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_VA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_VA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_VA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_VC":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_VC":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_VC":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_VC":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_VE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_VE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_VE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_VE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_VG":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_VG":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_VG":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_VG":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_VN":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log In","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"{wordmark} Check Out","checkout_tag":"A safer, faster way to pay.","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"en_VU":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_VU":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_VU":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_VU":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_WF":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_WF":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_WF":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_WF":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_WS":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_WS":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_WS":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_WS":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"ar_YE":{"buynow":"شراء باستخدام {wordmark}","buynow_nowordmark":"شراء الآن","cart":"إضافة إلى سلة التسوق","donate":"تبرع باستخدام {wordmark}","donate_nowordmark":"تبرع","subscribe":"اشتراك باستخدام {wordmark}","subscribe_nowordmark":"اشتراك","paynow":"الدفع الآن باستخدام {wordmark}","paynow_nowordmark":"الدفع الآن","login":"تسجيل الدخول باستخدام {wordmark}","login_nowordmark":"تسجيل الدخول","item_name":"البند","number":"الرقم","amount":"المبلغ","quantity":"الكمية","checkout":"السداد بواسطة {wordmark}","checkout_tag":"الطريقة الأسهل والأكثر أماناً في الدفع","credit":"{wordmark}","credit_tag":"اشترِ الآن، وسدّد على دفعات"},"en_YE":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_YE":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_YE":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_YE":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_YT":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_YT":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_YT":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_YT":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_ZA":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_ZA":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_ZA":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_ZA":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_ZM":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_ZM":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_ZM":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_ZM":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"},"en_ZW":{"buynow":"Buy with {wordmark}","buynow_nowordmark":"Buy Now","cart":"Add to Cart","donate":"Donate with {wordmark}","donate_nowordmark":"Donate","subscribe":"Subscribe with {wordmark}","subscribe_nowordmark":"Subscribe","paynow":"Pay now with {wordmark}","paynow_nowordmark":"Pay Now","login":"Log In with {wordmark}","login_nowordmark":"Log in","item_name":"Item","number":"Number","amount":"Amount","quantity":"Quantity","checkout":"Check out with {wordmark}","checkout_tag":"The safer, easier way to pay","credit":"{wordmark}","credit_tag":"Buy Now. Pay Over Time."},"es_ZW":{"buynow":"Comprar con {wordmark}","buynow_nowordmark":"Comprar ahora","cart":"Agregar al carrito","donate":"Donar con {wordmark}","donate_nowordmark":"Donar","subscribe":"Suscribirse a {wordmark}","subscribe_nowordmark":"Suscribirse","paynow":"Pagar ahora con {wordmark}","paynow_nowordmark":"Pagar ahora","login":"Iniciar sesión en {wordmark}","login_nowordmark":"Iniciar sesión","item_name":"Artículo","number":"Número","amount":"Importe","quantity":"Cantidad","checkout":"{wordmark} Pagar","checkout_tag":"La forma rápida y segura de pagar","credit":"{wordmark}","credit_tag":"Compre ahora y pague más adelante."},"fr_ZW":{"buynow":"Acheter avec {wordmark}","buynow_nowordmark":"Acheter","cart":"Ajouter au panier","donate":"Faire un don avec {wordmark}","donate_nowordmark":"Faire un don","subscribe":"S'abonner avec {wordmark}","subscribe_nowordmark":"Souscrire","paynow":"Payer maintenant avec {wordmark}","paynow_nowordmark":"Payer ","login":"Connexion par {wordmark}","login_nowordmark":"Connexion","item_name":"Objet","number":"Numéro","amount":"Montant","quantity":"Quantité","checkout":"Payer avec {wordmark}","checkout_tag":"Votre réflexe sécurité pour payer en ligne","credit":"{wordmark}","credit_tag":"Achetez maintenant et payez plus tard."},"zh_ZW":{"buynow":"使用{wordmark}购买","buynow_nowordmark":"立即购买","cart":"添加到购物车","donate":"使用{wordmark}捐赠","donate_nowordmark":"捐赠","subscribe":"使用{wordmark}订购","subscribe_nowordmark":"订购","paynow":"使用{wordmark}立即付款","paynow_nowordmark":"立即付款","login":"使用{wordmark}登录","login_nowordmark":"登录","item_name":"物品","number":"号码","amount":"金额","quantity":"数量","checkout":"{wordmark}结账","checkout_tag":"更安全、更便捷的付款方式","credit":"{wordmark}","credit_tag":"立即购买，分期付款。"}},
	    STYLES: '.paypal-button {    white-space: nowrap;    overflow: hidden;    margin: 0;    padding: 0;    background: 0;    border: 0;    font-family: "Helvetica Neue", Helvetica, Arial, sans-serif !important;    text-transform: none;    font-weight: 500;    -webkit-font-smoothing: antialiased;    font-smoothing: antialiased;    cursor: pointer;    z-index: 0;}.paypal-button-logo {    display: inline-block;    border: 1px solid #aaa;    border-right: 0;    border-radius: 3px 0 0 3px;    vertical-align: top;    box-sizing: content-box !important;}.paypal-button-content {    padding: 4px 8px 4px;    border: 1px solid transparent;    border-radius: 0 3px 3px 0;    min-width: 57px !important;    box-sizing: content-box !important;}.paypal-button-content img {    vertical-align: middle;    padding: 0 !important;    display: inline !important;    background: none !important;    border: none !important;    box-sizing: content-box !important;}/* Small */.paypal-button-logo {    width: 24px;    height: 24px;}.paypal-button-logo img {    width: 18px;    height: 18px;    margin: 3px 0 0 -1px;    padding: 0 !important;    display: inline !important;    background: none !important;    border: none !important;    box-sizing: content-box !important;}.paypal-button-content {    height: 16px;    display:inline-block;    font-size: 9.5px !important;    line-height: 16px !important;}.paypal-button-content img {    width: 63px;    height: 16px;    margin: 1px 0 0 1px;}.paypal-button-tag-content{    line-height: 10px;    width: 100%;    font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;    font-weight: normal;    font-size: 9.25px;    color: #003366;    display: inline-block;    width: 80%;    margin-top: -1px;    margin-top: -1px;}/* Medium */.paypal-button.paypal-size-medium .paypal-button-logo {    width: 30px;    height: 30px;}.paypal-button.paypal-size-medium .paypal-button-logo img {    width: 22px;    height: 22px;    margin: 4px 0 0 0px;}.paypal-button.paypal-size-medium .paypal-button-content {    height: 19px;    font-size: 10px !important;    line-height: 19px !important;    padding: 5px 8px 6px;    min-width: 71px !important;}.paypal-button.paypal-size-medium .paypal-button-content img {    width: 71px;    height: 19px;    margin: 2px 0 0 1px;}/* Large */.paypal-button.paypal-size-large .paypal-button-logo {    width: 42px;    height: 42px;}.paypal-button.paypal-size-large .paypal-button-logo img {    width: 30px;    height: 30px;    margin: 6px 0 0 -1px;}.paypal-button.paypal-size-large .paypal-button-content {    height: 25px;    font-size: 13px !important;    line-height: 25px !important;    padding: 8px 13px 9px;    min-width: 109px !important;}.paypal-button.paypal-size-large .paypal-button-content img {    width: 93px;    height: 25px;    margin: 2px 0 0 2px;}/* Primary */.paypal-button.paypal-style-primary .paypal-button-content {    background: #009cde;    border-color: #009cde;    color: #fff;}/* Secondary */.paypal-button.paypal-style-secondary .paypal-button-logo {    border: 1px solid #cfcfcf;    border-right: 0;}.paypal-button.paypal-style-secondary .paypal-button-content {    background: #eee;    border-color: #cfcfcf;    color: #333;}/* tertiary *//* legacy yellow checkout button*/.paypal-button.paypal-style-tertiary {    line-height: 11.4px;}.paypal-style-tertiary.paypal-size-small {    max-width: 144px;    overflow: visible;    display: block;}.paypal-button.paypal-style-tertiary .paypal-button-logo {    display: none;}.paypal-button.paypal-style-tertiary .paypal-button-content {    height: 14px;    white-space: nowrap;    overflow: hidden;    font-family: "Arial Black", gadget, sans-serif;    font-weight: bolder;    font-style: italic;    border: 1px solid #ffa823;    color: #003366;    background: #ffa823;    position: relative;    cursor: pointer;    z-index: 0;    border-top-left-radius: 30px;    border-top-right-radius: 30px;    border-bottom-left-radius: 30px;    border-bottom-right-radius: 30px;    /*border-radius: 30px;*/    line-height: 9px !important;    letter-spacing: -0.5px;}.paypal-button.paypal-style-tertiary .paypal-button-content:after {    content: " ";    position: absolute;    width: 98%;    height: 60%;    /*border-radius: 40px 40px 68px 68px;*/    border-top-left-radius: 40px;    border-top-right-radius: 40px;    border-bottom-left-radius: 68px;    border-bottom-right-radius: 68px;    top: 0;    left: 0;    background: -webkit-linear-gradient(top, #fefefe 0%, #fed994 100%);    background: -moz-linear-gradient(top, #fefefe 0%, #fed994 100%);    background: -ms-linear-gradient(top, #fefefe 0%, #fed994 100%);    background: linear-gradient(top, #fefefe 0%, #fed994 100%);    z-index: -1;    -webkit-transform: translateX(1%);    -moz-transform: translateX(1%);    -ms-transform: translateX(1%);    transform: translateX(1%);}.paypal-button.paypal-style-tertiary .paypal-button-content span {    white-space: normal;    display: inline-block;    width: 60px;    margin-top: -2px;    margin-right: 3px;    margin-left: -2px;    padding-left: 5px;    padding-right: 3px;}.pt_BR.paypal-style-tertiary .paypal-button-content span {    padding-left: 3px;    padding-right: 5px;}.de_DE.paypal-style-tertiary .paypal-button-content span {    width: 70px;    margin-left: -8px;    margin-right: 4px;}.fr_CA.paypal-style-tertiary .paypal-button-content span {    width: 56px;    margin-left: -3px;    margin-right: 0;}.en_US.paypal-style-tertiary .paypal-button-content span,.en_GB.paypal-style-tertiary .paypal-button-content span,.en_AU.paypal-style-tertiary .paypal-button-content span,.da_DK.paypal-style-tertiary .paypal-button-content span,.zh_HK.paypal-style-tertiary .paypal-button-content span,.zh_CN.paypal-style-tertiary .paypal-button-content span,.ja_JP.paypal-style-tertiary .paypal-button-content span,.pl_PL.paypal-style-tertiary .paypal-button-content span,.sv_SE.paypal-style-tertiary .paypal-button-content span,.zh_TW.paypal-style-tertiary .paypal-button-content span,.th_TH.paypal-style-tertiary .paypal-button-content span{    margin-top: 3px;}.ja_JP.paypal-style-tertiary .paypal-button-content span:first-child {    width: 5px;}.ja_JP.paypal-style-tertiary .paypal-button-content span:last-child {    width: 46px;}.zh_CN.paypal-style-tertiary .paypal-button-content span {    width: 24px;}.es_ES.paypal-style-tertiary .paypal-button-content span {    width: 41px;    margin-left: 8px;}.fr_FR.paypal-style-tertiary .paypal-button-content span {    width: 49px;    margin-left: 6px;}.it_IT.paypal-style-tertiary .paypal-button-content span {    width: 44px;    margin-left: 5px;    margin-right: 3px;}.tr_TR.paypal-style-tertiary .paypal-button-content span {    width: 46px;    margin-left: 0;    margin-right: 1px;}.he_IL.paypal-style-tertiary {    unicode-bidi: embed;    direction: rtl;}.zh_HK.paypal-style-tertiary .paypal-button-content span {    width: 20px;    margin-left: 15px;    margin-right: 26px;    margin-top: -2px;}.he_IL.paypal-style-tertiary .paypal-button-content span {    width: 44px;    margin-left: 5px;    margin-right: 6px;}.nl_NL.paypal-style-tertiary .paypal-button-content span {    width: 40px;    margin-left: 9px;    margin-right: 12px;    margin-top: -2px;}.no_NO.paypal-style-tertiary .paypal-button-content span {    margin-top: 3px;}.paypal-button.paypal-style-tertiary .paypal-button-content img {    vertical-align: top;    margin-left: -7px;    margin-right: 4px;}.pt_BR.paypal-style-tertiary .paypal-button-content img {    margin-left: -3px;    margin-right: 0;}.es_ES.paypal-style-tertiary .paypal-button-content img,.it_IT.paypal-style-tertiary .paypal-button-content img {    margin-right: 13px;}.fr_FR.paypal-style-tertiary .paypal-button-content img{    margin-right: 7px;}.fr_CA.paypal-style-tertiary .paypal-button-content img {    margin-right: 5px;    vertical-align: middle;    margin-left: 0;}.zh_CN.paypal-style-tertiary .paypal-button-content img {    margin: 0;}.de_DE.paypal-style-tertiary .paypal-button-content img {    margin-right: -1px;}.he_IL.paypal-style-tertiary .paypal-button-content img {    margin-left: 7px;    margin-right: -4px;}.ja_JP.paypal-style-tertiary .paypal-button-content img,.tr_TR.paypal-style-tertiary .paypal-button-content img {    margin-left: 7px;}.fr_CA .paypal-button-tag-content {    width: 70%;    white-space: normal;    margin-top: 0;}.id_ID .paypal-button-tag-content,.nl_NL .paypal-button-tag-content,.no_NO .paypal-button-tag-content,.pt_BR .paypal-button-tag-content,.ru_RU .paypal-button-tag-content,.sv_SE .paypal-button-tag-content,.tr_TR .paypal-button-tag-content {    width: 80%;    white-space: normal;    margin-top: 0;}.he_IL .paypal-button-tag-content,.pt_PT .paypal-button-tag-content  {    width: 100%;    white-space: normal;    margin-top: 0;}.es_ES .paypal-button-tag-content,.th_TH .paypal-button-tag-content {    width: 100%;}.de_DE.paypal-style-tertiary .paypal-button-content,.fr_FR.paypal-style-tertiary .paypal-button-content {    line-height: 9px !important;}/*NEW CREDIT BUTTON*/.paypal-button.paypal-style-quaternary .paypal-button-content {    padding-top: 0;    padding-bottom: 0;    background: #003087;    color: white;    text-shadow: 0px -1px 0 #0d86bb;    text-transform: uppercase;    font-style: italic;    font-weight: bold;    position: relative;}.paypal-button.paypal-style-quaternary.paypal-size-small .paypal-button-content::before {    content: "";    padding: 1px;    top: -1px;    left: -1px;    position: absolute;    z-index: -1;    width: 100%;    height: 100%;    border-top-left-radius: 14px;    border-bottom-left-radius: 14px;    border-top-right-radius: 14px;    border-bottom-right-radius: 14px;    background:       -webkit-gradient(linear, 0 0, 0 100%, from(#f5f5f5), to(#cccccc)) 0 100% !important;    background:       -webkit-linear-gradient(#f5f5f5, #cccccc) 0 100%;    background:      -moz-linear-gradient(#f5f5f5, #cccccc) 0 100%;        background:      -o-linear-gradient(#f5f5f5, #cccccc) 0 100%;    background:      linear-gradient(to bottom, #f5f5f5, #cccccc) 0 100% !important;}.paypal-style-quaternary .paypal-button-logo {    display: none;    }.paypal-button.paypal-style-quaternary.paypal-size-small {    max-width: auto !important;    width: auto;}.paypal-button.paypal-style-quaternary.paypal-size-small .paypal-button-content {    height: 24px !important;    max-height: 24px !important;    padding-left: 6px;    padding-right: 6px;    margin-left: 2px;    margin-top: 2px;    width: 130px;    display: inline-block;    overflow: visible;    border-top-left-radius: 12px;    border-bottom-left-radius: 12px;    border-top-right-radius: 12px;    border-bottom-right-radius: 12px;    border: none;    font-size: 11px !important;    line-height: 26px !important;    vertical-align: middle;    margin-right: 3px;}.paypal-button.paypal-style-quaternary.paypal-size-small .paypal-button-content img {    height: 16px;    width: 100px !important;    line-height: 32px;    margin-top: -3px;    padding-right: 10px;}.paypal-button.paypal-style-quaternary.paypal-size-small .paypal-button-tag-content {  line-height: 11px;  font-size: 9px;  margin-top: 2px;  color: #003366;  display: block;  text-align: center;  width: auto;}/* override: rectangle shape vs default pill-shape*/.paypal-button.paypal-style-quaternary.paypal-size-small.paypal-shape-rect .paypal-button-content::before {    border-top-left-radius: 4px;    border-bottom-left-radius: 4px;    border-top-right-radius: 4px;    border-bottom-right-radius: 4px;}.paypal-button.paypal-style-quaternary.paypal-size-small.paypal-shape-rect .paypal-button-content {    border-top-left-radius: 4px;    border-bottom-left-radius: 4px;    border-top-right-radius: 4px;    border-bottom-right-radius: 4px;}.paypal-button.paypal-style-quaternary.paypal-size-medium .paypal-button-content {    height: 30px !important;    max-height: 30px !important;    padding-left: 6px;    padding-right: 6px;    margin-left: 2px;    margin-top: 1px;    width: 210px;    display: inline-block;    overflow: visible;    border-top-left-radius: 15px;    border-bottom-left-radius: 15px;    border-top-right-radius: 15px;    border-bottom-right-radius: 15px;    border: none;    font-size: 12px !important;    line-height: 34px !important;    vertical-align: middle;    margin-right: 3px;}.paypal-button.paypal-style-quaternary.paypal-size-medium .paypal-button-content::before {    content: "";    padding: 2px;    top: -2px;    left: -2px;    position: absolute;    z-index: -1;    width: 100%;    height: 100%;    background:       -webkit-gradient(linear, 0 0, 0 100%, from(#f5f5f5), to(#cccccc)) 0 100%;    background:       -webkit-linear-gradient(#f5f5f5, #cccccc) 0 100%;    background:      -moz-linear-gradient(#f5f5f5, #cccccc) 0 100%;        background:      -o-linear-gradient(#f5f5f5, #cccccc) 0 100%;    background:      linear-gradient(to bottom, #f5f5f5, #cccccc) 0 100%;    border-top-left-radius: 17px;    border-bottom-left-radius: 17px;    border-top-right-radius: 17px;    border-bottom-right-radius: 17px;}.paypal-button.paypal-style-quaternary.paypal-size-medium .paypal-button-content img {    height: 20px;    width: 150px !important;    line-height: 34px;    margin-top: -4px;    padding-right: 0;}.paypal-button.paypal-style-quaternary.paypal-size-medium .paypal-button-tag-content {  line-height: 12px;  font-size: 10px;  margin-top: 4px;  color: #000;  display: block;  text-align: center;  width: auto;}/* override: rectangle shape vs default pill-shape*/.paypal-button.paypal-style-quaternary.paypal-size-medium.paypal-shape-rect .paypal-button-content::before {    border-top-left-radius: 6px;    border-bottom-left-radius: 6px;    border-top-right-radius: 6px;    border-bottom-right-radius: 6px;}.paypal-button.paypal-style-quaternary.paypal-size-medium.paypal-shape-rect .paypal-button-content {    border-top-left-radius: 6px;    border-bottom-left-radius: 6px;    border-top-right-radius: 6px;    border-bottom-right-radius: 6px;}/*NEW CHECKOUT BUTTON*/.paypal-button-widget {    overflow: visible;}.paypal-button-widget button[disabled] {    cursor: not-allowed;}.paypal-button.paypal-style-checkout .paypal-button-content {    padding-top: 0;    padding-bottom: 0;    position: relative;}.paypal-button.paypal-style-checkout.paypal-color-gold .paypal-button-content {    background: #ffc439;    color: #000;    text-shadow: 0px 1px 0 #ffdc88;}.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-content::before {    content: "";    padding: 1px;    top: -1px;    left: -1px;    position: absolute;    z-index: -1;    width: 100%;    height: 100%;    border-top-left-radius: 14px;    border-bottom-left-radius: 14px;    border-top-right-radius: 14px;    border-bottom-right-radius: 14px;}.paypal-button.paypal-style-checkout.paypal-color-gold .paypal-button-content::before {    background:       -webkit-gradient(linear, 0 0, 0 100%, from(#ffdc88), to(#d9a630)) 0 100%;    background:       -webkit-linear-gradient(#ffdc88, #d9a630) 0 100%;    background:      -moz-linear-gradient(#ffdc88, #d9a630) 0 100%;        background:      -o-linear-gradient(#ffdc88, #d9a630) 0 100%;    background:      linear-gradient(to bottom, #ffdc88, #d9a630) 0 100%;}.paypal-button.paypal-style-checkout.paypal-color-blue .paypal-button-content {    background: #009cde;    color: white;    text-shadow: 0px -1px 0 #0d86bb;}.paypal-button.paypal-style-checkout.paypal-color-blue .paypal-button-content::before {    background:       -webkit-gradient(linear, 0 0, 0 100%, from(#4dbae8), to(#0d86bb)) 0 100%;    background:       -webkit-linear-gradient(#4dbae8, #0d86bb) 0 100%;    background:      -moz-linear-gradient(#4dbae8, #0d86bb) 0 100%;        background:      -o-linear-gradient(#4dbae8, #0d86bb) 0 100%;    background:      linear-gradient(to bottom, #4dbae8, #0d86bb) 0 100%;}.paypal-button.paypal-style-checkout.paypal-color-silver .paypal-button-content {    background: #eee;    color: #000;    text-shadow: 0px -1px 0 #ccc;}.paypal-button.paypal-style-checkout.paypal-color-silver .paypal-button-content::before {    background:       -webkit-gradient(linear, 0 0, 0 100%, from(#f5f5f5), to(#cccccc)) 0 100% !important;    background:       -webkit-linear-gradient(#f5f5f5, #cccccc) 0 100%;    background:      -moz-linear-gradient(#f5f5f5, #cccccc) 0 100%;    background:      -o-linear-gradient(#f5f5f5, #cccccc) 0 100%;    background:      linear-gradient(to bottom, #f5f5f5, #cccccc) 0 100% !important;}.paypal-style-checkout .paypal-button-logo {    display: none;}.paypal-button.paypal-style-checkout.paypal-size-small {    max-width: 148px !important;    width: auto;}.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-content {    height: 24px !important;    max-height: 24px !important;    padding-left: 6px;    padding-right: 6px;    margin-left: 2px;    margin-top: 2px;    margin-right: 2px;    width: 130px;    display: inline-block;    overflow: visible;    border-top-left-radius: 12px;    border-bottom-left-radius: 12px;    border-top-right-radius: 12px;    border-bottom-right-radius: 12px;    border: none;    font-size: 10.2px !important;    line-height: 26px !important;    vertical-align: middle;}/* override: rectangle shape vs default pill-shape*/.paypal-button.paypal-style-checkout.paypal-size-small.paypal-shape-rect .paypal-button-content::before {    border-top-left-radius: 4px;    border-bottom-left-radius: 4px;    border-top-right-radius: 4px;    border-bottom-right-radius: 4px;}.paypal-button.paypal-style-checkout.paypal-size-small.paypal-shape-rect .paypal-button-content {    border-top-left-radius: 4px;    border-bottom-left-radius: 4px;    border-top-right-radius: 4px;    border-bottom-right-radius: 4px;}/* end shape override */.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-content img {    height: 20px;    line-height: 32px;    margin-top: -3px;    padding-right: 10px;    margin-right: 4px;}.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-tag-content {  line-height: 11px;  font-size: 9px;  margin-top: 3px;  color: #003366;  display: block;  text-align: center;  width: auto;}.pt_BR.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-tag-content,.id_ID.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-tag-content,.nl_NL.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-tag-content,.ru_RU.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-tag-content,.tr_TR.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-tag-content {  width: 80%;  margin: auto;}.paypal-button.paypal-style-checkout.paypal-size-tiny {    max-width: 80px !important;    width: auto;}.paypal-button.paypal-style-checkout.paypal-size-tiny .paypal-button-content {    height: 18px !important;    max-height: 18px !important;    padding-left: 5px;    padding-right: 5px;    margin-left: 2px;    margin-top: 2px;    margin-bottom: 2px;    margin-right: 2px;    width: 66px;    display: inline-block;    overflow: visible;    border-top-left-radius: 9px;    border-bottom-left-radius: 9px;    border-top-right-radius: 9px;    border-bottom-right-radius: 9px;    border: none;    font-size: 10px !important;    line-height: 20px !important;    vertical-align: middle;}.paypal-button.paypal-style-checkout.paypal-size-tiny .paypal-button-content::before {    content: "";    padding: 1px;    top: -1px;    left: -1px;    position: absolute;    z-index: -1;    width: 100%;    height: 100%;    border-top-left-radius: 10px;    border-bottom-left-radius: 10px;    border-top-right-radius: 10px;    border-bottom-right-radius: 10px;}/* override: rectangle shape vs default pill-shape*/.paypal-button.paypal-style-checkout.paypal-size-tiny.paypal-shape-rect .paypal-button-content::before {    border-top-left-radius: 3px;    border-bottom-left-radius: 3px;    border-top-right-radius: 3px;    border-bottom-right-radius: 3px;}.paypal-button.paypal-style-checkout.paypal-size-tiny.paypal-shape-rect .paypal-button-content {    border-top-left-radius: 3px;    border-bottom-left-radius: 3px;    border-top-right-radius: 3px;    border-bottom-right-radius: 3px;}/* end shape override */.paypal-button.paypal-style-checkout.paypal-size-tiny .paypal-button-content img {    height: 16px;    line-height: 24px;    margin-top: -4px;    padding-right: 0;}.paypal-button.paypal-style-checkout.paypal-size-tiny .paypal-button-tag-content {  display: none;}.paypal-button.paypal-style-checkout.paypal-size-medium {    max-width: 230px !important;    width: auto;}.paypal-button.paypal-style-checkout.paypal-size-medium .paypal-button-content {    height: 30px !important;    max-height: 30px !important;    padding-left: 6px;    padding-right: 6px;    margin-left: 2px;    margin-top: 2px;    margin-right: 2px;    width: 210px;    display: inline-block;    overflow: visible;    border-top-left-radius: 15px;    border-bottom-left-radius: 15px;    border-top-right-radius: 15px;    border-bottom-right-radius: 15px;    border: none;    font-size: 12px !important;    line-height: 34px !important;    vertical-align: middle;}.paypal-button.paypal-style-checkout.paypal-size-medium .paypal-button-content::before {    content: "";    padding: 2px;    top: -2px;    left: -2px;    position: absolute;    z-index: -1;    width: 100%;    height: 100%;    border-top-left-radius: 17px;    border-bottom-left-radius: 17px;    border-top-right-radius: 17px;    border-bottom-right-radius: 17px;}/* override: rectangle shape vs default pill-shape*/.paypal-button.paypal-style-checkout.paypal-size-medium.paypal-shape-rect .paypal-button-content::before {    border-top-left-radius: 6px;    border-bottom-left-radius: 6px;    border-top-right-radius: 6px;    border-bottom-right-radius: 6px;}.paypal-button.paypal-style-checkout.paypal-size-medium.paypal-shape-rect .paypal-button-content {    border-top-left-radius: 6px;    border-bottom-left-radius: 6px;    border-top-right-radius: 6px;    border-bottom-right-radius: 6px;}/* end shape override */.paypal-button.paypal-style-checkout.paypal-size-medium .paypal-button-content img {    height: 24px;    line-height: 34px;    margin-top: -4px;    margin-right: 4px;    padding-right: 0;}.paypal-button.paypal-style-checkout.paypal-size-medium .paypal-button-tag-content {  line-height: 12px;  font-size: 10px;  margin-top: 4px;  color: #003366;  display: block;  text-align: center;  width: auto;}.id_ID.paypal-button.paypal-style-checkout.paypal-size-medium .paypal-button-tag-content{  width: 66%;  margin: auto;}.pt_PT.paypal-button.paypal-style-checkout.paypal-size-medium .paypal-button-tag-content{  width: 80%;  margin: auto;}.pt_BR.paypal-style-checkout.paypal-size-small .paypal-button-content img {    display: inline-block;    margin-top: -4px;    margin-left: 6px;}.ru_RU.paypal-style-checkout.paypal-size-small .paypal-button-content img {    display: inline-block;    margin-top: -13px;    margin-left: 6px;}.pt_BR.paypal-style-checkout.paypal-size-small .paypal-button-content span,.ru_RU.paypal-style-checkout.paypal-size-small .paypal-button-content span {    line-height: 12px;    width: 56px;    display: inline-block;    height: 26px;    margin-right: 6px;    margin-left: 0px;    white-space: normal;}/*.nl_NL.paypal-button.paypal-style-checkout.paypal-size-small .paypal-button-content img {    height: 20px;    line-height: 32px;    margin-top: -11px;    padding-right: 10px;}*//*.nl_NL.paypal-style-checkout.paypal-size-small .paypal-button-content span {    line-height: 12px;    height: 26px;    display: inline-block;}*/.nl_NL.paypal-button.paypal-style-checkout.paypal-size-medium .paypal-button-content img {    height: 24px;    line-height: 34px;    margin-top: -5px;    margin-left: 16px;    padding-right: 0;}/*.nl_NL.paypal-style-checkout.paypal-size-medium .paypal-button-content span {    line-height: 16px;    width: 90px;    display: block;    height: 34px;    float: right;    margin-right: 24px;    white-space: normal;}*/',
	    LOGO: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAA8CAYAAAA6/NlyAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA1RJREFUeNrkmr9v01AQx99LoC1SAatCpQgJ0krQSkjgKUOllg4wIsFfABmYaTa2wMZI5g7lPyD9CxoWZnfrBJm7YFja2LHNnUlQVdWJ794PO8pXerLS1ok/vfP37l4sBVNrm+/fwKEmzKoLy//x/ZOn6w0lE/YDHFrCnvwh/AGsDvwDfNvAv+DgiGKEsB1YTQ64ZMBiGv8UxQthGwDdoZxUYXxQTZRDmGFfh15iFNgV5dI+QO+YBL4vyieMtDMrER6l9+4sAaPemQJ2Sgrs5LmXScAUcyhIru4I10oO7Mwa8ERdIf79U9anJLEQcajvqqvz1oDphpVEQp6e/IPWKQnJWbkqkuoCUFyD11UjwOSSJIM/+mFHWRP1hYQlgt9p1Af3HugrS+DQvPoLEbYiAA9ct7W8d7wPy9FhWjXuhdhSdDftenGYOMyCrphMZyOpPB72/LW2VIHpQ4NOZ6YBo3Yhyjt2U9oicLj28LIfv1YBJreV0pJhxTduivjW7ct+9ZIFPNzWEWWNcPikntk3QFq7nAgzgQfGYZP5BRFuPM7dLOUFLm0NxugidF7lBaY7tIX6i/dtv75FOsdchC1E9/TZC/I5xoBNO/QZwGY480X5HGD6lBQFRmEnGNV/nbzd8EjTEntbx0CE0Zz6W89zw4I8znhYihqMreMZwOZMY8vAGmGxiwrq25SontcBB5i+raM4JWHqDqA3Hqyup0cFdTnAZMOScUBK1fQIqZpANAfwmpi2WfoChuVzgOk1GFpKNJcgu8e1oTa5DnO3dcL1R0XDdi+Wo7x1mOXQ/c3tImHTL8q5nRY5wsncHKmZN6CPEN0eF5g8NMRLS0XColF9Vumla1MEjLAN1eGB3FbG1xeLgG3mgR1blrjbOpYjjI1FY9w9S6nDLOBk0XiER89ptbNKDxeYVYNjvcDeEBAjeDSuvuoAJjt0tLKiErVXANM1nR4VrTWYH92mDVjtwAoObQV2EjB5SuI6NMVljQBzt3WYhuUJi6roLEnMCPemElih4TgqAzB5WwenJIVaWzgwWdEdpRpcOHCbeiHcGmyr/o4kdb3R8t7xIWO66gHw6lSmNLP3turQ2oCHjwhxHiv+NpXAgv/QuD9rwN60ArNgbTs06q8AAwC1swu0LaowrwAAAABJRU5ErkJggg==',
	    VECTOR_LOGO: 'data:image/svg+xml;base64,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',
	    WORDMARK: {
	        primary: PRIMARY,
	        secondary: 'data:image/png;base64,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',
	        tertiary: 'data:image/png;base64,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',
	        quaternary: CREDIT_LOGO,
	        vector_primary: VECTOR_PRIMARY,
	        vector_secondary: 'data:image/svg+xml;base64,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',
	        vector_tertiary: 'data:image/svg+xml;base64,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',
	        vector_quaternary: VECTOR_CREDIT_LOGO,
	        checkout: CHECKOUT_LOGO,
	        vector_checkout: VECTOR_CHECKOUT_LOGO,
	        checkout_reverse: CHECKOUT_REVERSE_LOGO,
	        vector_checkout_reverse: VECTOR_CHECKOUT_REVERSE_LOGO
	    },
	    CHECKOUT_COLORS: ['gold', 'silver', 'blue'],
	    DEFAULT_CHECKOUT_COLOR: 'gold',
	    BUTTON_SHAPES: ['pill', 'rect'],
	    DEFAULT_SHAPE: 'pill',
	    CHECKOUT_NEW_UNSUPPORTED_LOCALES: [],
	    SUPPORTED_LOCALES: ['en_AD', 'es_AD', 'fr_AD', 'zh_AD',
	        'ar_AE', 'en_AE', 'es_AE', 'fr_AE', 'zh_AE',
	        'en_AG', 'es_AG', 'fr_AG', 'zh_AG',
	        'en_AI', 'es_AI', 'fr_AI', 'zh_AI',
	        'en_AL',
	        'en_AM', 'es_AM', 'fr_AM', 'zh_AM',
	        'en_AN', 'es_AN', 'fr_AN', 'zh_AN',
	        'en_AO', 'es_AO', 'fr_AO', 'zh_AO',
	        'en_AR', 'es_AR',
	        'en_AT', 'de_AT',
	        'en_AU',
	        'en_AW', 'es_AW', 'fr_AW', 'zh_AW',
	        'en_AZ', 'es_AZ', 'fr_AZ', 'zh_AZ',
	        'en_BA',
	        'en_BB', 'es_BB', 'fr_BB', 'zh_BB',
	        'en_BE', 'fr_BE', 'nl_BE',
	        'en_BF', 'es_BF', 'fr_BF', 'zh_BF',
	        'en_BG',
	        'ar_BH', 'en_BH', 'es_BH', 'fr_BH', 'zh_BH',
	        'en_BI', 'es_BI', 'fr_BI', 'zh_BI',
	        'en_BJ', 'es_BJ', 'fr_BJ', 'zh_BJ',
	        'en_BM', 'es_BM', 'fr_BM', 'zh_BM',
	        'en_BN',
	        'en_BO', 'es_BO', 'fr_BO', 'zh_BO',
	        'pt_BR',
	        'en_BS', 'es_BS', 'fr_BS', 'zh_BS',
	        'en_BT',
	        'en_BW', 'es_BW', 'fr_BW', 'zh_BW',
	        'en_BY',
	        'en_BZ', 'es_BZ', 'fr_BZ', 'zh_BZ',
	        'en_C2', 'zh_C2',
	        'fr_CA',
	        'en_CD', 'es_CD', 'fr_CD', 'zh_CD',
	        'en_CG', 'es_CG', 'fr_CG', 'zh_CG',
	        'de_CH', 'en_CH', 'fr_CH',
	        'en_CI', 'fr_CI',
	        'en_CK', 'es_CK', 'fr_CK', 'zh_CK',
	        'en_CL', 'es_CL', 'fr_CL', 'zh_CL',
	        'en_CM', 'fr_CM',
	        'zh_CN',
	        'en_CO', 'es_CO', 'fr_CO', 'zh_CO',
	        'en_CR', 'es_CR', 'fr_CR', 'zh_CR',
	        'en_CV', 'es_CV', 'fr_CV', 'zh_CV',
	        'en_CY',
	        'en_CZ', 'es_CZ', 'fr_CZ', 'zh_CZ',
	        'de_DE',
	        'en_DJ', 'es_DJ', 'fr_DJ', 'zh_DJ',
	        'da_DK',
	        'en_DM', 'es_DM', 'fr_DM', 'zh_DM',
	        'en_DO', 'es_DO', 'fr_DO', 'zh_DO',
	        'ar_DZ', 'en_DZ', 'es_DZ', 'fr_DZ', 'zh_DZ',
	        'en_EC', 'es_EC', 'fr_EC', 'zh_EC',
	        'en_EE', 'es_EE', 'fr_EE', 'ru_EE', 'zh_EE',
	        'ar_EG', 'en_EG', 'es_EG', 'fr_EG', 'zh_EG',
	        'en_ER', 'es_ER', 'fr_ER', 'zh_ER',
	        'es_ES',
	        'en_ET', 'es_ET', 'fr_ET', 'zh_ET',
	        'en_FI', 'es_FI', 'fr_FI', 'zh_FI',
	        'en_FJ', 'es_FJ', 'fr_FJ', 'zh_FJ',
	        'en_FK', 'es_FK', 'fr_FK', 'zh_FK',
	        'en_FM',
	        'da_FO', 'en_FO', 'es_FO', 'fr_FO', 'zh_FO',
	        'fr_FR',
	        'en_GA', 'es_GA', 'fr_GA', 'zh_GA',
	        'en_GB',
	        'en_GD', 'es_GD', 'fr_GD', 'zh_GD',
	        'en_GE', 'es_GE', 'fr_GE', 'zh_GE',
	        'en_GF', 'es_GF', 'fr_GF', 'zh_GF',
	        'en_GI', 'es_GI', 'fr_GI', 'zh_GI',
	        'da_GL', 'en_GL', 'es_GL', 'fr_GL', 'zh_GL',
	        'en_GM', 'es_GM', 'fr_GM', 'zh_GM',
	        'en_GN', 'es_GN', 'fr_GN', 'zh_GN',
	        'en_GP', 'es_GP', 'fr_GP', 'zh_GP',
	        'en_GR', 'es_GR', 'fr_GR', 'zh_GR',
	        'en_GT', 'es_GT', 'fr_GT', 'zh_GT',
	        'en_GW', 'es_GW', 'fr_GW', 'zh_GW',
	        'en_GY', 'es_GY', 'fr_GY', 'zh_GY',
	        'zh_HK',
	        'en_HN', 'es_HN', 'fr_HN', 'zh_HN',
	        'en_HR',
	        'en_HU', 'es_HU', 'fr_HU', 'zh_HU',
	        'id_ID',
	        'en_IE', 'es_IE', 'fr_IE', 'zh_IE',
	        'he_IL',
	        'en_IN',
	        'en_IS',
	        'it_IT',
	        'en_JM', 'es_JM', 'fr_JM', 'zh_JM',
	        'ar_JO', 'en_JO', 'es_JO', 'fr_JO', 'zh_JO',
	        'ja_JP',
	        'en_KE', 'es_KE', 'fr_KE', 'zh_KE',
	        'en_KG', 'es_KG', 'fr_KG', 'zh_KG',
	        'en_KH',
	        'en_KI', 'es_KI', 'fr_KI', 'zh_KI',
	        'en_KM', 'es_KM', 'fr_KM', 'zh_KM',
	        'en_KN', 'es_KN', 'fr_KN', 'zh_KN',
	        'en_KR', 'ko_KR',
	        'ar_KW', 'en_KW', 'es_KW', 'fr_KW', 'zh_KW',
	        'en_KY', 'es_KY', 'fr_KY', 'zh_KY',
	        'en_KZ', 'es_KZ', 'fr_KZ', 'zh_KZ',
	        'en_LA',
	        'en_LC', 'es_LC', 'fr_LC', 'zh_LC',
	        'en_LI', 'es_LI', 'fr_LI', 'zh_LI',
	        'en_LK',
	        'en_LS', 'es_LS', 'fr_LS', 'zh_LS',
	        'en_LT', 'es_LT', 'fr_LT', 'ru_LT', 'zh_LT',
	        'de_LU', 'en_LU', 'es_LU', 'fr_LU', 'zh_LU',
	        'en_LV', 'es_LV', 'fr_LV', 'ru_LV', 'zh_LV',
	        'ar_MA', 'en_MA', 'es_MA', 'fr_MA', 'zh_MA',
	        'en_MC', 'fr_MC',
	        'en_MD',
	        'en_ME',
	        'en_MG', 'es_MG', 'fr_MG', 'zh_MG',
	        'en_MH', 'es_MH', 'fr_MH', 'zh_MH',
	        'en_MK',
	        'en_ML', 'es_ML', 'fr_ML', 'zh_ML',
	        'en_MN',
	        'en_MQ', 'es_MQ', 'fr_MQ', 'zh_MQ',
	        'en_MR', 'es_MR', 'fr_MR', 'zh_MR',
	        'en_MS', 'es_MS', 'fr_MS', 'zh_MS',
	        'en_MT',
	        'en_MU', 'es_MU', 'fr_MU', 'zh_MU',
	        'en_MV',
	        'en_MW', 'es_MW', 'fr_MW', 'zh_MW',
	        'en_MX', 'es_MX',
	        'en_MY',
	        'en_MZ', 'es_MZ', 'fr_MZ', 'zh_MZ',
	        'en_NA', 'es_NA', 'fr_NA', 'zh_NA',
	        'en_NC', 'es_NC', 'fr_NC', 'zh_NC',
	        'en_NE', 'es_NE', 'fr_NE', 'zh_NE',
	        'en_NF', 'es_NF', 'fr_NF', 'zh_NF',
	        'en_NG',
	        'en_NI', 'es_NI', 'fr_NI', 'zh_NI',
	        'nl_NL',
	        'no_NO',
	        'en_NP',
	        'en_NR', 'es_NR', 'fr_NR', 'zh_NR',
	        'en_NU', 'es_NU', 'fr_NU', 'zh_NU',
	        'en_NZ', 'es_NZ', 'fr_NZ', 'zh_NZ',
	        'ar_OM', 'en_OM', 'es_OM', 'fr_OM', 'zh_OM',
	        'en_PA', 'es_PA', 'fr_PA', 'zh_PA',
	        'en_PE', 'es_PE', 'fr_PE', 'zh_PE',
	        'en_PF', 'es_PF', 'fr_PF', 'zh_PF',
	        'en_PG', 'es_PG', 'fr_PG', 'zh_PG',
	        'en_PH',
	        'pl_PL',
	        'en_PM', 'es_PM', 'fr_PM', 'zh_PM',
	        'en_PN', 'es_PN', 'fr_PN', 'zh_PN',
	        'pt_PT',
	        'en_PW', 'es_PW', 'fr_PW', 'zh_PW',
	        'en_PY', 'es_PY',
	        'ar_QA', 'en_QA', 'es_QA', 'fr_QA', 'zh_QA',
	        'en_RE', 'es_RE', 'fr_RE', 'zh_RE',
	        'en_RO', 'es_RO', 'fr_RO', 'zh_RO',
	        'en_RS', 'es_RS', 'fr_RS', 'zh_RS',
	        'ru_RU',
	        'en_RW', 'es_RW', 'fr_RW', 'zh_RW',
	        'ar_SA', 'en_SA', 'es_SA', 'fr_SA', 'zh_SA',
	        'en_SB', 'es_SB', 'fr_SB', 'zh_SB',
	        'en_SC', 'es_SC', 'fr_SC', 'zh_SC',
	        'sv_SE',
	        'en_SG',
	        'en_SH', 'es_SH', 'fr_SH', 'zh_SH',
	        'en_SI', 'es_SI', 'fr_SI', 'zh_SI',
	        'en_SJ', 'es_SJ', 'fr_SJ', 'zh_SJ',
	        'en_SK', 'es_SK', 'fr_SK', 'zh_SK',
	        'en_SL', 'es_SL', 'fr_SL', 'zh_SL',
	        'en_SM', 'es_SM', 'fr_SM', 'zh_SM',
	        'en_SN', 'es_SN', 'fr_SN', 'zh_SN',
	        'en_SO', 'es_SO', 'fr_SO', 'zh_SO',
	        'en_SR', 'es_SR', 'fr_SR', 'zh_SR',
	        'en_ST', 'es_ST', 'fr_ST', 'zh_ST',
	        'en_SV', 'es_SV', 'fr_SV', 'zh_SV',
	        'en_SZ', 'es_SZ', 'fr_SZ', 'zh_SZ',
	        'en_TC', 'es_TC', 'fr_TC', 'zh_TC',
	        'en_TD', 'es_TD', 'fr_TD', 'zh_TD',
	        'en_TG', 'es_TG', 'fr_TG', 'zh_TG',
	        'th_TH',
	        'en_TJ', 'es_TJ', 'fr_TJ', 'zh_TJ',
	        'en_TM', 'es_TM', 'fr_TM', 'zh_TM',
	        'ar_TN', 'en_TN', 'es_TN', 'fr_TN', 'zh_TN',
	        'en_TO',
	        'tr_TR',
	        'en_TT', 'es_TT', 'fr_TT', 'zh_TT',
	        'en_TV', 'es_TV', 'fr_TV', 'zh_TV',
	        'zh_TW',
	        'en_TZ', 'es_TZ', 'fr_TZ', 'zh_TZ',
	        'en_UA', 'es_UA', 'fr_UA', 'ru_UA', 'zh_UA',
	        'en_UG', 'es_UG', 'fr_UG', 'zh_UG',
	        'en_US', 'es_US', 'fr_US', 'zh_US',
	        'en_UY', 'es_UY', 'fr_UY', 'zh_UY',
	        'en_VA', 'es_VA', 'fr_VA', 'zh_VA',
	        'en_VC', 'es_VC', 'fr_VC', 'zh_VC',
	        'en_VE', 'es_VE', 'fr_VE', 'zh_VE',
	        'en_VG', 'es_VG', 'fr_VG', 'zh_VG',
	        'en_VN',
	        'en_VU', 'es_VU', 'fr_VU', 'zh_VU',
	        'en_WF', 'es_WF', 'fr_WF', 'zh_WF',
	        'en_WS',
	        'ar_YE', 'en_YE', 'es_YE', 'fr_YE', 'zh_YE',
	        'en_YT', 'es_YT', 'fr_YT', 'zh_YT',
	        'en_ZA', 'es_ZA', 'fr_ZA', 'zh_ZA',
	        'en_ZM', 'es_ZM', 'fr_ZM', 'zh_ZM',
	        'en_ZW'],
	    CHECKOUT_SIZES: ['tiny', 'small', 'medium']
	};


/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var DataStore = __webpack_require__(2),
	    constants = __webpack_require__(3),
	    button = __webpack_require__(5),
	    css = __webpack_require__(17).css,
	    form = __webpack_require__(21),
	    QR = __webpack_require__(22),
	    dynamic = __webpack_require__(8),
	    assign = __webpack_require__(12),
	    checkoutConfig = __webpack_require__(10),
	    hasCss = false;
	
	function sanitizeNumber(obj) {
	    return !isNaN(parseFloat(obj)) && parseFloat(obj);
	}
	
	function solveConstraints(data, attrName) {
	    if (data.get(attrName)) {
	        var attrNum = sanitizeNumber(data.pluck(attrName)),
	            min = constants.LIMITS[attrName].min,
	            max = constants.LIMITS[attrName].max;
	        return Math.min(Math.max(attrNum, max), min);
	    }
	}
	module.exports = function factory(business, raw, config, parent) {
	    var data, wrapper, html, key, label, type;
	    var buttonEl, requestedHeight, requestedWidth, finalHeight, finalWidth, renderedWidth, heightWidthRatio,
	        dynamicCssModel, tagLineEl, tagLineHeight, locale;
	    if (!business) {
	        return false;
	    }
	
	    // Normalize incoming data if needed
	    if (raw.items) {
	        data = raw;
	    } else {
	        data = new DataStore();
	        for (key in raw) {
	            if (raw.hasOwnProperty(key)) {
	                data.add(key, raw[key]);
	            }
	        }
	    }
	    // sanitize and validate length and width
	    requestedWidth = solveConstraints(data, 'width');
	    requestedHeight = solveConstraints(data, 'height');
	    // Defaults
	    config = config || {};
	    label = config.label || constants.DEFAULT_LABEL;
	    type = config.type || constants.DEFAULT_TYPE;
	    locale = data.get('lc') || constants.DEFAULT_LOCALE;
	    
	    //special case labels
	    switch (label) {
	    case 'checkout':
	        assign(config, checkoutConfig.getConfig(label, data, config, locale));
	        break;
	    case 'credit':
	        config.style = 'quaternary';
	        break;
	    default:
	        if (config.style === 'checkout') {
	          assign(config, checkoutConfig.getConfig(label, data, config, locale));
	        }
	        break;
	    }
	    //special case button types
	    var specials = ['cart', 'donate', 'subscribe'];
	    switch (type) {
	    case 'cart':
	        data.add('cmd', '_cart');
	        data.add('add', true);
	        break;
	    case 'donate':
	        data.add('cmd', '_donations');
	        break;
	    case 'subscribe':
	        data.add('cmd', '_xclick-subscriptions');
	        if (data.get('amount') && !data.get('a3')) {
	            data.add('a3', data.pluck('amount'));
	        }
	        break;
	    default:
	        break;
	    }
	
	    if (specials.indexOf(type) === -1) {
	        // Buy Now
	        if (data.get('hosted_button_id')) {
	            data.add('cmd', '_s-xclick');
	        } else {
	            data.add('cmd', '_xclick');
	        }
	    }
	    // Add common data
	    data.add('business', business);
	    data.add('bn', constants.BN_CODE.replace(/\{label\}/, label));
	    // Inject the CSS onto the page
	    if (!hasCss) {
	        hasCss = true;
	        css.inject(document.getElementsByTagName('head')[0], constants.STYLES);
	    }
	    // If there is *either* a custom width or height,
	    // then set the size to large and calculate an approximate ratio
	    // first with the given label
	    if (type !== 'qr' && (requestedHeight || requestedWidth)) {
	        config.size = 'large'; // baseline for ratio
	        wrapper = document.createElement('span');
	        wrapper.className = constants.WIDGET_NAME;
	        wrapper.innerHTML = button(label, data, config, locale);
	        wrapper.style.visibility = 'hidden';
	        parent.appendChild(wrapper);
	        buttonEl = wrapper.children[0];
	        heightWidthRatio = (buttonEl.offsetHeight - 2) / buttonEl.offsetWidth; // -2 because borders
	        tagLineEl = wrapper.querySelectorAll('paypal-button-tag-content');
	        tagLineHeight = tagLineEl[0] ? tagLineEl[0].offsetHeight : 0;
	        parent.removeChild(wrapper);
	        // now, if the height is not given, we calculate an optimal height given the width
	        // otherwise we just use the supplied height
	        finalHeight = requestedHeight || Math.floor(requestedWidth * heightWidthRatio);
	        data.add('height', finalHeight.toString());
	        // the width is either what's specified or interpolated
	        finalWidth = requestedWidth || Math.floor(finalHeight / heightWidthRatio);
	        data.add('width', finalWidth.toString());
	        //Base on product requirement, dimensions of checkout buttons are fixed (doesn't allow dynamic changes)
	        if (label !== 'checkout' && config.style !== 'checkout') {
	            // we generate some dynamic CSS largely based on the height
	            dynamicCssModel = dynamic.cssModelUsing(finalHeight, finalWidth, tagLineHeight);
	            css.inject(document.getElementsByTagName('head')[0], dynamic.generateCssUsing(dynamicCssModel));
	            // we again re-insert the element to determine the actual width
	            wrapper.innerHTML = button(label, data, config, locale);
	            parent.appendChild(wrapper);
	            buttonEl = wrapper.children[0];
	            renderedWidth = buttonEl.offsetWidth;
	            parent.removeChild(wrapper);
	            // if the final result is not as long as requested, we pad it
	            if (requestedWidth && requestedWidth > renderedWidth) {
	                dynamicCssModel.contentPaddingRight = dynamicCssModel.contentPaddingRight + Math.floor((finalWidth - renderedWidth) / 2);
	                dynamicCssModel.contentPaddingLeft = dynamicCssModel.contentPaddingLeft + Math.ceil((finalWidth - renderedWidth) / 2);
	            }
	            // we are done, and inject the corrected CSS
	            css.inject(document.getElementsByTagName('head')[0], dynamic.generateCssUsing(dynamicCssModel));
	        }
	    }
	    // Build the UI components
	    if (type === 'qr') {
	        html = QR(data, config);
	    } else if (type === 'button') {
	        html = button(label, data, config, locale);
	    } else {
	        html = form(label, data, config);
	    }
	    // Wrap it up all nice and neat and return it
	    wrapper = document.createElement('span');
	    wrapper.className = constants.WIDGET_NAME;
	    wrapper.innerHTML = html;
	    return {
	        label: label,
	        type: type,
	        el: wrapper
	    };
	};

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var template = __webpack_require__(6),
	    dynamic = __webpack_require__(8),
	    constants = __webpack_require__(3),
	    images = __webpack_require__(9),
	    assign = __webpack_require__(12),
	    getLocale = __webpack_require__(11),
	    checkoutConfig = __webpack_require__(10);
	
	//shim a few things into arrays for IE<8
	if (!Array.prototype.indexOf) {
	    __webpack_require__(13);
	}
	
	function setDefaultLabel(locale, label) {
	    return constants.STRINGS[locale][label];
	}
	
	function createSpan(txt) {
	    return (txt.length > 0) ? '<span>' + txt + '</span>' : '';
	}
	
	module.exports = function button(label, data, config, locale) {
	    var model, style, wordmarkData, logoData, labelLimit, tagBorder = false,
	        hasTag;
	
	    config = config || {};
	    locale = getLocale(locale, data.get('lc'));
	    style = config.style || constants.DEFAULT_STYLE;
	
	    // if a custom height or width is specified
	    if (data.get('height') || data.get('width')) {
	        config.size = 'custom-' + data.get('width') + '-' + data.get('height');
	    }
	
	    wordmarkData = images.getWordmark(label, style, data.get('color'), locale);
	    logoData = images.getLogo(label, style);
	
	    switch (label) {
	        case 'checkout':
	            assign(config, checkoutConfig.getConfig(label, data, config, locale));
	            break;
	        case 'credit':
	            assign(config, checkoutConfig.getConfig(label, data, config, locale));
	            break;
	        default:
	            break;
	    }
	    
	    if (data.get('id')) {
	        config.buttonId = data.get('id');
	    }
	    if (data.get('button_disabled') === 'true') {
	        config.buttonDisabled = true;
	    }
	    if (data.get('button_type')) {
	        config.buttonType = data.get('button_type');
	    }
	
	    // if a custom label is defined, use it
	    if (data.get('label')) {
	        // escape to be safe
	        label = data.get('label').replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/'/g, '&quot;').replace(/'/g, '&#039;');
	    } else {
	        if (data.get('wordmark') === 'false') {
	            label = label + '_nowordmark';
	        }
	        if (label === 'checkout') {
	            label = checkoutConfig.getLabel(config.size, data) || setDefaultLabel(locale, label);
	        } else {
	            label = setDefaultLabel(locale, label);
	        }
	    }
	
	    // sanitize the length of the label
	    labelLimit = label && label.indexOf('{wordmark}') !== -1 ? constants.LIMITS.length_with_wordmark.max : constants.LIMITS.length.max;
	    label = dynamic.magicTrimmer('{wordmark}', labelLimit, label);
	
	    //add span element for text styling purpose
	    var labelParts = (label && label.split('{wordmark}')) || [];
	
	    label = createSpan(labelParts[0]);
	
	    if (labelParts.length > 1) {
	        label = label.concat('{wordmark}', createSpan(labelParts[1]));
	    }
	
	    label = label && label.replace('{wordmark}', '<img src="' + wordmarkData + '" alt="PayPal" />');
	
	    model = {
	        style: style,
	        color: config.color || undefined,
	        size: config.size || constants.DEFAULT_SIZE,
	        logo: logoData,
	        label: label,
	        hasTagline: hasTag,
	        tagLabel: config.tagLabel,
	        tagBorder: tagBorder,
	        locale: locale,
	        shape: config.shape || constants.DEFAULT_SHAPE,
	        buttonId: config.buttonId,
	        buttonType: config.buttonType,
	        disabled: config.buttonDisabled
	    };
	
	    return template('button', model);
	};

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var templates = __webpack_require__(7);
	
	module.exports = function template(templateName, data) {
	    return templates[templateName](data);
	};
	
	// Workaround for IE 8's lack of support
	if (!String.prototype.trim) {
	    String.prototype.trim = function () {
	        return this.replace(/^\s+|\s+$/g, '');
	    };
	}

/***/ },
/* 7 */
/***/ function(module, exports) {

	function encodeHTMLSource() {  var encodeHTMLRules = { "&": "&#38;", "<": "&#60;", ">": "&#62;", '"': '&#34;', "'": '&#39;', "/": '&#47;' },  matchHTML = /&(?!#?w+;)|<|>|"|'|\//g;  return function() {    return this ? this.replace(matchHTML, function(m) {return encodeHTMLRules[m] || m;}) : this;  };};
	String.prototype.encodeHTML=encodeHTMLSource();
	var tmpl = {};
	  tmpl['button']=function anonymous(it
	/**/) {
	var encodeHTML = typeof _encodeHTML !== 'undefined' ? _encodeHTML : (function (doNotSkipEncoded) {
			var encodeHTMLRules = { "&": "&#38;", "<": "&#60;", ">": "&#62;", '"': "&#34;", "'": "&#39;", "/": "&#47;" },
				matchHTML = doNotSkipEncoded ? /[&<>"'\/]/g : /&(?!#?\w+;)|<|>|"|'|\//g;
			return function(code) {
				return code ? code.toString().replace(matchHTML, function(m) {return encodeHTMLRules[m] || m;}) : "";
			};
		}());var out='<button ';if(it.buttonId){out+='id="'+(it.buttonId || '')+'"';}out+=' ';if(it.disabled){out+='disabled';}out+=' class="paypal-button paypal-style-'+(it.style || '')+' ';if(it.color){out+='paypal-color-'+(it.color || '');}out+=' paypal-size-'+(it.size || '')+' paypal-shape-'+(it.shape || '')+' '+(it.locale || '')+'" type="'+(it.buttonType || 'submit')+'"><span class="paypal-button-logo"><img src="'+encodeHTML(it.logo || '')+'" /></span><span class="paypal-button-content">'+(it.label || '')+'</span><br><span class="paypal-button-tag-content">'+(it.tagLabel || '')+'</span></button>';return out;
	};
	  tmpl['form']=function anonymous(it
	/**/) {
	var encodeHTML = typeof _encodeHTML !== 'undefined' ? _encodeHTML : (function (doNotSkipEncoded) {
			var encodeHTMLRules = { "&": "&#38;", "<": "&#60;", ">": "&#62;", '"': "&#34;", "'": "&#39;", "/": "&#47;" },
				matchHTML = doNotSkipEncoded ? /[&<>"'\/]/g : /&(?!#?\w+;)|<|>|"|'|\//g;
			return function(code) {
				return code ? code.toString().replace(matchHTML, function(m) {return encodeHTMLRules[m] || m;}) : "";
			};
		}());var out='<form method="post" action="'+(it.url)+'" target="_top">'; var optionIdx = 0;  for (var key in it.data) { var item = it.data[key];var renderable = (item.editable || item.value instanceof Array); if (renderable) { out+='<p class="paypal-group"><label class="paypal-label">'+(item.label || it.content[key] || key); if (item.value instanceof Array) { out+='<select class="paypal-select" name="os'+(optionIdx)+'">'; for (var i = 0, len = item.value.length; i < len; i++) { var option = item.value[i].split(':');out+='<option value="'+(option[0] )+'">'+(option.join(' '))+'</option>'; } out+='</select><input type="hidden" name="on'+(optionIdx)+'" value="'+(item.label)+'">'; ++optionIdx;  } else { out+='<input type="text" id="'+(key)+'" name="'+(key)+'" value="'+(item.value)+'" class="paypal-input" />'; } out+='</label></p>'; } else { out+='<input type="hidden" name="'+(key)+'" value="'+(item.value)+'" />'; }  } out+=''+encodeHTML(it.button)+'</form>';return out;
	};
	  tmpl['qr']=function anonymous(it
	/**/) {
	var out='<img src="<%= url %>" alt="PayPal QR code" />';return out;
	};
	  tmpl['dynamic']=function anonymous(it
	/**/) {
	var out='.paypal-button.paypal-size-custom-<%= width %>-<%= height %> .paypal-button-logo {width: <%= logoWidth %>px;height: <%= logoHeight %>px;}.paypal-button.paypal-size-custom-<%= width %>-<%= height %> .paypal-button-logo img {width: <%= logo_imgWidth %>px;height: <%= logo_imgHeight %>px;margin: <%= logo_marginTop %>px 0 0 0;}.paypal-button.paypal-size-custom-<%= width %>-<%= height %> .paypal-button-content {height: <%= contentHeight %>px;font-size: <%= contentFontSize %>px !important;line-height: <%= contentLineHeight %>px !important;padding: <%= contentPaddingTop %>px <%= contentPaddingRight %>px <%= contentPaddingBottom %>px <%= contentPaddingLeft %>px;min-width: <%= contentMinWidth %>px !important;}.paypal-button.paypal-size-custom-<%= width %>-<%= height %> .paypal-button-content img {width: <%= content_imgWidth %>px;height: <%= content_imgHeight %>px;margin: <%= content_imgMarginTop %>px 0 0 <%= content_imgMarginLeft %>px;}';return out;
	};
	module.exports = tmpl;

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var template = __webpack_require__(6),
	    constants = __webpack_require__(3);
	
	function cssModelUsing(height, width, tagLineHeight) {
	    var dynamicCssModel, h, w, totalH;
	    tagLineHeight = tagLineHeight || 0;
	    totalH = parseFloat(height);
	    h = totalH - tagLineHeight;
	    w = parseFloat(width);
	    dynamicCssModel = {
	        width: w,
	        height: totalH,
	        logoWidth: h,
	        logoHeight: h - 2,
	        logo_imgWidth: h - 1 - 2 * Math.floor((h - 6) / 6),
	        logo_imgHeight: h - 1 - 2 * Math.floor((h - 6) / 6),
	        logo_marginTop: Math.floor((h - 6) / 6),
	        contentHeight: Math.floor((h + 8) / 2),
	        contentFontSize: Math.floor((h + 36) / 6),
	        contentLineHeight: Math.floor((h + 8) / 2),
	        contentPaddingTop: Math.floor((h - 8) / 4) - 1,
	        contentPaddingRight: Math.floor((5 * h + 24) / 18),
	        contentPaddingBottom: h - Math.floor((h + 8) / 2) - Math.floor((h - 8) / 4) - 1,
	        contentPaddingLeft: Math.floor((5 * h + 24) / 18),
	        contentMinWidth: 0,
	        content_imgWidth: Math.floor((11 * h + 96) / 6),
	        content_imgHeight: Math.floor((h + 8) / 2),
	        content_imgMarginTop: Math.floor((h + 8) / 20),
	        content_imgMarginLeft: Math.floor((h + 8) / 20)
	    };
	    return dynamicCssModel;
	}
	
	function generateCssUsing(cssModel) {
	    return template('dynamic', cssModel);
	}
	
	function longestIndexFirst(arr) {
	    var indexes = [],
	        i;
	    for (i = 0; i < arr.length; i += 1) {
	        indexes[i] = i;
	    }
	    indexes.sort(function reverseLengthSort(a, b) {
	        return (arr[b].length - arr[a].length) || (b - a);
	    });
	    return indexes;
	}
	
	function magicTrimmer(symbol, limit, text) {
	    var tokens = text && text.split(symbol),
	        total = 0,
	        removeCount, i, tIdx, trimOrder, amtToRemove;
	    total = 0;
	    for (i = 0; i < tokens.length; i += 1) {
	        total += tokens[i].length;
	    }
	    removeCount = Math.max(0, total - limit);
	    trimOrder = longestIndexFirst(tokens);
	    for (i = 0; i < trimOrder.length; i += 1) {
	        tIdx = trimOrder[i];
	        amtToRemove = Math.min(removeCount, tokens[tIdx].length);
	        tokens[tIdx] = tokens[tIdx].slice(0, tokens[tIdx].length - amtToRemove);
	        removeCount -= amtToRemove;
	    }
	    return tokens.join(symbol);
	}
	module.exports = {
	    cssModelUsing: cssModelUsing,
	    generateCssUsing: generateCssUsing,
	    magicTrimmer: magicTrimmer
	};

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var constants = __webpack_require__(3),
	    checkoutConfig = __webpack_require__(10);
	var svgSupported = document.implementation.hasFeature('http://www.w3.org/TR/SVG11/feature#Image', '1.1');
	
	function getWordmark(label, style, color, locale) {
	    var wordmarkData;
	    if (label === 'checkout' && checkoutConfig.getStyle(color, locale) === 'checkout') {
	        if (color && color === 'blue') {
	            style = 'checkout_reverse';
	        } else {
	            style = 'checkout';
	        }
	    }
	    if (label === 'credit') {
	        style = 'quaternary';
	    }
	    wordmarkData = constants.WORDMARK[style];
	    // prefer SVG logo if supported
	    if (svgSupported) {
	        wordmarkData = constants.WORDMARK['vector_' + style];
	    }
	    return wordmarkData;
	}
	
	function getLogo() {
	    var logoData = constants.LOGO;
	    if (svgSupported) {
	        logoData = constants.VECTOR_LOGO;
	    }
	    return logoData;
	}
	module.exports = {
	    getWordmark: getWordmark,
	    getLogo: getLogo
	};

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	var constants = __webpack_require__(3),
	    getLocale = __webpack_require__(11);
	
	function hasColor(color) {
	    return (constants.CHECKOUT_COLORS.indexOf(color) > -1);
	}
	
	function localeSupported(loc) {
	    return (constants.CHECKOUT_NEW_UNSUPPORTED_LOCALES.indexOf(loc) === -1);
	}
	
	function hasShape(shape) {
	    return (constants.BUTTON_SHAPES.indexOf(shape) > -1);
	}
	
	function getStyle(color, locale) {
	    return (localeSupported(locale)) ? 'checkout' : 'tertiary';
	}
	
	function getColor(color, locale) {
	    if (!color && getStyle(color, locale) === 'checkout') {
	        return constants.DEFAULT_CHECKOUT_COLOR;
	    }
	    if (!color) {
	        return undefined;
	    }
	    color = color.toLowerCase();
	    return (hasColor(color)) ? color : constants.DEFAULT_CHECKOUT_COLOR;
	}
	
	function getSize(dataSize, locale) {
	    var defaultSize = 'small',
	        lowerSize = (localeSupported(locale) && dataSize) ? dataSize.toLowerCase() : defaultSize,
	        hasSize = (constants.CHECKOUT_SIZES.indexOf(lowerSize) > -1);
	    return hasSize ? lowerSize : defaultSize;
	}
	
	function getLabel(size, data) {
	    var newLabel = (size.toLowerCase() === 'tiny') ? '{wordmark}' : data.get('label');
	    return newLabel;
	}
	
	function getShape(shape) {
	    shape = shape && shape.toLowerCase();
	    return (hasShape(shape)) ? shape : constants.DEFAULT_SHAPE;
	}
	
	function getConfig(label, data, config, locale) {
	    var color = data.get('color'),
	        buttonSize = data.get('size') || config.size,
	        shape = data.get('shape') || config.shape,
	        loc = getLocale(locale, data.get('lc'));
	    var configUpdate = {
	        size: getSize(buttonSize, locale),
	        style: getStyle(color, loc),
	        color: getColor(color, loc),
	        shape: getShape(shape),
	        tagLabel: (data.get('tagline') === 'false') ? '' : constants.STRINGS[loc][label + '_tag']
	    };
	    return configUpdate;
	}
	exports.getConfig = getConfig;
	exports.getStyle = getStyle;
	exports.localeSupported = localeSupported;
	exports.getLabel = getLabel;

/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var constants = __webpack_require__(3);
	
	function lower(word) {
	    return word.toLowerCase();
	}
	
	function matchLowers(dataLocale) {
	    return constants.SUPPORTED_LOCALES.map(lower).indexOf(dataLocale.toLowerCase()) > -1;
	}
	
	function getLocale(locale, dataLocale) {
	    var loc = locale || constants.DEFAULT_LOCALE;
	    if (dataLocale) {
	        if (matchLowers(dataLocale)) {
	            loc = dataLocale;
	        } else {
	            loc = constants.DEFAULT_LOCALE;
	        }
	    }
	    return loc;
	}
	
	module.exports = getLocale;

/***/ },
/* 12 */
/***/ function(module, exports) {

	'use strict';
	
	function assign(target/*, sources*/) {
		if (!target) {
			throw new Error('cannot assign to null/undefined!');
		}
		var sources = Array.prototype.slice.call(arguments, 1);
		var source;
		for (var x = 0; x < sources.length; x++) {
			source = sources[x];
			for (var key in source) {
				if (source.hasOwnProperty(key)) {
					target[key] = source[key];
				}
			}
		}
		return target;
	}
	
	
	module.exports = assign;

/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	// require any browser shims,
	// polyfills, and any other junk here.
	
	__webpack_require__(14);

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	var map = __webpack_require__(15),
	    indexOf = __webpack_require__(16);
	
	if (!Array.prototype.indexOf) {
	    Array.prototype.indexOf = function (item) {
	        return indexOf(item, this);
	    };
	}
	
	if (!Array.prototype.map) {
	    Array.prototype.map = function (iterator) {
	        return map(iterator, this);
	    };
	}

/***/ },
/* 15 */
/***/ function(module, exports) {

	module.exports = function map(iterator, arr) {
		//shim for Array.prototype.map
		var results = [];
		results.length = arr.length;
		for (var i = 0; i < arr.length; i++) {
			if (arr[i] !== undefined) {
				results[i] = iterator(arr[i], i, arr);
			}
		}
		return results;
	};

/***/ },
/* 16 */
/***/ function(module, exports) {

	module.exports = function indexOf(item, arr) {
		for (var i = 0; i < arr.length; i++) {
			if (arr[i] === item) {
				return i;
			}
		}
		return -1;
	};

/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	
	module.exports = {
		css: __webpack_require__(18),
		events: __webpack_require__(19),
		Storage: __webpack_require__(20)
	};

/***/ },
/* 18 */
/***/ function(module, exports) {

	/* jshint quotmark:double */
	
	"use strict";
	
	
	
	module.exports.add = function add(el, str) {
	    var re;
	
	    if (!el) { return false; }
	
	    if (el && el.classList && el.classList.add) {
	        el.classList.add(str);
	    } else {
	        re = new RegExp("\\b" + str + "\\b");
	
	        if (!re.test(el.className)) {
	            el.className += " " + str;
	        }
	    }
	};
	
	
	module.exports.remove = function remove(el, str) {
	    var re;
	
	    if (!el) { return false; }
	
	    if (el.classList && el.classList.remove) {
	        el.classList.remove(str);
	    } else {
	        re = new RegExp("\\b" + str + "\\b");
	
	        if (re.test(el.className)) {
	            el.className = el.className.replace(re, "");
	        }
	    }
	};
	
	
	module.exports.inject = function inject(el, str) {
	    var style;
	
	    if (!el) { return false; }
	
	    if (str) {
	        style = document.createElement("style");
	        style.type = "text/css";
	
	        if (style.styleSheet) {
	            style.styleSheet.cssText = str;
	        } else {
	            style.appendChild(document.createTextNode(str));
	        }
	
	        el.appendChild(style);
	    }
	};


/***/ },
/* 19 */
/***/ function(module, exports) {

	'use strict';
	
	
	module.exports = (function (window, document) {
	
	    var cache = [];
	
	
	    // NOOP for Node
	    if (!document) {
	        return {
	            add: function () {},
	            remove: function () {}
	        };
	    // Non-IE events
	    } else if (document.addEventListener) {
	        return {
	
	            add: function (obj, type, fn, scope) {
	                scope = scope || obj;
	
	                var wrappedFn = function (e) { fn.call(scope, e); };
	
	                obj.addEventListener(type, wrappedFn, false);
	                cache.push([obj, type, fn, wrappedFn]);
	            },
	
	            remove: function (obj, type, fn) {
	                var wrappedFn, item, len = cache.length, i;
	
	                for (i = 0; i < len; i++) {
	                    item = cache[i];
	
	                    if (item[0] === obj && item[1] === type && item[2] === fn) {
	                        wrappedFn = item[3];
	
	                        if (wrappedFn) {
	                            obj.removeEventListener(type, wrappedFn, false);
	                            delete cache[i];
	                        }
	                    }
	                }
	            }
	        };
	
	    // IE events
	    } else if (document.attachEvent) {
	        return {
	
	            add: function (obj, type, fn, scope) {
	                scope = scope || obj;
	
	                var wrappedFn = function () {
	                    var e = window.event;
	                    e.target = e.target || e.srcElement;
	
	                    e.preventDefault = function () {
	                        e.returnValue = false;
	                    };
	
	                    fn.call(scope, e);
	                };
	
	                obj.attachEvent('on' + type, wrappedFn);
	                cache.push([obj, type, fn, wrappedFn]);
	            },
	
	            remove: function (obj, type, fn) {
	                var wrappedFn, item, len = cache.length, i;
	
	                for (i = 0; i < len; i++) {
	                    item = cache[i];
	
	                    if (item[0] === obj && item[1] === type && item[2] === fn) {
	                        wrappedFn = item[3];
	
	                        if (wrappedFn) {
	                            obj.detachEvent('on' + type, wrappedFn);
	                            delete cache[i];
	                        }
	                    }
	                }
	            }
	        };
	    }
	
	})(typeof window === 'undefined' ? null : window, typeof document === 'undefined' ? null : document);

/***/ },
/* 20 */
/***/ function(module, exports) {

	'use strict';
	
	
	var Storage = module.exports = function Storage(name, duration) {
	    this._name = name;
	    this._duration = duration || 30;
	};
	
	
	var proto = Storage.prototype;
	
	
	proto.load = function () {
	    if (typeof window === 'object' && window.localStorage) {
	        var data = window.localStorage.getItem(this._name), today, expires;
	
	        if (data) {
	            data = JSON.parse(decodeURIComponent(data));
	        }
	
	        if (data && data.expires) {
	            today = new Date();
	            expires = new Date(data.expires);
	
	            if (today > expires) {
	                this.destroy();
	                return;
	            }
	        }
	
	        return data && data.value;
	    }
	};
	
	
	proto.save = function (data) {
	    if (typeof window === 'object' && window.localStorage) {
	        var expires = new Date(), wrapped;
	
	        expires.setTime(expires.getTime() + this._duration * 24 * 60 * 60 * 1000);
	
	        wrapped = {
	            value: data,
	            expires: expires.toGMTString()
	        };
	
	        window.localStorage.setItem(this._name, encodeURIComponent(JSON.stringify(wrapped)));
	    }
	};
	
	
	proto.destroy = function () {
	    if (typeof window === 'object' && window.localStorage) {
	        window.localStorage.removeItem(this._name);
	    }
	};


/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var constants = __webpack_require__(3),
	    template = __webpack_require__(6),
	    button = __webpack_require__(5);
	
	module.exports = function form(type, data, config) {
	    var model, btn, url, locale;
	
	    btn = button(type, data, config);
	    locale = data.get('lc') || constants.DEFAULT_LOCALE;
	    url = constants.PAYPAL_URL;
	    url = url.replace('{host}', config.host || constants.DEFAULT_HOST);
	
	    model = {
	        data: data.items,
	        button: btn,
	        url: url,
	        content: constants.STRINGS[locale]
	    };
	
	    return template('form', model);
	};

/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var constants = __webpack_require__(3),
	    template = __webpack_require__(6);
	
	module.exports = function Qr(data, config) {
	    var model = {}, url, key;
	    
	    // Defaults
	    config = config || {};
	    config.size = config.size || constants.QR_SIZE;
	    config.host = config.host || constants.DEFAULT_HOST;
	
	    // Construct URL
	    url = constants.PAYPAL_URL;
	    url = url.replace('{host}', config.host);
	    url = url + '?';
	
	    for (key in data.items) {
	        if (data.items.hasOwnProperty(key)) {
	            url += key + '=' + encodeURIComponent(data.get(key)) + '&';
	        }
	    }
	
	    url = encodeURIComponent(url);
	
	    // Render
	    model.url = constants.QR_URL
			.replace('{host}', config.host)
			.replace('{url}', url)
			.replace('{pattern}', constants.QR_PATTERN)
			.replace('{size}', config.size);
	
	
	    return template('qr', model);
	};


/***/ }
/******/ ]);
//# sourceMappingURL=button.js.map